/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.mdr;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import uk.me.parabola.imgfmt.app.mdr.Mdr14Record;
import uk.me.parabola.imgfmt.app.mdr.Mdr29Record;
import uk.me.parabola.imgfmt.app.mdr.Mdr2x;
import uk.me.parabola.imgfmt.app.mdr.Mdr7Record;
import uk.me.parabola.imgfmt.app.mdr.MdrConfig;

public class Mdr22
extends Mdr2x {
    public Mdr22(MdrConfig config) {
        this.setConfig(config);
    }

    public void buildFromStreets(List<Mdr7Record> inStreets) {
        ArrayList<Mdr7Record> sorted = new ArrayList<Mdr7Record>(inStreets.size());
        for (Mdr7Record street : inStreets) {
            if (street.getCity() == null) continue;
            assert (street.getCity().getCountryName() != null);
            sorted.add(street);
        }
        sorted.sort((o1, o2) -> {
            int d = Integer.compare(o1.getCity().getMdr22SortPos(), o2.getCity().getMdr22SortPos());
            if (d != 0) {
                return d;
            }
            return Integer.compare(o1.getIndex(), o2.getIndex());
        });
        int lastIndex = -1;
        int record = 0;
        for (Mdr7Record street : sorted) {
            if (street.getIndex() == lastIndex) continue;
            ++record;
            this.streets.add(street);
            Mdr14Record mdrCountry = street.getCity().getMdrCountry();
            if (mdrCountry != null) {
                Mdr29Record mdr29 = mdrCountry.getMdr29();
                mdr29.setMdr22(record);
            }
            lastIndex = street.getIndex();
        }
    }

    @Override
    protected boolean sameGroup(Mdr7Record street1, Mdr7Record street2) {
        return true;
    }

    public List<Mdr7Record> getStreets() {
        return Collections.unmodifiableList(this.streets);
    }

    @Override
    public int getExtraValue() {
        int magic;
        if (this.isForDevice()) {
            magic = 14;
            if (!this.getConfig().getSort().isMulti()) {
                magic |= 0xC0000;
            }
        } else {
            magic = 69632;
        }
        return magic;
    }
}

