/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.mdr;

import uk.me.parabola.imgfmt.app.ImgFileWriter;
import uk.me.parabola.imgfmt.app.Section;

public class Mdr1SubHeader {
    private static final int MAX_SECTION = 9;
    private static final int HEADER_SIZE = 70;
    private final Section[] sections = new Section[10];

    public Mdr1SubHeader() {
        for (int n = 1; n <= 9; ++n) {
            Section prev = this.sections[n - 1];
            this.sections[n] = new Section(prev);
        }
        this.sections[1].setPosition(70);
    }

    protected void writeFileHeader(ImgFileWriter writer) {
        writer.put2u(70);
        for (int n = 1; n <= 9; ++n) {
            Section section = this.sections[n];
            if (n == 2) {
                writer.put4(section.getPosition());
                continue;
            }
            writer.put4(section.getPosition());
            writer.put4(section.getNumItems());
        }
    }

    public void setEndSubsection(int sub, int pos) {
        this.sections[sub].setSize(pos - this.sections[sub].getPosition());
    }

    public long getHeaderLen() {
        return 70L;
    }

    public void setItemSize(int sectionNumber, int itemSize) {
        this.sections[sectionNumber].setItemSize((char)itemSize);
    }
}

