/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.mdr;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import uk.me.parabola.imgfmt.ExitException;
import uk.me.parabola.imgfmt.MapFailedException;
import uk.me.parabola.imgfmt.Utils;
import uk.me.parabola.imgfmt.app.ImgFileWriter;
import uk.me.parabola.imgfmt.app.mdr.MdrConfig;
import uk.me.parabola.imgfmt.app.mdr.MdrSection;

public class Mdr15
extends MdrSection {
    private final OutputStream stringFile;
    private int nextOffset;
    private Map<String, Integer> strings = new HashMap<String, Integer>();
    private final Charset charset;
    private final File tempFile;

    public Mdr15(MdrConfig config) {
        this.setConfig(config);
        this.charset = config.getSort().getCharset();
        if (config.isForDevice()) {
            this.tempFile = null;
            this.stringFile = null;
            return;
        }
        try {
            this.tempFile = File.createTempFile("strings", null, config.getOutputDir());
            this.tempFile.deleteOnExit();
            this.stringFile = new BufferedOutputStream(new FileOutputStream(this.tempFile), 65536);
            this.stringFile.write(0);
            this.nextOffset = 1;
        }
        catch (IOException e) {
            throw new ExitException("Could not create temporary file");
        }
    }

    public int createString(String str) {
        int off;
        Integer offset = this.strings.get(str);
        if (offset != null) {
            return offset;
        }
        try {
            off = this.nextOffset;
            byte[] bytes = str.getBytes(this.charset);
            this.stringFile.write(bytes);
            this.stringFile.write(0);
            this.nextOffset += bytes.length + 1;
        }
        catch (IOException e) {
            off = 0;
        }
        this.strings.put(str, off);
        return off;
    }

    @Override
    public void releaseMemory() {
        this.strings = null;
        try {
            if (this.stringFile != null) {
                this.stringFile.close();
            }
        }
        catch (IOException e) {
            throw new MapFailedException("Could not close string temporary file");
        }
    }

    @Override
    public void writeSectData(ImgFileWriter writer) {
        try (FileInputStream stream = new FileInputStream(this.tempFile);){
            FileChannel channel = stream.getChannel();
            ByteBuffer buf = ByteBuffer.allocate(32768);
            while (channel.read(buf) > 0) {
                buf.flip();
                writer.put(buf);
                buf.compact();
            }
        }
        catch (IOException e) {
            throw new ExitException("Could not write string section of index");
        }
    }

    @Override
    public int getItemSize() {
        return 0;
    }

    @Override
    public int getSizeForRecord() {
        return Utils.numberToPointerSize(this.nextOffset);
    }

    @Override
    protected int numberOfItems() {
        return 0;
    }
}

