/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.dem;

import java.util.ArrayList;
import java.util.List;
import uk.me.parabola.imgfmt.Utils;
import uk.me.parabola.imgfmt.app.ImgFileWriter;
import uk.me.parabola.imgfmt.app.dem.DEMTile;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.reader.hgt.HGTConverter;

public class DEMSection {
    private static final Logger log = Logger.getLogger(DEMSection.class);
    private static final int STD_DIM = 64;
    private int unknown1 = 0;
    private final int zoomLevel;
    private final boolean lastLevel;
    private final int pointsPerLat = 64;
    private final int pointsPerLon = 64;
    private final int nonStdHeight;
    private final int nonStdWidth;
    private final short flags1 = 0;
    private final int tilesLat;
    private final int tilesLon;
    private int recordDesc;
    private int tileDescSize;
    private int dataOffset;
    private int dataOffset2;
    private final int pointsDistanceLat;
    private final int pointsDistanceLon;
    private final int top;
    private final int left;
    private boolean hasExtra;
    private int minHeight = Integer.MAX_VALUE;
    private int maxHeight = Integer.MIN_VALUE;
    private List<DEMTile> tiles = new ArrayList<DEMTile>();

    public DEMSection(int zoomLevel, int areaTop, int areaLeft, int areaHeight, int areaWidth, HGTConverter hgtConverter, int pointDist, boolean lastLevel) {
        this.zoomLevel = zoomLevel;
        this.lastLevel = lastLevel;
        this.top = areaTop;
        this.left = areaLeft;
        this.pointsDistanceLat = pointDist;
        this.pointsDistanceLon = pointDist;
        hgtConverter.startNewLevel(pointDist);
        int[] latInfo = this.getTileInfo(areaHeight, this.pointsDistanceLat);
        int[] lonInfo = this.getTileInfo(areaWidth, this.pointsDistanceLon);
        this.tilesLat = latInfo[0];
        this.tilesLon = lonInfo[0];
        this.nonStdHeight = latInfo[1];
        this.nonStdWidth = lonInfo[1];
        log.info("calculating zoom level:", zoomLevel, ", dist:", pointDist, this.tilesLon, "x", this.tilesLat, "std tiles, nonstd x/y", this.nonStdWidth, "/", this.nonStdHeight);
        this.calcTiles(hgtConverter);
    }

    private int[] getTileInfo(int demPoints, int demDist) {
        int resolution = 64 * demDist;
        int nFull = (demPoints += demDist) / resolution;
        int rest = demPoints - nFull * resolution;
        int num = nFull;
        int nonstd = rest / demDist;
        if (rest % demDist != 0) {
            ++nonstd;
        }
        if (nonstd >= 32) {
            ++num;
        } else if (num > 0) {
            nonstd += 64;
        }
        if (num == 0) {
            num = 1;
        }
        int[] res = new int[]{num, nonstd};
        return res;
    }

    private void calcTiles(HGTConverter hgtConverter) {
        int resLon = 64 * this.pointsDistanceLon;
        int resLat = 64 * this.pointsDistanceLat;
        int dataLen = 0;
        int minBaseHeight = Integer.MAX_VALUE;
        int maxBaseHeight = Integer.MIN_VALUE;
        int maxDeltaHeight = Integer.MIN_VALUE;
        for (int m = 0; m < this.tilesLat; ++m) {
            int latOff = this.top - m * resLat;
            int height = 64;
            if (m + 1 == this.tilesLat) {
                height = this.nonStdHeight;
            }
            for (int n = 0; n < this.tilesLon; ++n) {
                int lonOff = this.left + n * resLon;
                int width = 64;
                if (n + 1 == this.tilesLon) {
                    width = this.nonStdWidth;
                }
                short[] realHeights = hgtConverter.getHeights(latOff, lonOff, height, width);
                DEMTile tile = new DEMTile(n, m, width, height, realHeights);
                this.tiles.add(tile);
                if (tile.getEncodingType() != 0) {
                    this.hasExtra = true;
                }
                if (tile.hasValidHeights()) {
                    if (tile.getBaseHeight() < minBaseHeight) {
                        minBaseHeight = tile.getBaseHeight();
                    }
                    if (tile.getBaseHeight() > maxBaseHeight) {
                        maxBaseHeight = tile.getBaseHeight();
                    }
                    if (tile.getMaxHeight() > this.maxHeight) {
                        this.maxHeight = tile.getMaxHeight();
                    }
                    if (tile.getMaxDeltaHeight() > maxDeltaHeight) {
                        maxDeltaHeight = tile.getMaxDeltaHeight();
                    }
                }
                dataLen += tile.getBitStreamLen();
            }
            if (!this.lastLevel) continue;
            hgtConverter.freeMem();
        }
        hgtConverter.printStat();
        if (dataLen > 0) {
            this.minHeight = minBaseHeight;
        } else {
            this.minHeight = 0;
            this.maxHeight = 0;
        }
        int deltaSize = maxDeltaHeight <= 255 ? 1 : 2;
        int baseSize = -128 < minBaseHeight && maxBaseHeight < 128 ? 1 : 2;
        int offsetSize = Utils.numberToPointerSize(dataLen);
        this.tileDescSize = offsetSize + baseSize + deltaSize + (this.hasExtra ? 1 : 0);
        this.recordDesc = offsetSize - 1;
        if (baseSize > 1) {
            this.recordDesc |= 4;
        }
        if (deltaSize > 1) {
            this.recordDesc |= 8;
        }
        if (this.hasExtra) {
            this.recordDesc |= 0x10;
        }
    }

    public void writeHeader(ImgFileWriter writer) {
        writer.put1u(this.unknown1);
        writer.put1u(this.zoomLevel);
        writer.put4(64);
        writer.put4(64);
        writer.put4(this.nonStdHeight - 1);
        writer.put4(this.nonStdWidth - 1);
        writer.put2u(0);
        writer.put4(this.tilesLon - 1);
        writer.put4(this.tilesLat - 1);
        writer.put2u(this.recordDesc);
        writer.put2u(this.tileDescSize);
        writer.put4(this.dataOffset);
        writer.put4(this.dataOffset2);
        writer.put4(this.left);
        writer.put4(this.top);
        writer.put4(this.pointsDistanceLat);
        writer.put4(this.pointsDistanceLon);
        writer.put2s(this.minHeight);
        writer.put2s(this.maxHeight);
    }

    public void writeRest(ImgFileWriter writer) {
        this.dataOffset = writer.position();
        int off = 0;
        for (DEMTile tile : this.tiles) {
            tile.setOffset(off);
            tile.writeHeader(writer, this.recordDesc);
            off += tile.getBitStreamLen();
        }
        this.dataOffset2 = writer.position();
        for (DEMTile tile : this.tiles) {
            tile.writeBitStreamData(writer);
        }
    }
}

