/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.util;

import java.util.LinkedHashSet;
import java.util.Set;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.util.Locatable;

public class KdTree<T extends Locatable> {
    private static final boolean ROOT_NODE_USES_LONGITUDE = false;
    private KdNode root = null;
    private int size;
    private T nextPoint;
    private double minDist;
    private double maxDist;
    private Set<T> set;

    public long size() {
        return this.size;
    }

    public void add(T toAdd) {
        ++this.size;
        this.root = this.add(toAdd, this.root, false);
    }

    private boolean isSmaller(boolean longitude, Coord c1, Coord c2) {
        if (longitude) {
            return c1.getLongitude() < c2.getLongitude();
        }
        return c1.getLatitude() < c2.getLatitude();
    }

    private KdNode add(T toAdd, KdNode tree, boolean useLongitude) {
        if (tree == null) {
            tree = new KdNode(this, toAdd);
        } else if (this.isSmaller(useLongitude, toAdd.getLocation(), tree.point.getLocation())) {
            tree.left = this.add(toAdd, tree.left, !useLongitude);
        } else {
            tree.right = this.add(toAdd, tree.right, !useLongitude);
        }
        return tree;
    }

    public T findNextPoint(Locatable p) {
        this.minDist = Double.MAX_VALUE;
        this.maxDist = -1.0;
        this.set = null;
        this.nextPoint = null;
        this.findNextPoint(p.getLocation(), this.root, false);
        return this.nextPoint;
    }

    public Set<T> findClosePoints(Locatable p, double maxDist) {
        this.minDist = Double.MAX_VALUE;
        this.maxDist = Math.pow(maxDist * 360.0 / 4.007501668557849E7, 2.0);
        this.nextPoint = null;
        this.set = new LinkedHashSet<T>();
        this.findNextPoint(p.getLocation(), this.root, false);
        return this.set;
    }

    private void findNextPoint(Coord p, KdNode tree, boolean useLongitude) {
        if (tree == null) {
            return;
        }
        if (tree.left == null && tree.right == null) {
            this.processNode(tree, p);
            return;
        }
        boolean smaller = this.isSmaller(useLongitude, p, tree.point.getLocation());
        this.findNextPoint(p, smaller ? tree.left : tree.right, !useLongitude);
        this.processNode(tree, p);
        int testLat = useLongitude ? p.getHighPrecLat() : tree.point.getLocation().getHighPrecLat();
        int testLon = useLongitude ? tree.point.getLocation().getHighPrecLon() : p.getHighPrecLon();
        Coord test = Coord.makeHighPrecCoord(testLat, testLon);
        if (test.distanceInDegreesSquared(p) < this.minDist) {
            this.findNextPoint(p, smaller ? tree.right : tree.left, !useLongitude);
        }
    }

    private void processNode(KdNode node, Coord p) {
        double dist = node.point.getLocation().distanceInDegreesSquared(p);
        if (dist <= this.maxDist && this.set != null) {
            this.set.add(node.point);
        }
        if (dist < this.minDist) {
            this.nextPoint = node.point;
            this.minDist = dist < this.maxDist ? this.maxDist : dist;
        }
    }

    private static class KdNode {
        T point;
        KdNode left;
        KdNode right;
        final /* synthetic */ KdTree this$0;

        KdNode(T p) {
            this.this$0 = var1_1;
            this.point = p;
        }
    }
}

