/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.typ;

import uk.me.parabola.imgfmt.app.typ.ColourInfo;
import uk.me.parabola.imgfmt.app.typ.TypData;
import uk.me.parabola.imgfmt.app.typ.TypPolygon;
import uk.me.parabola.mkgmap.scan.SyntaxException;
import uk.me.parabola.mkgmap.scan.TokenScanner;
import uk.me.parabola.mkgmap.typ.CommonSection;
import uk.me.parabola.mkgmap.typ.ProcessSection;

class PolygonSection
extends CommonSection
implements ProcessSection {
    private final TypPolygon current = new TypPolygon();

    PolygonSection(TypData data) {
        super(data);
    }

    @Override
    public void processLine(TokenScanner scanner, String name, String value) {
        if (this.commonKey(scanner, this.current, name, value)) {
            return;
        }
        this.warnUnknown(name);
    }

    @Override
    public void finish(TokenScanner scanner) {
        this.validate(scanner);
        this.data.addPolygon(this.current);
    }

    @Override
    protected void xpmCheck(TokenScanner scanner, ColourInfo colourInfo) {
        int width = colourInfo.getWidth();
        int height = colourInfo.getHeight();
        switch (colourInfo.getNumberOfColours()) {
            case 1: 
            case 2: 
            case 4: {
                break;
            }
            default: {
                throw new SyntaxException(scanner, "Polygons must have 1, 2 or 4 colours");
            }
        }
        if (width == 0 && height == 0) {
            return;
        }
        if (height != 32 || width != 32) {
            throw new SyntaxException(scanner, "Polygon bitmaps must be 32x32");
        }
    }
}

