/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.typ;

import uk.me.parabola.imgfmt.app.typ.TypData;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.scan.SyntaxException;
import uk.me.parabola.mkgmap.scan.TokenScanner;
import uk.me.parabola.mkgmap.srt.SrtTextReader;
import uk.me.parabola.mkgmap.typ.ProcessSection;

class IdSection
implements ProcessSection {
    private static final Logger log = Logger.getLogger(IdSection.class);
    private final TypData data;

    public IdSection(TypData data) {
        this.data = data;
    }

    @Override
    public void processLine(TokenScanner scanner, String name, String value) {
        int ival;
        try {
            ival = Integer.decode(value);
        }
        catch (NumberFormatException e) {
            log.warn("bad/missing integer in TYP [_id] statement: ", name, "=", value);
            ival = -1;
        }
        if ("FID".equalsIgnoreCase(name)) {
            if (ival != -1) {
                this.data.setFamilyId(ival);
            }
        } else if ("ProductCode".equalsIgnoreCase(name)) {
            if (ival != -1) {
                this.data.setProductId(ival);
            }
        } else if ("CodePage".equalsIgnoreCase(name)) {
            if (ival != -1 && this.data.getSort() == null) {
                this.data.setSort(SrtTextReader.sortForCodepage(ival));
            }
        } else {
            throw new SyntaxException(scanner, "Unrecognised keyword in id section: " + name);
        }
    }

    @Override
    public void finish(TokenScanner scanner) {
    }
}

