/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.reader.osm.boundary;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import uk.me.parabola.mkgmap.reader.osm.Tags;
import uk.me.parabola.mkgmap.reader.osm.boundary.BoundaryQuadTree;
import uk.me.parabola.mkgmap.reader.osm.boundary.BoundaryUtil;

public class BoundaryLister {
    public static void main(String[] args) throws IOException {
        File outDir;
        String boundsdir;
        String outDirName = boundsdir = args[0];
        if (args.length >= 2) {
            outDirName = args[1];
        }
        if ((outDir = new File(outDirName)).exists() && !outDir.isDirectory()) {
            System.err.println("target is not a directory, output is written to bounds.txt");
            outDir = new File(".");
        }
        List<String> bndFileNames = BoundaryUtil.getBoundaryDirContent(boundsdir);
        PrintWriter out = new PrintWriter(new File(outDir, "bounds.txt"), "UTF-8");
        for (String bndFile : bndFileNames) {
            out.println(bndFile + "****************");
            BoundaryQuadTree bqt = BoundaryUtil.loadQuadTree(boundsdir, bndFile);
            if (bqt == null) break;
            Map<String, Tags> map = bqt.getTagsMap();
            for (Map.Entry<String, Tags> entry : map.entrySet()) {
                TreeMap<String, String> btree = new TreeMap<String, String>();
                String line = bndFile + ":" + entry.getKey();
                Iterator<Map.Entry<String, String>> tagIter = entry.getValue().entryIterator();
                while (tagIter.hasNext()) {
                    Map.Entry<String, String> tag = tagIter.next();
                    btree.put(tag.getKey(), tag.getValue());
                }
                for (Map.Entry e : btree.entrySet()) {
                    out.println(line + ";" + e);
                }
            }
        }
        out.close();
    }
}

