/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.reader.osm;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import uk.me.parabola.imgfmt.app.Area;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.reader.osm.ElementSaver;
import uk.me.parabola.mkgmap.reader.osm.Node;
import uk.me.parabola.mkgmap.reader.osm.OsmReadingHooks;
import uk.me.parabola.mkgmap.reader.osm.POIGeneratorHook;
import uk.me.parabola.mkgmap.reader.osm.Style;
import uk.me.parabola.mkgmap.reader.osm.Way;
import uk.me.parabola.util.EnhancedProperties;

public class UnusedElementsRemoverHook
implements OsmReadingHooks {
    private static final Logger log = Logger.getLogger(UnusedElementsRemoverHook.class);
    private ElementSaver saver;
    private List<Map.Entry<String, String>> areasToPoiNodeTags;

    @Override
    public boolean init(ElementSaver saver, EnhancedProperties props, Style style) {
        this.saver = saver;
        this.areasToPoiNodeTags = props.containsKey("add-pois-to-areas") ? POIGeneratorHook.getPoiPlacementTags(props) : new ArrayList<Map.Entry<String, String>>();
        return true;
    }

    @Override
    public void end() {
        long t1 = System.currentTimeMillis();
        log.info((Object)"Removing unused elements");
        Area bbox = this.saver.getBoundingBox();
        long nodes = this.saver.getNodes().size();
        for (Node node : new ArrayList<Node>(this.saver.getNodes().values())) {
            if (node.getTagCount() == 0) {
                this.saver.getNodes().remove(node.getId());
                continue;
            }
            if (bbox.contains(node.getLocation())) continue;
            boolean removeNode = true;
            for (Map.Entry<String, String> tag : this.areasToPoiNodeTags) {
                String val = node.getTag(tag.getKey());
                if (val == null || tag.getValue() != null && !val.equals(tag.getValue())) continue;
                removeNode = false;
                break;
            }
            if (removeNode) {
                this.saver.getNodes().remove(node.getId());
                continue;
            }
            log.debug("Keep node", node, "because it contains a tag which might be required for the area-to-poi function.");
        }
        Rectangle bboxRect = new Rectangle(bbox.getMinLong(), bbox.getMinLat(), bbox.getWidth(), bbox.getHeight());
        long ways = this.saver.getWays().size();
        for (Way way : new ArrayList<Way>(this.saver.getWays().values())) {
            if (way.isViaWay()) continue;
            if (way.getPoints().isEmpty()) {
                this.saver.getWays().remove(way.getId());
                continue;
            }
            if (way.getTagCount() == 0) {
                this.saver.getWays().remove(way.getId());
                continue;
            }
            boolean coordInBbox = false;
            Coord prevC = null;
            for (Coord c : way.getPoints()) {
                if (bbox.contains(c)) {
                    coordInBbox = true;
                    break;
                }
                if (prevC != null && bboxRect.intersectsLine(prevC.getLongitude(), prevC.getLatitude(), c.getLongitude(), c.getLatitude())) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Intersection!");
                        log.debug("Bbox:", bbox);
                        log.debug("Way coords:", prevC, c);
                    }
                    coordInBbox = true;
                    break;
                }
                prevC = c;
            }
            if (coordInBbox) continue;
            Area wayBbox = Area.getBBox(way.getPoints());
            if (wayBbox.contains(this.saver.getBoundingBox())) {
                log.debug(way, "possibly covers the bbox completely. Keep it.");
                continue;
            }
            this.saver.getWays().remove(way.getId());
        }
        log.info("Nodes: before:", nodes, "after:", this.saver.getNodes().size());
        log.info("Ways: before:", ways, "after:", this.saver.getWays().size());
        log.info("Removing unused elements took", System.currentTimeMillis() - t1, "ms");
    }
}

