/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.reader.osm;

import java.util.AbstractMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeSet;
import uk.me.parabola.mkgmap.reader.osm.TagDict;

public class Tags {
    private static final int INIT_SIZE = 8;
    private static final TagDict tagDict = TagDict.getInstance();
    private short keySize;
    private short capacity;
    private short size;
    private short[] keys = new short[8];
    private String[] values = new String[8];

    public Tags() {
        this.capacity = (short)8;
    }

    public String get(String key) {
        short k = tagDict.xlate(key);
        int ind = this.keyPos(k);
        if (ind < 0) {
            return null;
        }
        return this.values[ind];
    }

    public String get(short key) {
        int ind = this.keyPos(key);
        if (ind < 0) {
            return null;
        }
        return this.values[ind];
    }

    public int size() {
        return this.size;
    }

    public String put(String key, String value) {
        assert (key != null) : "key is null";
        short dictIdx = tagDict.xlate(key);
        return this.put(dictIdx, value);
    }

    public String put(short key, String value) {
        assert (value != null) : "value is null";
        this.ensureSpace();
        int ind = this.keyPos(key);
        if (ind < 0) assert (false) : "keyPos(" + key + ") returns null - size = " + this.keySize + ", capacity = " + this.capacity;
        this.keys[ind] = key;
        String old = this.values[ind];
        if (old == null) {
            this.keySize = (short)(this.keySize + 1);
            this.size = (short)(this.size + 1);
        }
        this.values[ind] = value;
        return old;
    }

    public String remove(short key) {
        int k = this.keyPos(key);
        if (k >= 0 && this.values[k] != null) {
            String old = this.values[k];
            this.values[k] = null;
            this.size = (short)(this.size - 1);
            return old;
        }
        return null;
    }

    public String remove(String key) {
        short kd = tagDict.xlate(key);
        return this.remove(kd);
    }

    public Tags copy() {
        Tags cp = new Tags();
        cp.keySize = this.keySize;
        cp.size = this.size;
        cp.capacity = this.capacity;
        cp.keys = Arrays.copyOf(this.keys, this.keys.length);
        cp.values = Arrays.copyOf(this.values, this.values.length);
        return cp;
    }

    private void ensureSpace() {
        while (this.keySize + 1 >= this.capacity) {
            short ncap = (short)(this.capacity * 2);
            short[] okey = this.keys;
            String[] oval = this.values;
            this.keys = new short[ncap];
            this.values = new String[ncap];
            this.capacity = ncap;
            this.keySize = 0;
            this.size = 0;
            for (int i = 0; i < okey.length; ++i) {
                short k = okey[i];
                String v = oval[i];
                if (k == 0 || v == null) continue;
                int ind = this.keyPos(k);
                this.keys[ind] = k;
                this.values[ind] = v;
                this.keySize = (short)(this.keySize + 1);
                this.size = (short)(this.size + 1);
            }
        }
        assert (this.keySize < this.capacity);
    }

    private int keyPos(short key) {
        int k;
        int i = k = key & this.capacity - 1;
        do {
            if (this.keys[i] == 0 || this.keys[i] == key) {
                return i;
            }
            if (++i < this.capacity) continue;
            i = 0;
        } while (i != k);
        return -1;
    }

    public Iterator<Map.Entry<String, String>> entryIterator() {
        return new Iterator<Map.Entry<String, String>>(){
            private int pos;
            private int done;

            @Override
            public boolean hasNext() {
                return this.done < Tags.this.size;
            }

            @Override
            public Map.Entry<String, String> next() {
                if (this.done >= Tags.this.size) {
                    throw new NoSuchElementException();
                }
                while (this.pos < Tags.this.capacity && Tags.this.values[this.pos] == null) {
                    ++this.pos;
                }
                AbstractMap.SimpleEntry<String, String> entry = new AbstractMap.SimpleEntry<String, String>(tagDict.get(Tags.this.keys[this.pos]), Tags.this.values[this.pos]);
                ++this.pos;
                ++this.done;
                return entry;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Iterator<Map.Entry<Short, String>> entryShortIterator() {
        return new Iterator<Map.Entry<Short, String>>(){
            private int pos;
            private int done;

            @Override
            public boolean hasNext() {
                return this.done < Tags.this.size;
            }

            @Override
            public Map.Entry<Short, String> next() {
                if (this.done >= Tags.this.size) {
                    throw new NoSuchElementException();
                }
                while (this.pos < Tags.this.capacity && Tags.this.values[this.pos] == null) {
                    ++this.pos;
                }
                AbstractMap.SimpleEntry<Short, String> entry = new AbstractMap.SimpleEntry<Short, String>(Tags.this.keys[this.pos], Tags.this.values[this.pos]);
                ++this.pos;
                ++this.done;
                return entry;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Map<String, String> getTagsWithPrefix(String prefix, boolean removePrefix) {
        HashMap<String, String> map = new HashMap<String, String>();
        int prefixLen = prefix.length();
        for (int i = 0; i < this.capacity; ++i) {
            String k;
            if (this.keys[i] == 0 || (k = tagDict.get(this.keys[i])) == null || !k.startsWith(prefix)) continue;
            if (removePrefix) {
                map.put(k.substring(prefixLen), this.values[i]);
                continue;
            }
            map.put(k, this.values[i]);
        }
        return map;
    }

    public String toString() {
        TreeSet<String> sorted = new TreeSet<String>();
        for (int i = 0; i < this.capacity; ++i) {
            if (this.values[i] == null) continue;
            sorted.add(tagDict.get(this.keys[i]) + "=" + this.values[i]);
        }
        return sorted.toString();
    }
}

