/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.reader.osm;

import it.unimi.dsi.fastutil.shorts.ShortArrayList;
import java.util.ArrayList;
import java.util.HashMap;
import uk.me.parabola.imgfmt.MapFailedException;

public class TagDict {
    private static final TagDict INSTANCE = new TagDict();
    private final HashMap<String, Short> map = new HashMap();
    private final ArrayList<String> list = new ArrayList();
    public static final short INVALID_TAG_VALUE = 0;

    private TagDict() {
        this.map.put("invalid tag", (short)0);
        this.list.add("invalid tag");
    }

    public static TagDict getInstance() {
        return INSTANCE;
    }

    public synchronized short xlate(String keyString) {
        Short tagKey = this.map.get(keyString);
        if (tagKey == null) {
            short size = (short)this.list.size();
            if (size == Short.MAX_VALUE) {
                throw new MapFailedException("Fatal: Too many different tags in style");
            }
            String s = keyString;
            this.map.put(s, size);
            this.list.add(s);
            return size;
        }
        return tagKey;
    }

    public String get(short key) {
        if (key == 0) {
            return null;
        }
        return this.list.get(key);
    }

    public int size() {
        return this.list.size();
    }

    public static ShortArrayList compileTags(String ... keys) {
        ShortArrayList compiled = new ShortArrayList();
        if (keys != null) {
            for (String key : keys) {
                compiled.add(TagDict.getInstance().xlate(key));
            }
        }
        return compiled;
    }
}

