/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.reader.hgt;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import uk.me.parabola.imgfmt.MapFailedException;
import uk.me.parabola.imgfmt.Utils;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.reader.hgt.HGTList;

public class HGTReader {
    private static final Logger log = Logger.getLogger(HGTReader.class);
    public static final short UNDEF = Short.MIN_VALUE;
    private ByteBuffer buffer;
    private int res;
    private final String fileName;
    private String path;
    private boolean read;
    private long count;
    private int numPixelsX;
    private int numPixelsY;
    private static final Map<String, Set<String>> missingMap = new HashMap<String, Set<String>>();
    private static final Set<String> badDir = new HashSet<String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HGTReader(int lat, int lon, String dirsWithHGT) {
        String baseName = String.format("%s%02d%s%03d", lat < 0 ? "S" : "N", lat < 0 ? -lat : lat, lon < 0 ? "W" : "E", lon < 0 ? -lon : lon);
        String[] dirs = dirsWithHGT.split("[,]");
        this.fileName = baseName + ".hgt";
        String fName = ".";
        boolean knownAsMissing = false;
        Map<String, Set<String>> object = missingMap;
        synchronized (object) {
            Set<String> missingSet = missingMap.get(dirsWithHGT);
            if (missingSet != null) {
                knownAsMissing = missingSet.contains(this.fileName);
            }
        }
        if (!knownAsMissing) {
            for (String dir : dirs) {
                File f = new File(dir = dir.trim());
                if (!f.exists()) {
                    Set<String> set = badDir;
                    synchronized (set) {
                        if (badDir.add(dir)) {
                            log.error("extracted path >" + dir + "< does not exist, check option dem:", dirsWithHGT);
                        }
                        continue;
                    }
                }
                if (f.isDirectory()) {
                    fName = Utils.joinPath(dir, this.fileName);
                    try (FileInputStream fis22 = new FileInputStream(fName);){
                        this.res = this.calcRes(fis22.getChannel().size(), fName);
                        if (this.res >= 0) {
                            this.path = fName;
                        }
                        break;
                    }
                    catch (FileNotFoundException fis22) {
                    }
                    catch (IOException e) {
                        log.error("failed to get size for file", fName);
                    }
                    fName = fName + ".zip";
                    this.checkZip(fName, this.fileName);
                    if (this.res > 0) {
                        this.path = fName;
                        return;
                    }
                    fName = Utils.joinPath(dir, baseName) + ".zip";
                    this.checkZip(fName, this.fileName);
                    if (this.res > 0) {
                        this.path = fName;
                        return;
                    }
                } else if (dir.endsWith(".zip")) {
                    this.checkZip(dir, this.fileName);
                }
                if (this.res <= 0) continue;
                this.path = dir;
                return;
            }
            if (this.res <= 0 || this.path == null) {
                this.res = -1;
                this.path = null;
                Map<String, Set<String>> map = missingMap;
                synchronized (map) {
                    missingMap.computeIfAbsent(dirsWithHGT, k -> new HashSet()).add(this.fileName);
                }
                HGTList hGTList = HGTList.get();
                if (hGTList != null) {
                    if (hGTList.shouldExist(lat, lon)) {
                        Logger.defaultLogger.warn((Object)(this.getClass().getSimpleName() + ": file " + this.fileName + " not found but it should exist. Height values will be 0."));
                    }
                } else {
                    log.warn((Object)("file " + this.fileName + " not found. Is expected to cover sea."));
                }
            }
        }
    }

    private ZipEntry findZipEntry(ZipFile zipFile, String name) {
        ZipEntry entry = zipFile.getEntry(name);
        if (entry == null) {
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                entry = entries.nextElement();
                if (entry.isDirectory() || !entry.getName().toUpperCase().endsWith(name.toUpperCase())) continue;
                return entry;
            }
            return null;
        }
        return entry;
    }

    private void checkZip(String fName, String name) {
        File f = new File(fName);
        if (!f.exists()) {
            return;
        }
        try (ZipFile zipFile = new ZipFile(f);){
            ZipEntry entry = this.findZipEntry(zipFile, name);
            if (entry != null) {
                this.res = this.calcRes(entry.getSize(), entry.getName());
            }
        }
        catch (IOException exp) {
            log.error("failed to get size for file", name, "from", fName);
        }
    }

    private void extractFromZip(String fName, String name) throws IOException {
        try (ZipFile zipFile = new ZipFile(fName);){
            ZipEntry entry = this.findZipEntry(zipFile, name);
            if (entry != null) {
                InputStream is = zipFile.getInputStream(entry);
                log.info((Object)("extracting data for " + entry.getName() + " from " + zipFile.getName()));
                this.buffer = ByteBuffer.allocate((int)entry.getSize());
                byte[] ioBuffer = new byte[1024];
                int len = is.read(ioBuffer);
                while (len != -1) {
                    this.buffer.put(ioBuffer, 0, len);
                    len = is.read(ioBuffer);
                }
            } else {
                throw new FileNotFoundException(name);
            }
            this.read = true;
        }
    }

    private int calcRes(long size, String fname) {
        long numVals = (long)Math.sqrt((double)size / 2.0);
        if (12970802L == size) {
            this.numPixelsX = 1801;
            this.numPixelsY = 3601;
            return 3600;
        }
        if (2L * numVals * numVals == size) {
            this.numPixelsX = (int)numVals;
            this.numPixelsY = (int)numVals;
            return (int)(numVals - 1L);
        }
        log.error("file", fname, "has unexpected size", size, "and is ignored");
        return -1;
    }

    public short ele(int x, int y) {
        if (!this.read && this.path != null) {
            this.prepRead();
        }
        if (this.buffer == null) {
            return 0;
        }
        assert (x >= 0 && x < this.numPixelsX && y >= 0 && y < this.numPixelsY) : "wrong x/y value for res" + this.numPixelsX + "x" + this.numPixelsY + " x=" + x + " y=" + y;
        ++this.count;
        return this.buffer.getShort(2 * ((this.numPixelsY - 1 - y) * this.numPixelsX + x));
    }

    public int getRes() {
        return this.res;
    }

    public String toString() {
        return this.fileName + " (" + this.count + " reads) " + this.res;
    }

    public boolean freeBuf() {
        if (this.buffer == null) {
            return false;
        }
        this.buffer = null;
        this.read = false;
        return true;
    }

    public void prepRead() {
        block19: {
            if (!this.read && this.path != null) {
                try {
                    if (this.count == 0L) {
                        log.info("allocating buffer for", this.fileName);
                    } else {
                        log.warn("re-allocating buffer for", this.fileName);
                    }
                    if (this.path.endsWith(".zip")) {
                        this.extractFromZip(this.path, this.fileName);
                        break block19;
                    }
                    try (FileInputStream is = new FileInputStream(this.path);){
                        this.buffer = is.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, is.getChannel().size());
                        this.read = true;
                    }
                }
                catch (FileNotFoundException e) {
                    throw new MapFailedException("previously existing file is missing: " + this.path);
                }
                catch (IOException e) {
                    log.error("failed to create buffer for file", this.path);
                }
            }
        }
    }

    public int getResX() {
        return this.numPixelsX - 1;
    }

    public int getResY() {
        return this.numPixelsY - 1;
    }
}

