/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.osmstyle.eval;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.osmstyle.eval.AbstractOp;
import uk.me.parabola.mkgmap.osmstyle.eval.AndOp;
import uk.me.parabola.mkgmap.osmstyle.eval.BinaryOp;
import uk.me.parabola.mkgmap.osmstyle.eval.ExistsOp;
import uk.me.parabola.mkgmap.osmstyle.eval.NodeType;
import uk.me.parabola.mkgmap.osmstyle.eval.NotExistsOp;
import uk.me.parabola.mkgmap.osmstyle.eval.Op;
import uk.me.parabola.mkgmap.osmstyle.eval.ValueOp;
import uk.me.parabola.mkgmap.osmstyle.function.FunctionFactory;
import uk.me.parabola.mkgmap.osmstyle.function.GetTagFunction;
import uk.me.parabola.mkgmap.osmstyle.function.StyleFunction;
import uk.me.parabola.mkgmap.reader.osm.FeatureKind;
import uk.me.parabola.mkgmap.scan.SyntaxException;
import uk.me.parabola.mkgmap.scan.TokType;
import uk.me.parabola.mkgmap.scan.Token;
import uk.me.parabola.mkgmap.scan.TokenScanner;
import uk.me.parabola.mkgmap.scan.WordInfo;

public class ExpressionReader {
    private static final Logger log = Logger.getLogger(ExpressionReader.class);
    private final Stack<Op> stack = new Stack();
    private final Stack<Op> opStack = new Stack();
    private final TokenScanner scanner;
    private final FeatureKind kind;
    private final Set<String> usedTags = new HashSet<String>();

    public ExpressionReader(TokenScanner scanner, FeatureKind kind) {
        this.scanner = scanner;
        this.kind = kind;
    }

    public Op readConditions() {
        return this.readConditions(Collections.emptyList());
    }

    public Op readConditions(Collection<Op[]> ifStack) {
        Op op;
        boolean consumedNonBlank = false;
        while (!this.scanner.isEndOfFile()) {
            this.scanner.skipSpace();
            if (this.scanner.checkToken("[") || this.scanner.checkToken("{") || this.scanner.checkToken("then")) break;
            consumedNonBlank = true;
            WordInfo wordInfo = this.scanner.nextWordWithInfo();
            if (ExpressionReader.isOperation(wordInfo)) {
                this.saveOp(wordInfo.getText());
                continue;
            }
            if (wordInfo.isQuoted()) {
                this.pushValue(wordInfo.getText());
                continue;
            }
            if (wordInfo.getText().charAt(0) == '$') {
                String tagname = this.scanner.nextWord();
                if ("{".equals(tagname)) {
                    tagname = this.scanner.nextWord();
                    this.scanner.validateNext("}");
                }
                this.stack.push(new GetTagFunction(tagname));
                continue;
            }
            if (this.scanner.checkToken("(")) {
                this.scanner.validateNext("(");
                ArrayList<String> funcParams = new ArrayList<String>();
                while (true) {
                    this.scanner.skipSpace();
                    Token tok = this.scanner.peekToken();
                    if (tok.getType() != TokType.TEXT && (tok.getType() != TokType.SYMBOL || !"'".equals(tok.getValue()) && !"\"".equals(tok.getValue()))) break;
                    WordInfo funcParam = this.scanner.nextWordWithInfo();
                    funcParams.add(funcParam.getText());
                    if (!this.scanner.checkToken(",")) break;
                    this.scanner.nextToken();
                }
                this.scanner.validateNext(")");
                try {
                    this.saveFunction(wordInfo.getText(), funcParams);
                    continue;
                }
                catch (Exception e) {
                    throw new SyntaxException(this.scanner, e.getMessage());
                }
            }
            this.pushValue(wordInfo.getText());
        }
        while (!this.opStack.isEmpty()) {
            this.runOp(this.scanner);
        }
        if (consumedNonBlank && !ifStack.isEmpty() && this.stack.size() <= 1) {
            op = null;
            if (!this.stack.isEmpty()) {
                op = this.stack.pop();
            }
            this.stack.push(ExpressionReader.appendIfExpr(op, ifStack));
        }
        if (this.stack.size() != 1) {
            throw new SyntaxException(this.scanner, "Stack size is " + this.stack.size() + " (missing or incomplete expression)");
        }
        assert (this.stack.size() == 1);
        op = this.stack.pop();
        if (op instanceof ValueOp) {
            throw new SyntaxException(this.scanner, "Incomplete expression, just a single symbol: " + op);
        }
        return op;
    }

    private static Op appendIfExpr(Op expr, Collection<Op[]> ifStack) {
        Op result = expr;
        for (Op[] ops : ifStack) {
            if (result != null) {
                AndOp and = new AndOp();
                and.setFirst(result);
                and.setSecond(ops[0].copy());
                result = and;
                continue;
            }
            result = ops[0].copy();
        }
        return result;
    }

    private static boolean isOperation(WordInfo token) {
        if (token.isQuoted()) {
            return false;
        }
        String text = token.getText();
        if (text.length() > 2 || text.isEmpty()) {
            return false;
        }
        String chars = "&|!=~()><";
        char first = text.charAt(0);
        return chars.indexOf(first) >= 0;
    }

    public Set<String> getUsedTags() {
        return this.usedTags;
    }

    private void saveOp(String value) {
        Op op;
        log.debug("save op", value);
        if ("#".equals(value)) {
            this.scanner.skipLine();
            return;
        }
        try {
            op = AbstractOp.createOp(value);
            while (!this.opStack.isEmpty() && this.opStack.peek().hasHigherPriority(op)) {
                this.runOp(this.scanner);
            }
        }
        catch (SyntaxException e) {
            throw new SyntaxException(this.scanner, e.getRawMessage());
        }
        if (op.getType() == NodeType.CLOSE_PAREN) {
            if (this.opStack.isEmpty() || !this.opStack.peek().isType(NodeType.OPEN_PAREN)) {
                throw new SyntaxException(this.scanner, "No matching open parenthesis");
            }
            this.opStack.pop();
        } else {
            this.opStack.push(op);
        }
    }

    private void runOp(TokenScanner scanner) {
        Op op = this.opStack.pop();
        log.debug(new Object[]{"Running op...", op.getType()});
        if (op instanceof BinaryOp) {
            if (this.stack.size() < 2) {
                throw new SyntaxException(scanner, String.format("Not enough arguments for '%s' operator", op.getType().toSymbol()));
            }
            Op arg2 = this.stack.pop();
            Op arg1 = this.stack.pop();
            if (arg1.isType(NodeType.VALUE)) {
                arg1 = new GetTagFunction(arg1.getKeyValue());
            }
            if (op.isType(NodeType.OR) || op.isType(NodeType.AND)) {
                if (arg1.isType(NodeType.VALUE) || arg1.isType(NodeType.FUNCTION)) {
                    throw new SyntaxException(scanner, String.format("Value '%s' is not part of an expression", arg1));
                }
                if (arg2.isType(NodeType.VALUE) || arg2.isType(NodeType.FUNCTION)) {
                    throw new SyntaxException(scanner, String.format("Value '%s' is not part of an expression", arg2));
                }
            } else if (!arg1.isType(NodeType.VALUE) && !arg1.isType(NodeType.FUNCTION) || !arg2.isType(NodeType.VALUE) && !arg2.isType(NodeType.FUNCTION)) {
                String msg = String.format("Invalid arguments to %s: %s (%s) and %s (%s)", new Object[]{op.getType(), arg1.getType(), arg1, arg2.getType(), arg2});
                throw new SyntaxException(scanner, msg);
            }
            BinaryOp binaryOp = (BinaryOp)op;
            binaryOp.setFirst(arg1);
            binaryOp.setSecond(arg2);
            if (op.isType(NodeType.EQUALS) && arg2.isType(NodeType.VALUE) && ((ValueOp)arg2).isValue("*")) {
                log.debug((Object)"convert to EXISTS");
                op = new ExistsOp();
                op.setFirst(arg1);
            } else if (op.isType(NodeType.NOT_EQUALS) && arg2.isType(NodeType.VALUE) && ((ValueOp)arg2).isValue("*")) {
                log.debug((Object)"convert to NOT EXISTS");
                op = new NotExistsOp();
                op.setFirst(arg1);
            }
        } else if (!op.isType(NodeType.OPEN_PAREN)) {
            if (this.stack.isEmpty()) {
                throw new SyntaxException(scanner, String.format("Missing argument for %s operator", op.getType().toSymbol()));
            }
            op.setFirst(this.stack.pop());
        }
        Op first = op.getFirst();
        if (first == null) {
            throw new SyntaxException(scanner, "Invalid expression");
        }
        if (first.isType(NodeType.FUNCTION) && first.getKeyValue() != null) {
            this.usedTags.add(first.getKeyValue());
        }
        this.stack.push(op);
    }

    private void saveFunction(String functionName, List<String> functionParams) {
        StyleFunction function = FunctionFactory.createFunction(functionName);
        if (function == null) {
            throw new SyntaxException(String.format("No function with name '%s()'", functionName));
        }
        function.setParams(functionParams, this.kind);
        boolean supported = false;
        switch (this.kind) {
            case POINT: {
                if (!function.supportsNode()) break;
                supported = true;
                break;
            }
            case POLYLINE: {
                if (!function.supportsWay()) break;
                supported = true;
                break;
            }
            case POLYGON: {
                if (!function.supportsWay()) break;
                supported = true;
                break;
            }
            case RELATION: {
                if (!function.supportsRelation()) break;
                supported = true;
                break;
            }
            case ALL: {
                if (!function.supportsNode() && !function.supportsWay() && !function.supportsRelation()) break;
                supported = true;
            }
        }
        if (!supported) {
            throw new SyntaxException(String.format("Function '%s()' not supported for %s", new Object[]{functionName, this.kind}));
        }
        this.usedTags.addAll(function.getUsedTags());
        this.stack.push(function);
    }

    private void pushValue(String value) {
        this.stack.push(new ValueOp(value));
    }
}

