/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.osmstyle.actions;

import uk.me.parabola.mkgmap.osmstyle.actions.ValueFilter;
import uk.me.parabola.mkgmap.reader.osm.Element;
import uk.me.parabola.mkgmap.reader.osm.TagDict;

public class ValueItem {
    private String tagname;
    private short tagKey;
    private ValueFilter filter;
    private String value;
    private boolean tagnameIsLocal;

    public ValueItem() {
    }

    public ValueItem(String value) {
        this.value = value;
    }

    public String getValue(Element el, Element localElement) {
        if (this.tagname == null && this.value != null) {
            return this.value;
        }
        if (this.tagname != null) {
            Element e = this.tagnameIsLocal ? localElement : el;
            String tagval = e.getTag(this.tagKey);
            this.value = this.filter != null ? this.filter.filter(tagval, localElement) : tagval;
        }
        return this.value;
    }

    public void addFilter(ValueFilter f) {
        if (this.filter == null) {
            this.filter = f;
        } else {
            this.filter.add(f);
        }
    }

    public String getTagname() {
        return this.tagname;
    }

    public void setTagname(String tagname, boolean local) {
        this.tagname = tagname;
        this.tagnameIsLocal = local;
        this.tagKey = TagDict.getInstance().xlate(tagname);
    }

    public String toString() {
        if (this.tagname == null) {
            return this.value;
        }
        if (this.tagnameIsLocal) {
            return "$(" + this.tagname + ")";
        }
        return "${" + this.tagname + "}";
    }
}

