/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.osmstyle.actions;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.me.parabola.mkgmap.osmstyle.actions.ValueFilter;
import uk.me.parabola.mkgmap.reader.osm.Element;

public class HighwaySymbolFilter
extends ValueFilter {
    private final String prefix;
    private static final Map<String, String> symbols = new HashMap<String, String>();
    private static final int MAX_REF_LENGTH = 8;
    private int maxAlphaNum = 8;
    private int maxAlpha = 8;
    private static final Pattern spacePattern = Pattern.compile(" ", 16);
    private static final Pattern semicolonPattern = Pattern.compile(";", 16);

    public HighwaySymbolFilter(String s) {
        String[] filters = s.split(":");
        String p = symbols.get(filters[0]);
        if (p == null) {
            p = "[" + filters[0] + "]";
        }
        this.prefix = p;
        if (filters.length == 3) {
            this.maxAlphaNum = Integer.parseInt(filters[1]);
            this.maxAlpha = Integer.parseInt(filters[2]);
        } else if (filters.length == 2) {
            this.maxAlpha = this.maxAlphaNum = Integer.parseInt(filters[1]);
        } else {
            this.maxAlphaNum = 8;
            this.maxAlpha = 8;
        }
    }

    @Override
    public String doFilter(String value, Element el) {
        if (value == null) {
            return value;
        }
        String shieldText = spacePattern.matcher(value).replaceAll(Matcher.quoteReplacement(""));
        shieldText = semicolonPattern.matcher(shieldText).replaceAll(Matcher.quoteReplacement("/"));
        boolean isAlphaNum = false;
        for (char c : shieldText.toCharArray()) {
            if (!Character.isDigit(c)) continue;
            isAlphaNum = true;
            break;
        }
        int codePointLength = shieldText.codePointCount(0, shieldText.length());
        if (isAlphaNum && codePointLength > this.maxAlphaNum || !isAlphaNum && codePointLength > this.maxAlpha) {
            return value;
        }
        return this.prefix + shieldText;
    }

    static {
        symbols.put("interstate", "\u0001");
        symbols.put("shield", "\u0002");
        symbols.put("round", "\u0003");
        symbols.put("hbox", "\u0004");
        symbols.put("box", "\u0005");
        symbols.put("oval", "\u0006");
    }
}

