/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.osmstyle.actions;

import uk.me.parabola.mkgmap.osmstyle.actions.ValueBuildedAction;
import uk.me.parabola.mkgmap.osmstyle.actions.ValueBuilder;
import uk.me.parabola.mkgmap.reader.osm.Element;
import uk.me.parabola.mkgmap.reader.osm.TagDict;

public class AddTagAction
extends ValueBuildedAction {
    private final boolean modify;
    private final String tag;
    private final short tagKey;
    private Element valueTags;

    public AddTagAction(String tag, String value, boolean modify) {
        this.modify = modify;
        this.tag = tag;
        this.tagKey = TagDict.getInstance().xlate(tag);
        this.add(value);
    }

    @Override
    public boolean perform(Element el) {
        if (!this.modify && el.getTag(this.tagKey) != null) {
            return false;
        }
        Element tags = this.valueTags != null ? this.valueTags : el;
        for (ValueBuilder value : this.getValueBuilder()) {
            String newval = value.build(tags, el);
            if (newval == null) continue;
            el.addTag(this.tagKey, newval);
            return true;
        }
        return false;
    }

    public void setValueTags(Element valueTags) {
        this.valueTags = valueTags;
    }

    public String toString() {
        return (this.modify ? "set " : "add ") + this.tag + "=" + this.calcValueBuildersString() + ";";
    }
}

