/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.osmstyle;

import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.osmstyle.eval.Op;
import uk.me.parabola.mkgmap.reader.osm.Element;
import uk.me.parabola.mkgmap.reader.osm.ElementSaver;
import uk.me.parabola.mkgmap.reader.osm.GType;
import uk.me.parabola.mkgmap.reader.osm.Rule;
import uk.me.parabola.mkgmap.reader.osm.TypeResult;

public class ExpressionRule
implements Rule {
    private static final Logger statsLog = Logger.getLogger(ExpressionRule.class.getPackage().getName() + ".stats");
    private Op expression;
    private final GType gtype;
    private Rule finalizeRule;
    private long numEval;
    private long numTrue;
    private static final TypeResult finalizeTypeResult = (el, type) -> {
        throw new UnsupportedOperationException("Finalize rules must not contain an element type definition.");
    };

    public ExpressionRule(Op expression, GType gtype) {
        this.expression = expression;
        this.gtype = gtype;
    }

    @Override
    public void resolveType(Element el, TypeResult result) {
        ++this.numEval;
        if (this.expression.eval(el)) {
            ++this.numTrue;
            if (this.finalizeRule != null) {
                if (this.gtype.isContinueSearch()) {
                    el = el.copy();
                }
                if (this.gtype.getDefaultName() != null) {
                    el.addTag("mkgmap:default_name", this.gtype.getDefaultName());
                }
                this.finalizeRule.resolveType(el, finalizeTypeResult);
            }
            result.add(el, this.gtype);
        }
    }

    @Override
    public int resolveType(int cacheId, Element el, TypeResult result) {
        ++this.numEval;
        if (this.expression.eval(cacheId, el)) {
            ++this.numTrue;
            if (this.finalizeRule != null) {
                if (this.gtype.isContinueSearch()) {
                    el = el.copy();
                }
                if (this.gtype.getDefaultName() != null) {
                    el.addTag("mkgmap:default_name", this.gtype.getDefaultName());
                }
                cacheId = this.finalizeRule.resolveType(cacheId, el, finalizeTypeResult);
            }
            result.add(el, this.gtype);
        }
        return cacheId;
    }

    public String toString() {
        return this.expression.toString() + ' ' + this.gtype;
    }

    @Override
    public void setFinalizeRule(Rule finalizeRule) {
        this.finalizeRule = finalizeRule;
    }

    @Override
    public Rule getFinalizeRule() {
        return this.finalizeRule;
    }

    public Op getOp() {
        return this.expression;
    }

    public void setOp(Op expression) {
        this.expression = expression;
    }

    @Override
    public void printStats(String header) {
        if (statsLog.isInfoEnabled()) {
            statsLog.info(header, "stats (rule/evals/true)", this.toString() + "/" + this.numEval + "/" + this.numTrue);
        }
    }

    @Override
    public boolean containsExpression(String exp) {
        return this.expression.toString().contains(exp);
    }

    @Override
    public void augmentWith(ElementSaver elementSaver) {
        this.expression.augmentWith(elementSaver);
    }
}

