/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.combiners;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import uk.me.parabola.imgfmt.ExitException;
import uk.me.parabola.imgfmt.FileExistsException;
import uk.me.parabola.imgfmt.FileNotWritableException;
import uk.me.parabola.imgfmt.FileSystemParam;
import uk.me.parabola.imgfmt.MapFailedException;
import uk.me.parabola.imgfmt.MapTooBigException;
import uk.me.parabola.imgfmt.Utils;
import uk.me.parabola.imgfmt.app.Area;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.imgfmt.app.map.Map;
import uk.me.parabola.imgfmt.app.map.MapReader;
import uk.me.parabola.imgfmt.app.srt.Sort;
import uk.me.parabola.imgfmt.app.trergn.Point;
import uk.me.parabola.imgfmt.app.trergn.Polygon;
import uk.me.parabola.imgfmt.app.trergn.Polyline;
import uk.me.parabola.imgfmt.app.trergn.Zoom;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.CommandArgs;
import uk.me.parabola.mkgmap.build.MapBuilder;
import uk.me.parabola.mkgmap.combiners.Combiner;
import uk.me.parabola.mkgmap.combiners.FileInfo;
import uk.me.parabola.mkgmap.general.LevelInfo;
import uk.me.parabola.mkgmap.general.MapLine;
import uk.me.parabola.mkgmap.general.MapPoint;
import uk.me.parabola.mkgmap.general.MapShape;
import uk.me.parabola.mkgmap.reader.overview.OverviewMapDataSource;
import uk.me.parabola.mkgmap.srt.SrtTextReader;
import uk.me.parabola.util.EnhancedProperties;

public class OverviewBuilder
implements Combiner {
    Logger log = Logger.getLogger(OverviewBuilder.class);
    public static final String OVERVIEW_PREFIX = "ovm_";
    private OverviewMapDataSource overviewSource;
    private String areaName;
    private String overviewMapname;
    private String overviewMapnumber;
    private String outputDir;
    private Integer codepage;
    private Integer encodingType;
    private List<String[]> copyrightMsgs = new ArrayList<String[]>();
    private List<String[]> licenseInfos = new ArrayList<String[]>();
    private LevelInfo[] wantedLevels;
    private Area bounds;
    private boolean hasBackground;
    private EnhancedProperties overviewProps = new EnhancedProperties();
    private int maxRes = 16;

    public OverviewBuilder() {
        this.overviewSource = new OverviewMapDataSource();
    }

    @Override
    public void init(CommandArgs args) {
        this.areaName = args.get("area-name", "Overview Map");
        this.overviewMapname = args.get("overview-mapname", "osmmap");
        this.overviewMapnumber = args.get("overview-mapnumber", "63240000");
        this.outputDir = args.getOutputDir();
        this.overviewProps = new EnhancedProperties(args.getProperties());
    }

    @Override
    public void onMapEnd(FileInfo finfo) {
        if (!finfo.isImg()) {
            return;
        }
        try {
            this.readFileIntoOverview(finfo);
        }
        catch (FileNotFoundException e) {
            throw new MapFailedException("Could not read detail map " + finfo.getFilename(), e);
        }
    }

    @Override
    public void onFinish() {
        if (!this.hasBackground) {
            List<MapShape> shapes = this.overviewSource.getShapes();
            int inx = shapes.size();
            this.overviewSource.addBackground();
            if (shapes.size() > inx) {
                shapes.add(0, shapes.remove(inx));
            }
        }
        this.calcLevels();
        this.writeOverviewMap();
        this.bounds = this.overviewSource.getBounds();
        this.overviewSource = null;
    }

    @Override
    public String getFilename() {
        return Utils.joinPath(this.outputDir, this.overviewMapname, "img");
    }

    private void calcLevels() {
        if (this.wantedLevels == null) {
            this.setRes(this.maxRes);
        } else {
            int n;
            for (n = this.wantedLevels.length - 1; n > 0 && this.wantedLevels[n].getBits() > this.maxRes; --n) {
            }
            if (n > 0) {
                int l = 0;
                while (n >= 0) {
                    this.wantedLevels[n] = new LevelInfo(l++, this.wantedLevels[n].getBits());
                    --n;
                }
                this.wantedLevels = Arrays.copyOfRange(this.wantedLevels, 0, l);
                this.overviewSource.setMapLevels(this.wantedLevels);
            } else {
                this.setRes(this.maxRes);
            }
        }
    }

    private int checkFixRes(Area detailTileBounds, String tileName) {
        int newMaxRes = this.maxRes;
        int maxSize = Short.MAX_VALUE << 24 - newMaxRes;
        int maxDimPoly = detailTileBounds.getMaxDimension();
        if (maxDimPoly > maxSize) {
            int oldMaxRes = newMaxRes;
            while (maxDimPoly > maxSize) {
                maxSize = 65535 << 24 - --newMaxRes;
            }
            String msg = "Tile selection (0x4a) polygon for";
            String msg2 = tileName != null ? "tile " + tileName : detailTileBounds.toString();
            this.log.error("Tile selection (0x4a) polygon for", msg2, "cannot be written in level 0 resolution", oldMaxRes + ", using", newMaxRes, "instead");
        }
        return newMaxRes;
    }

    private void writeOverviewMap() {
        if (this.overviewSource.mapLevels() == null) {
            return;
        }
        MapBuilder mb = new MapBuilder(false, true);
        mb.setEnableLineCleanFilters(false);
        FileSystemParam params = new FileSystemParam();
        params.setMapDescription(this.areaName);
        mb.setCopyrights(OverviewBuilder.creMsgList(this.copyrightMsgs));
        mb.setMapInfo(OverviewBuilder.creMsgList(this.licenseInfos));
        try {
            if (this.codepage == null) {
                this.codepage = 0;
            }
            Sort sort = SrtTextReader.sortForCodepage(this.codepage);
            Map map = Map.createMap(this.overviewMapname, this.outputDir, params, this.overviewMapnumber, sort, true);
            map.config(this.overviewProps);
            mb.config(this.overviewProps);
            if (this.encodingType != null) {
                map.getLblFile().setEncoder(this.encodingType, this.codepage);
            }
            mb.makeMap(map, this.overviewSource);
            map.close();
        }
        catch (FileExistsException e) {
            throw new ExitException("Could not create overview map", e);
        }
        catch (FileNotWritableException e) {
            throw new ExitException("Could not write to overview map", e);
        }
        catch (MapTooBigException e) {
            throw new MapTooBigException(e.getMaxAllowedSize(), "The overview map is too big.", "Try reducing the highest overview resolution or reducing the amount of information included in the overview.");
        }
    }

    /*
     * WARNING - void declaration
     */
    private void readFileIntoOverview(FileInfo finfo) throws FileNotFoundException {
        MapReader mapReader = null;
        String filename = finfo.getFilename();
        if (this.codepage == null) {
            this.codepage = finfo.getCodePage();
        }
        if (this.codepage.intValue() != finfo.getCodePage()) {
            Logger.defaultLogger.warn((Object)("Input file " + filename + " has different code page " + finfo.getCodePage()));
        }
        try {
            mapReader = new MapReader(filename);
            if (this.encodingType == null) {
                this.encodingType = mapReader.getEncodingType();
            }
            if (this.encodingType.intValue() != mapReader.getEncodingType()) {
                Logger.defaultLogger.warn((Object)("Input file " + filename + " has different charset type " + this.encodingType));
            }
            Object[] msgs = mapReader.getCopyrights();
            boolean found = false;
            for (Object[] objectArray : this.copyrightMsgs) {
                if (!Arrays.deepEquals(objectArray, msgs)) continue;
                found = true;
                break;
            }
            if (!found) {
                this.copyrightMsgs.add((String[])msgs);
            }
            msgs = finfo.getLicenseInfo();
            found = false;
            for (Object[] objectArray : this.licenseInfos) {
                if (!Arrays.deepEquals(objectArray, msgs)) continue;
                found = true;
                break;
            }
            if (!found) {
                this.licenseInfos.add((String[])msgs);
            }
            Zoom[] levels = mapReader.getLevels();
            if (this.wantedLevels == null) {
                void var7_13;
                if (OverviewBuilder.isOverviewImg(filename)) {
                    LevelInfo[] levelInfoArray = new LevelInfo[levels.length - 1];
                    for (int i = 1; i < levels.length; ++i) {
                        levelInfoArray[i - 1] = new LevelInfo(levels[i].getLevel(), levels[i].getResolution());
                    }
                } else {
                    LevelInfo[] levelInfoArray = new LevelInfo[]{new LevelInfo(levels[1].getLevel(), levels[1].getResolution())};
                }
                this.wantedLevels = var7_13;
                this.maxRes = this.wantedLevels[this.wantedLevels.length - 1].getBits();
            }
            this.addMapCoverageArea(finfo);
            if (OverviewBuilder.isOverviewImg(filename)) {
                this.readPoints(mapReader);
                this.readLines(mapReader);
                this.readShapes(mapReader);
            }
        }
        catch (FileNotFoundException e) {
            try {
                throw new ExitException("Could not open " + filename + " when creating overview file");
            }
            catch (Throwable throwable) {
                Utils.closeFile(mapReader);
                throw throwable;
            }
        }
        Utils.closeFile(mapReader);
    }

    private void readPoints(MapReader mapReader) {
        Area sourceBounds = this.overviewSource.getBounds();
        Zoom[] levels = mapReader.getLevels();
        for (int l = 1; l < levels.length; ++l) {
            int min = levels[l].getLevel();
            int res = levels[l].getResolution();
            List<Point> pointList = mapReader.pointsForLevel(min, true);
            for (Point point : pointList) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("got point", point);
                }
                if (!sourceBounds.contains(point.getLocation())) {
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug(point, "dropped, is outside of tile boundary");
                    continue;
                }
                MapPoint mp = new MapPoint();
                mp.setType(point.getType());
                if (point.getLabel() != null) {
                    mp.setName(point.getLabel().getText());
                }
                mp.setMaxResolution(res);
                mp.setMinResolution(res);
                mp.setLocation(point.getLocation());
                this.overviewSource.addPoint(mp);
            }
        }
    }

    private void readLines(MapReader mapReader) {
        Zoom[] levels = mapReader.getLevels();
        for (int l = 1; l < levels.length; ++l) {
            int min = levels[l].getLevel();
            int res = levels[l].getResolution();
            List<Polyline> lineList = mapReader.linesForLevel(min);
            for (Polyline line : lineList) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("got line", line);
                }
                MapLine ml = new MapLine();
                List<Coord> points = line.getPoints();
                if (this.log.isDebugEnabled()) {
                    this.log.debug("line point list", points);
                }
                if (points.size() < 2) continue;
                ml.setType(line.getType());
                if ((line.getType() & 0x40) != 0) {
                    ml.setDirection(true);
                }
                if (line.getLabel() != null) {
                    ml.setName(line.getLabel().getText());
                }
                ml.setMaxResolution(res);
                ml.setMinResolution(res);
                ml.setPoints(points);
                this.overviewSource.addLine(ml);
            }
        }
    }

    private void readShapes(MapReader mapReader) {
        Zoom[] levels = mapReader.getLevels();
        for (int l = 1; l < levels.length; ++l) {
            int min = levels[l].getLevel();
            int res = levels[l].getResolution();
            List<Polygon> list = mapReader.shapesForLevel(min, true);
            for (Polygon shape : list) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("got polygon", shape);
                }
                if (shape.getType() == 75) {
                    this.hasBackground = true;
                }
                MapShape ms = new MapShape();
                List<Coord> points = shape.getPoints();
                if (this.log.isDebugEnabled()) {
                    this.log.debug("polygon point list", points);
                }
                if (points.size() < 3) continue;
                ms.setType(shape.getType());
                if (shape.getLabel() != null) {
                    ms.setName(shape.getLabel().getText());
                }
                ms.setMaxResolution(res);
                ms.setMinResolution(res);
                ms.setPoints(points);
                this.overviewSource.addShape(ms);
            }
        }
    }

    private void addMapCoverageArea(FileInfo finfo) {
        Area bounds = finfo.getBounds();
        List<Coord> points = bounds.toCoords();
        points.forEach(this.overviewSource::addToBounds);
        this.overviewSource.addToTileAreaPath(points);
        this.maxRes = this.checkFixRes(bounds, finfo.getMapname());
        MapShape bg = new MapShape();
        bg.setType(74);
        bg.setPoints(points);
        bg.setMinResolution(0);
        bg.setName(finfo.getDescription() + '\u001d' + finfo.getMapname());
        this.overviewSource.addShape(bg);
    }

    public Area getBounds() {
        if (this.bounds != null) {
            return this.bounds;
        }
        if (this.overviewSource != null) {
            return this.overviewSource.getBounds();
        }
        return new Area(1, 1, -1, -1);
    }

    public static boolean isOverviewImg(String name) {
        return new File(name).getName().startsWith(OVERVIEW_PREFIX);
    }

    public static String getOverviewImgName(String name) {
        File f = new File(name);
        return OVERVIEW_PREFIX + f.getName();
    }

    public static String getMapName(String name) {
        String fname = new File(name).getName();
        if (fname.startsWith(OVERVIEW_PREFIX)) {
            return fname.substring(OVERVIEW_PREFIX.length());
        }
        return name;
    }

    private static List<String> creMsgList(List<String[]> msgs) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < msgs.size(); ++i) {
            String[] block = msgs.get(i);
            list.addAll(Arrays.asList(block));
            if (i >= msgs.size() - 1) continue;
            list.add("");
        }
        return list;
    }

    private void setRes(int resolution) {
        LevelInfo[] mapLevels = new LevelInfo[]{new LevelInfo(0, resolution)};
        this.overviewSource.setMapLevels(mapLevels);
    }
}

