/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import uk.me.parabola.imgfmt.ExitException;
import uk.me.parabola.imgfmt.app.labelenc.BaseEncoder;
import uk.me.parabola.imgfmt.app.labelenc.CharacterEncoder;
import uk.me.parabola.imgfmt.app.labelenc.EncodedText;

public class StructuredOutputStream
extends FilterOutputStream {
    private final CharacterEncoder encoder;

    public StructuredOutputStream(OutputStream out, CharacterEncoder encoder) {
        super(out);
        this.encoder = encoder;
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
    }

    public void write2(int b) throws IOException {
        this.out.write(b);
        this.out.write(b >> 8);
    }

    public void write3(int i) throws IOException {
        this.out.write(i);
        this.out.write(i >> 8);
        this.out.write(i >> 16);
    }

    public void write4(int b) throws IOException {
        this.out.write(b);
        this.out.write(b >> 8);
        this.out.write(b >> 16);
        this.out.write(b >> 24);
    }

    public void writeString(String s) throws IOException {
        if (this.encoder == null) {
            throw new ExitException("tdbfile: character encoding is null");
        }
        EncodedText encodedText = this.encoder.encodeText(s);
        if (encodedText == BaseEncoder.NO_TEXT) {
            return;
        }
        this.out.write(encodedText.getCtext(), 0, encodedText.getLength());
    }
}

