/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.typ;

import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;
import java.util.List;
import uk.me.parabola.imgfmt.app.srt.Sort;
import uk.me.parabola.imgfmt.app.typ.ShapeStacking;
import uk.me.parabola.imgfmt.app.typ.TypIconSet;
import uk.me.parabola.imgfmt.app.typ.TypLine;
import uk.me.parabola.imgfmt.app.typ.TypParam;
import uk.me.parabola.imgfmt.app.typ.TypPoint;
import uk.me.parabola.imgfmt.app.typ.TypPolygon;
import uk.me.parabola.log.Logger;

public class TypData {
    private static final Logger log = Logger.getLogger(TypData.class);
    private final ShapeStacking stacking = new ShapeStacking();
    private final TypParam param = new TypParam();
    private final List<TypPolygon> polygons = new ArrayList<TypPolygon>();
    private final List<TypLine> lines = new ArrayList<TypLine>();
    private final List<TypPoint> points = new ArrayList<TypPoint>();
    private final List<TypIconSet> icons = new ArrayList<TypIconSet>();
    private Sort sort;
    private CharsetEncoder encoder;

    public void addPolygonStackOrder(int level, int type, int subtype) {
        this.stacking.addPolygon(level, type, subtype);
    }

    public Sort getSort() {
        return this.sort;
    }

    public void setSort(Sort sort) {
        if (sort == null) {
            return;
        }
        if (this.sort != null) {
            int origCodepage = this.sort.getCodepage();
            if (origCodepage != 0 && origCodepage != sort.getCodepage()) {
                log.warn("CodePage in TYP txt file:", sort.getCodepage(), "different from --code-page:", origCodepage);
            }
            return;
        }
        this.sort = sort;
        this.encoder = sort.getCharset().newEncoder();
        this.param.setCodePage(sort.getCodepage());
    }

    public void setFamilyId(int val) {
        this.param.setFamilyId(val);
    }

    public void setProductId(int val) {
        this.param.setProductId(val);
    }

    public ShapeStacking getStacking() {
        return this.stacking;
    }

    public TypParam getParam() {
        return this.param;
    }

    public void addPolygon(TypPolygon polygon) {
        this.polygons.add(polygon);
    }

    public CharsetEncoder getEncoder() {
        return this.encoder;
    }

    public List<TypPolygon> getPolygons() {
        return this.polygons;
    }

    public void addLine(TypLine line) {
        this.lines.add(line);
    }

    public List<TypLine> getLines() {
        return this.lines;
    }

    public void addPoint(TypPoint point) {
        this.points.add(point);
    }

    public List<TypPoint> getPoints() {
        return this.points;
    }

    public void addIcon(TypIconSet current) {
        this.icons.add(current);
    }

    public List<TypIconSet> getIcons() {
        return this.icons;
    }
}

