/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.typ;

import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import uk.me.parabola.imgfmt.app.ImgFileWriter;
import uk.me.parabola.imgfmt.app.typ.DrawOrder;

public class ShapeStacking {
    private final SortedMap<Integer, DrawOrder> bar = new TreeMap<Integer, DrawOrder>();

    public void addPolygon(int level, int type, int subtype) {
        int levelType = (level << 16) + type;
        this.bar.computeIfAbsent(levelType, k -> new DrawOrder(type)).addSubtype(subtype);
    }

    public void write(ImgFileWriter writer) {
        int lastLevel = 1;
        DrawOrder empty = new DrawOrder(0);
        for (Map.Entry<Integer, DrawOrder> ent : this.bar.entrySet()) {
            int level = ent.getKey() >> 16 & 0xFFFF;
            DrawOrder order = ent.getValue();
            if (level != lastLevel) {
                empty.write(writer);
                lastLevel = level;
            }
            order.write(writer);
        }
    }
}

