/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.mdr;

import java.util.ArrayList;
import java.util.List;
import uk.me.parabola.imgfmt.app.ImgFileWriter;
import uk.me.parabola.imgfmt.app.mdr.HasHeaderFlags;
import uk.me.parabola.imgfmt.app.mdr.Mdr8Record;
import uk.me.parabola.imgfmt.app.mdr.MdrConfig;
import uk.me.parabola.imgfmt.app.mdr.MdrSection;

public class Mdr8
extends MdrSection
implements HasHeaderFlags {
    private static final int STRING_WIDTH = 4;
    private List<Mdr8Record> index = new ArrayList<Mdr8Record>();

    public Mdr8(MdrConfig config) {
        this.setConfig(config);
    }

    @Override
    public void writeSectData(ImgFileWriter writer) {
        if (this.index.size() <= 1) {
            return;
        }
        int size = this.associatedSize();
        for (Mdr8Record s : this.index) {
            for (int i = 0; i < 4; ++i) {
                writer.put1u(s.getPrefix()[i]);
            }
            writer.putNu(size, s.getRecordNumber());
        }
    }

    protected int associatedSize() {
        return this.getSizes().getStreetSize();
    }

    @Override
    protected int numberOfItems() {
        return this.index.size() > 1 ? 0 : this.index.size();
    }

    @Override
    public int getItemSize() {
        return 4 + this.associatedSize();
    }

    public void setIndex(List<Mdr8Record> index) {
        this.index = index;
    }

    @Override
    public int getExtraValue() {
        return 1034;
    }
}

