/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.mdr;

import java.util.ArrayList;
import java.util.List;
import uk.me.parabola.imgfmt.app.mdr.Mdr13Record;
import uk.me.parabola.imgfmt.app.mdr.Mdr28Record;
import uk.me.parabola.imgfmt.app.mdr.Mdr2x;
import uk.me.parabola.imgfmt.app.mdr.Mdr7Record;
import uk.me.parabola.imgfmt.app.mdr.MdrConfig;

public class Mdr21
extends Mdr2x {
    public Mdr21(MdrConfig config) {
        this.setConfig(config);
    }

    public void buildFromStreets(List<Mdr7Record> inStreets) {
        ArrayList<Mdr7Record> sorted = new ArrayList<Mdr7Record>(inStreets.size());
        for (Mdr7Record street : inStreets) {
            if (street.getCity() == null || street.getCity().getMdrRegion() == null) continue;
            sorted.add(street);
        }
        sorted.sort((o1, o2) -> {
            int d = Integer.compare(o1.getCity().getMdr21SortPos(), o2.getCity().getMdr21SortPos());
            if (d != 0) {
                return d;
            }
            return Integer.compare(o1.getIndex(), o2.getIndex());
        });
        int lastIndex = -1;
        int record = 0;
        for (Mdr7Record street : sorted) {
            if (lastIndex == street.getIndex()) continue;
            ++record;
            this.streets.add(street);
            Mdr13Record mdrRegion = street.getCity().getMdrRegion();
            if (mdrRegion != null) {
                Mdr28Record mdr28 = mdrRegion.getMdr28();
                mdr28.setMdr21(record);
            }
            lastIndex = street.getIndex();
        }
    }

    @Override
    protected boolean sameGroup(Mdr7Record street1, Mdr7Record street2) {
        return true;
    }

    @Override
    public int getExtraValue() {
        return 71680;
    }
}

