/*
 * Decompiled with CFR 0.152.
 */
package crosby.binary.file;

import com.google.protobuf.ByteString;
import crosby.binary.Fileformat;
import crosby.binary.file.BlockReaderAdapter;
import crosby.binary.file.CompressFlags;
import crosby.binary.file.FileBlockBase;
import crosby.binary.file.FileBlockHead;
import crosby.binary.file.FileBlockPosition;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.zip.Deflater;

public class FileBlock
extends FileBlockBase {
    ByteString data;
    static int warncount = 0;

    private FileBlock(String string, ByteString byteString, ByteString byteString2) {
        super(string, byteString2);
        this.data = byteString;
    }

    public static FileBlock newInstance(String string, ByteString byteString, ByteString byteString2) {
        if (byteString != null && byteString.size() > 0x1000000) {
            System.err.println("Warning: Fileblock has body size too large and may be considered corrupt");
            if (byteString != null && byteString.size() > 0x1F00000) {
                throw new Error("This file has too many entities in a block. Parsers will reject it.");
            }
        }
        if (byteString2 != null && byteString2.size() > 32768) {
            System.err.println("Warning: Fileblock has indexdata too large and may be considered corrupt");
            if (byteString2 != null && byteString2.size() > 65024) {
                throw new Error("This file header is too large. Parsers will reject it.");
            }
        }
        return new FileBlock(string, byteString, byteString2);
    }

    protected void deflateInto(Fileformat.Blob.Builder builder) {
        int n = this.data.size();
        Deflater deflater = new Deflater();
        deflater.setInput(this.data.toByteArray());
        deflater.finish();
        byte[] byArray = new byte[n];
        deflater.deflate(byArray);
        if (!deflater.finished()) {
            if (++warncount > 10 && warncount % 100 == 0) {
                System.out.println("Compressed buffers are too short, causing extra copy");
            }
            byArray = Arrays.copyOf(byArray, n + n / 64 + 16);
            deflater.deflate(byArray, deflater.getTotalOut(), byArray.length - deflater.getTotalOut());
            if (!deflater.finished()) {
                throw new Error("Internal error in compressor");
            }
        }
        ByteString byteString = ByteString.copyFrom((byte[])byArray, (int)0, (int)deflater.getTotalOut());
        builder.setZlibData(byteString);
        deflater.end();
    }

    public FileBlockPosition writeTo(OutputStream outputStream, CompressFlags compressFlags) throws IOException {
        Fileformat.BlobHeader.Builder builder = Fileformat.BlobHeader.newBuilder();
        if (this.indexdata != null) {
            builder.setIndexdata(this.indexdata);
        }
        builder.setType(this.type);
        Fileformat.Blob.Builder builder2 = Fileformat.Blob.newBuilder();
        if (compressFlags == CompressFlags.NONE) {
            builder2.setRaw(this.data);
            builder2.setRawSize(this.data.size());
        } else {
            builder2.setRawSize(this.data.size());
            if (compressFlags == CompressFlags.DEFLATE) {
                this.deflateInto(builder2);
            } else {
                throw new Error("Compression flag not understood");
            }
        }
        Fileformat.Blob blob = builder2.build();
        builder.setDatasize(blob.getSerializedSize());
        Fileformat.BlobHeader blobHeader = builder.build();
        int n = blobHeader.getSerializedSize();
        new DataOutputStream(outputStream).writeInt(n);
        blobHeader.writeTo(outputStream);
        long l = -1L;
        if (outputStream instanceof FileOutputStream) {
            l = ((FileOutputStream)outputStream).getChannel().position();
        }
        blob.writeTo(outputStream);
        return FileBlockPosition.newInstance(this, l, n);
    }

    static void process(InputStream inputStream, BlockReaderAdapter blockReaderAdapter) throws IOException {
        FileBlockHead fileBlockHead = FileBlockHead.readHead(inputStream);
        if (blockReaderAdapter.skipBlock(fileBlockHead)) {
            fileBlockHead.skipContents(inputStream);
        } else {
            blockReaderAdapter.handleBlock(fileBlockHead.readContents(inputStream));
        }
    }

    public ByteString getData() {
        return this.data;
    }
}

