/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.monitor;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.derby.iapi.services.io.FileUtil;
import org.apache.derby.impl.services.monitor.BaseMonitor;
import org.apache.derby.shared.common.info.ProductVersionHolder;

public final class FileMonitor
extends BaseMonitor {
    private File home;
    private ProductVersionHolder engineVersion;
    private static final Map<String, Void> securityProperties = new HashMap<String, Void>();

    public FileMonitor() {
        this.initialize(true);
        this.applicationProperties = this.readApplicationProperties();
    }

    public FileMonitor(Properties properties, PrintWriter printWriter) {
        this.runWithState(properties, printWriter);
    }

    private InputStream PBapplicationPropertiesStream() throws IOException {
        File file = new File(this.home, "derby.properties");
        if (!file.exists()) {
            return null;
        }
        return new FileInputStream(file);
    }

    @Override
    public Object getEnvironment() {
        return this.home;
    }

    private ThreadGroup createDaemonGroup() {
        ThreadGroup threadGroup = new ThreadGroup("derby.daemons");
        threadGroup.setDaemon(true);
        return threadGroup;
    }

    private boolean PBinitialize(boolean bl) {
        if (!bl) {
            this.daemonGroup = this.createDaemonGroup();
        }
        InputStream inputStream = this.getClass().getResourceAsStream("/org/apache/derby/info/engine/info.properties");
        this.engineVersion = ProductVersionHolder.getProductVersionHolderFromMyEnv((InputStream)inputStream);
        String string = System.getProperty("derby.system.home");
        if (string != null) {
            this.home = new File(string);
            if (this.home.exists()) {
                if (!this.home.isDirectory()) {
                    this.report("derby.system.home=" + string + " does not represent a directory");
                    return false;
                }
            } else if (!bl) {
                try {
                    boolean bl2 = false;
                    boolean bl3 = bl2 = this.home.mkdir() || this.home.mkdirs();
                    if (bl2) {
                        FileUtil.limitAccessToOwner(this.home);
                    }
                }
                catch (IOException iOException) {
                    return false;
                }
            }
        }
        return true;
    }

    private String PBgetJVMProperty(String string) {
        return System.getProperty(string);
    }

    @Override
    final boolean initialize(boolean bl) {
        return this.PBinitialize(bl);
    }

    @Override
    final Properties getDefaultModuleProperties() {
        return FileMonitor.super.getDefaultModuleProperties();
    }

    @Override
    public final String getJVMProperty(String string) {
        if (!string.startsWith("derby.")) {
            return this.PBgetJVMProperty(string);
        }
        return this.PBgetJVMProperty(string);
    }

    @Override
    public final synchronized Thread getDaemonThread(Runnable runnable, String string, boolean bl) {
        try {
            return FileMonitor.super.getDaemonThread(runnable, string, bl);
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            if (this.daemonGroup != null && this.daemonGroup.isDestroyed()) {
                this.daemonGroup = this.createDaemonGroup();
                return FileMonitor.super.getDaemonThread(runnable, string, bl);
            }
            throw illegalThreadStateException;
        }
    }

    @Override
    final InputStream applicationPropertiesStream() throws IOException {
        return this.PBapplicationPropertiesStream();
    }

    @Override
    public final ProductVersionHolder getEngineVersion() {
        return this.engineVersion;
    }

    static {
        securityProperties.put("derby.authentication.builtin.algorithm", null);
        securityProperties.put("derby.authentication.provider", null);
        securityProperties.put("derby.database.fullAccessUsers", null);
        securityProperties.put("derby.database.readOnlyAccessUsers", null);
        securityProperties.put("derby.database.sqlAuthorization", null);
        securityProperties.put("derby.connection.requireAuthentication", null);
        securityProperties.put("derby.database.defaultConnectionMode", null);
        securityProperties.put("derby.storage.useDefaultFilePermissions", null);
        securityProperties.put("derby.system.home", null);
    }
}

