/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.reader.osm.boundary;

import it.unimi.dsi.fastutil.shorts.ShortListIterator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.build.Locator;
import uk.me.parabola.mkgmap.osmstyle.NameFinder;
import uk.me.parabola.mkgmap.reader.osm.Element;
import uk.me.parabola.mkgmap.reader.osm.TagDict;
import uk.me.parabola.mkgmap.reader.osm.Tags;
import uk.me.parabola.mkgmap.reader.osm.boundary.Boundary;
import uk.me.parabola.mkgmap.reader.osm.boundary.BoundaryLocationInfo;
import uk.me.parabola.util.EnhancedProperties;

public class BoundaryLocationPreparer {
    private static final Logger log = Logger.getLogger(BoundaryLocationPreparer.class);
    private final Locator locator;
    private static final Pattern COMMA_OR_SEMICOLON_PATTERN = Pattern.compile("[,;]+");
    private final NameFinder nameFinder;
    private static final short TK_POSTAL_CODE = TagDict.getInstance().xlate("postal_code");
    private static final short TK_BOUNDARY = TagDict.getInstance().xlate("boundary");
    public static final int UNSET_ADMIN_LEVEL = 100;
    private static final short TK_ADMIN_LEVEL = TagDict.getInstance().xlate("admin_level");

    public BoundaryLocationPreparer(EnhancedProperties props) {
        this.locator = props != null ? new Locator(props) : null;
        this.nameFinder = new NameFinder(props);
    }

    public BoundaryLocationInfo parseTags(Tags tags) {
        String zip = this.getZip(tags);
        int admLevel = BoundaryLocationPreparer.getAdminLevel(tags);
        String name = this.getName(tags);
        if (admLevel == 2 && this.locator != null) {
            String isoCode = this.locator.addCountry(tags);
            if (isoCode != null) {
                name = isoCode;
            } else {
                log.warn("Country name", name, "not in locator config. Country may not be assigned correctly.");
            }
            log.debug("Coded:", name);
        }
        return new BoundaryLocationInfo(admLevel, name, zip);
    }

    public BoundaryLocationInfo parseTags(Element el) {
        return this.parseTags(el.getCopyOfTags());
    }

    public Map<String, BoundaryLocationInfo> getPreparedLocationInfo(List<Boundary> boundaries) {
        HashMap<String, BoundaryLocationInfo> preparedLocationInfo = new HashMap<String, BoundaryLocationInfo>();
        if (boundaries != null) {
            for (Boundary b : boundaries) {
                preparedLocationInfo.put(b.getId(), this.parseTags(b.getTags()));
            }
        }
        return preparedLocationInfo;
    }

    private String getName(Tags tags) {
        String name;
        if ("2".equals(tags.get(TK_ADMIN_LEVEL))) {
            ShortListIterator shortListIterator = Locator.PREFERRED_NAME_TAG_KEYS.iterator();
            while (shortListIterator.hasNext()) {
                short nameTagKey = (Short)shortListIterator.next();
                String nameTagValue = tags.get(nameTagKey);
                if (nameTagValue == null) continue;
                return BoundaryLocationPreparer.getFirstPart(nameTagValue);
            }
        }
        if ((name = this.nameFinder.getName(tags)) != null) {
            return BoundaryLocationPreparer.getFirstPart(name);
        }
        return null;
    }

    private static String getFirstPart(String name) {
        String[] nameParts = COMMA_OR_SEMICOLON_PATTERN.split(name);
        if (nameParts.length > 0) {
            return nameParts[0].trim().intern();
        }
        return null;
    }

    private String getZip(Tags tags) {
        String zip = tags.get(TK_POSTAL_CODE);
        if (zip == null && "postal_code".equals(tags.get(TK_BOUNDARY))) {
            String[] nameParts;
            String name = tags.get("name");
            if (name == null) {
                name = this.getName(tags);
            }
            if (name != null && (nameParts = name.split(Pattern.quote(" "))).length > 0) {
                zip = nameParts[0].trim();
            }
        }
        return zip;
    }

    private static int getAdminLevel(Tags tags) {
        String level;
        if ("administrative".equals(tags.get(TK_BOUNDARY)) && (level = tags.get(TK_ADMIN_LEVEL)) != null) {
            try {
                int res = Integer.parseInt(level);
                if (res >= 2 && res <= 11) {
                    return res;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 100;
    }
}

