/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.general;

import java.util.List;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.imgfmt.app.lbl.City;
import uk.me.parabola.imgfmt.app.lbl.Zip;
import uk.me.parabola.imgfmt.app.net.Numbers;
import uk.me.parabola.imgfmt.app.net.RoadDef;
import uk.me.parabola.mkgmap.general.MapLine;

public class MapRoad
extends MapLine {
    private final RoadDef roadDef;
    private boolean segmentsFollowing;
    private boolean skipHousenumberProcessing;
    private boolean namedByHousenumberProcessing;
    private boolean namedByIdentifyServiceRoad;
    private final int roadId;

    public MapRoad(int roadId, long OSMid, MapLine line) {
        super(line);
        this.roadId = roadId;
        this.setPoints(line.getPoints());
        this.roadDef = new RoadDef(OSMid, this.getName());
    }

    private MapRoad(MapRoad r) {
        super(r);
        this.roadId = r.roadId;
        this.roadDef = r.roadDef;
        this.segmentsFollowing = r.segmentsFollowing;
    }

    public int getRoadId() {
        return this.roadId;
    }

    @Override
    public MapRoad copy() {
        return new MapRoad(this);
    }

    @Override
    public boolean isRoad() {
        return true;
    }

    public void setRoadClass(int roadClass) {
        this.roadDef.setRoadClass(roadClass);
    }

    public void setSpeed(int speed) {
        this.roadDef.setSpeed(speed);
    }

    public void setOneway() {
        this.roadDef.setOneway();
    }

    public void setToll() {
        this.roadDef.setToll();
    }

    public void paved(boolean p) {
        this.roadDef.paved(p);
    }

    public void ferry(boolean f) {
        this.roadDef.ferry(f);
    }

    public void setSynthesised(boolean s) {
        this.roadDef.setSynthesised(s);
    }

    public void setAccess(byte access) {
        this.roadDef.setAccess(access);
    }

    public void setCarpoolLane() {
        this.roadDef.setCarpoolLane();
    }

    public void setNoThroughRouting() {
        this.roadDef.setNoThroughRouting();
    }

    public void setNumbers(List<Numbers> numbers) {
        this.roadDef.setNumbersList(numbers);
    }

    public List<Numbers> getNumbers() {
        return this.roadDef.getNumbersList();
    }

    public RoadDef getRoadDef() {
        return this.roadDef;
    }

    public void addRoadCity(City c) {
        this.roadDef.addCityIfNotPresent(c);
    }

    public void addRoadZip(Zip z) {
        this.roadDef.addZipIfNotPresent(z);
    }

    public void setRoundabout(boolean r) {
        this.roadDef.setRoundabout(r);
    }

    public void doFlareCheck(boolean fc) {
        this.roadDef.doFlareCheck(fc);
    }

    public boolean hasSegmentsFollowing() {
        return this.segmentsFollowing;
    }

    public void setSegmentsFollowing(boolean segmentsFollowing) {
        this.segmentsFollowing = segmentsFollowing;
    }

    public boolean isSkipHousenumberProcessing() {
        return this.skipHousenumberProcessing;
    }

    public void setSkipHousenumberProcessing(boolean skipHousenumberProcessing) {
        this.skipHousenumberProcessing = skipHousenumberProcessing;
    }

    public boolean isNamedByHousenumberProcessing() {
        return this.namedByHousenumberProcessing;
    }

    public void setNamedByHousenumberProcessing(boolean namedByHousenumberProcessing) {
        this.namedByHousenumberProcessing = namedByHousenumberProcessing;
    }

    public boolean isNamedByIdentifyServiceRoad() {
        return this.namedByIdentifyServiceRoad;
    }

    public void setNamedByIdentifyServiceRoad(boolean namedByIdentifyServiceRoad) {
        this.namedByIdentifyServiceRoad = namedByIdentifyServiceRoad;
    }

    public boolean skipAddToNOD() {
        return this.roadDef.skipAddToNOD();
    }

    public void skipAddToNOD(boolean skip) {
        this.roadDef.skipAddToNOD(skip);
    }

    public boolean addLabel(String label) {
        if (label == null) {
            return false;
        }
        for (int i = 0; i < this.labels.length; ++i) {
            if (this.labels[i] == null) {
                this.labels[i] = label;
                return true;
            }
            if (!this.labels[i].equals(label)) continue;
            return false;
        }
        return false;
    }

    public int getLabelPos(String label) {
        if (label == null) {
            return -1;
        }
        for (int i = 0; i < this.labels.length; ++i) {
            if (this.labels[i] == null) {
                return -1;
            }
            if (!this.labels[i].equals(label)) continue;
            return i;
        }
        return -1;
    }

    public String toString() {
        if ((this.getName() == null || this.getName().isEmpty()) && this.getStreet() != null) {
            return "id=" + this.getRoadDef().getId() + ", (" + this.getStreet() + ")";
        }
        return "id=" + this.getRoadDef().getId() + ", " + this.getName();
    }

    public void resetImgData() {
        this.roadDef.resetImgData();
    }

    public int countNodes() {
        int n = 0;
        for (Coord p : this.getPoints()) {
            if (!p.isNumberNode()) continue;
            ++n;
        }
        return n;
    }
}

