/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.filters;

import java.util.ArrayList;
import java.util.List;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.filters.FilterConfig;
import uk.me.parabola.mkgmap.filters.MapFilter;
import uk.me.parabola.mkgmap.filters.MapFilterChain;
import uk.me.parabola.mkgmap.general.MapElement;
import uk.me.parabola.mkgmap.general.MapLine;
import uk.me.parabola.mkgmap.general.MapRoad;
import uk.me.parabola.mkgmap.general.MapShape;

public class LineSplitterFilter
implements MapFilter {
    private static final Logger log = Logger.getLogger(LineSplitterFilter.class);
    public static final int MAX_POINTS_IN_LINE = 250;
    private int level;
    private boolean isRoutable;

    @Override
    public void init(FilterConfig config) {
        this.level = config.getLevel();
        this.isRoutable = config.hasNet();
    }

    @Override
    public void doFilter(MapElement element, MapFilterChain next) {
        assert (!(element instanceof MapShape) && element instanceof MapLine);
        MapLine line = (MapLine)element;
        List<Coord> points = line.getPoints();
        int npoints = points.size();
        if (npoints <= 250) {
            next.doFilter(element);
            return;
        }
        log.debug((Object)"line has too many points, splitting");
        if (line.isRoad() && this.level == 0 && this.isRoutable && log.isDebugEnabled()) {
            log.debug((Object)("Way " + ((MapRoad)line).getRoadDef() + " has more than " + 250 + " points and is about to be split"));
        }
        boolean last = false;
        int wantedSize = npoints < 500 ? npoints / 2 + 1 : 250;
        int pos = 0;
        while (true) {
            if (pos == 0) {
                log.debug((Object)"saving first part");
            } else if (!last) {
                log.debug((Object)"saving next part");
            } else {
                log.debug((Object)"saving final part");
            }
            MapLine l = line.copy();
            l.setPoints(new ArrayList<Coord>(points.subList(pos, pos + wantedSize)));
            if (wantedSize < 125) {
                log.error("size?", npoints, pos, wantedSize);
            }
            if (!last && line instanceof MapRoad) {
                ((MapRoad)l).setSegmentsFollowing(true);
            }
            next.doFilter(l);
            if (last) break;
            int remaining = npoints - (pos += wantedSize - 1);
            if (remaining <= 250) {
                last = true;
                wantedSize = remaining;
                continue;
            }
            if (remaining >= 500) continue;
            wantedSize = remaining / 2 + 1;
        }
    }
}

