/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.build;

import java.util.ArrayList;
import java.util.List;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.filters.FilterConfig;
import uk.me.parabola.mkgmap.filters.MapFilter;
import uk.me.parabola.mkgmap.filters.MapFilterChain;
import uk.me.parabola.mkgmap.general.MapElement;

public class LayerFilterChain
implements MapFilterChain {
    private static final Logger log = Logger.getLogger(LayerFilterChain.class);
    private List<MapFilter> filters = new ArrayList<MapFilter>();
    private int position;
    private final FilterConfig config;

    public LayerFilterChain(FilterConfig config) {
        this.config = config;
    }

    @Override
    public void doFilter(MapElement element) {
        int nfilters = this.filters.size();
        log.debug("doing filter pos=", this.position, "out of=", nfilters);
        if (this.position >= nfilters) {
            return;
        }
        MapFilter f = this.filters.get(this.position++);
        try {
            f.doFilter(element, this);
            --this.position;
        }
        catch (RuntimeException e) {
            --this.position;
            throw e;
        }
    }

    void startFilter(MapElement element) {
        this.position = 0;
        this.doFilter(element);
    }

    public void addFilter(MapFilter filter) {
        assert (this.config != null);
        filter.init(this.config);
        this.filters.add(filter);
    }
}

