/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import uk.me.parabola.imgfmt.app.ImgFileWriter;
import uk.me.parabola.imgfmt.app.labelenc.CharacterEncoder;
import uk.me.parabola.imgfmt.app.labelenc.CodeFunctions;
import uk.me.parabola.io.StructuredOutputStream;

public abstract class FileBlock {
    private final byte blockId;
    private final ByteArrayOutputStream output = new ByteArrayOutputStream();

    public FileBlock(int blockId) {
        this.blockId = (byte)blockId;
        this.fillHeader();
    }

    protected abstract void writeBody(StructuredOutputStream var1) throws IOException;

    private StructuredOutputStream getStructuredOutput(int codePage) {
        CharacterEncoder enc = CodeFunctions.createEncoderForLBL(0, codePage).getEncoder();
        return new StructuredOutputStream(this.output, enc);
    }

    public void writeTo(ImgFileWriter w, int codePage) throws IOException {
        byte[] b = this.writeToCommon(codePage);
        w.put(b);
    }

    public void writeTo(OutputStream os, int codePage) throws IOException {
        byte[] b = this.writeToCommon(codePage);
        os.write(b);
    }

    private byte[] writeToCommon(int codePage) throws IOException {
        this.writeBody(this.getStructuredOutput(codePage));
        byte[] b = this.output.toByteArray();
        int blockLength = b.length - 3;
        b[1] = (byte)(blockLength & 0xFF);
        b[2] = (byte)(blockLength >> 8 & 0xFF);
        return b;
    }

    private void fillHeader() {
        try {
            byte[] b = new byte[3];
            b[0] = this.blockId;
            this.output.write(b);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

