/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.mdr;

import java.util.ArrayList;
import java.util.List;
import uk.me.parabola.imgfmt.app.ImgFileWriter;
import uk.me.parabola.imgfmt.app.mdr.HasHeaderFlags;
import uk.me.parabola.imgfmt.app.mdr.Mdr13Record;
import uk.me.parabola.imgfmt.app.mdr.MdrConfig;
import uk.me.parabola.imgfmt.app.mdr.MdrSection;

public class Mdr13
extends MdrSection
implements HasHeaderFlags {
    private final List<Mdr13Record> regions = new ArrayList<Mdr13Record>();

    public Mdr13(MdrConfig config) {
        this.setConfig(config);
    }

    public void addRegion(Mdr13Record rec) {
        this.regions.add(rec);
    }

    @Override
    public void writeSectData(ImgFileWriter writer) {
        this.regions.sort(null);
        for (Mdr13Record region : this.regions) {
            this.putMapIndex(writer, region.getMapIndex());
            writer.put2u(region.getRegionIndex());
            writer.put2u(region.getCountryIndex());
            this.putStringOffset(writer, region.getStrOffset());
        }
    }

    @Override
    public int getItemSize() {
        return this.getSizes().getMapSize() + 4 + this.getSizes().getStrOffSize();
    }

    @Override
    protected int numberOfItems() {
        return this.regions.size();
    }

    @Override
    public int getExtraValue() {
        return 0;
    }

    public List<Mdr13Record> getRegions() {
        return this.regions;
    }
}

