/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.mdr;

import java.util.Arrays;
import java.util.Set;
import uk.me.parabola.imgfmt.MapFailedException;
import uk.me.parabola.imgfmt.app.BufferedImgFileReader;
import uk.me.parabola.imgfmt.app.FileBackedImgFileWriter;
import uk.me.parabola.imgfmt.app.ImgFile;
import uk.me.parabola.imgfmt.app.ImgFileWriter;
import uk.me.parabola.imgfmt.app.Label;
import uk.me.parabola.imgfmt.app.lbl.Country;
import uk.me.parabola.imgfmt.app.lbl.Region;
import uk.me.parabola.imgfmt.app.lbl.Zip;
import uk.me.parabola.imgfmt.app.mdr.HasHeaderFlags;
import uk.me.parabola.imgfmt.app.mdr.MDRHeader;
import uk.me.parabola.imgfmt.app.mdr.Mdr1;
import uk.me.parabola.imgfmt.app.mdr.Mdr10;
import uk.me.parabola.imgfmt.app.mdr.Mdr11;
import uk.me.parabola.imgfmt.app.mdr.Mdr11Record;
import uk.me.parabola.imgfmt.app.mdr.Mdr12;
import uk.me.parabola.imgfmt.app.mdr.Mdr13;
import uk.me.parabola.imgfmt.app.mdr.Mdr13Record;
import uk.me.parabola.imgfmt.app.mdr.Mdr14;
import uk.me.parabola.imgfmt.app.mdr.Mdr14Record;
import uk.me.parabola.imgfmt.app.mdr.Mdr15;
import uk.me.parabola.imgfmt.app.mdr.Mdr17;
import uk.me.parabola.imgfmt.app.mdr.Mdr18;
import uk.me.parabola.imgfmt.app.mdr.Mdr19;
import uk.me.parabola.imgfmt.app.mdr.Mdr20;
import uk.me.parabola.imgfmt.app.mdr.Mdr21;
import uk.me.parabola.imgfmt.app.mdr.Mdr22;
import uk.me.parabola.imgfmt.app.mdr.Mdr23;
import uk.me.parabola.imgfmt.app.mdr.Mdr24;
import uk.me.parabola.imgfmt.app.mdr.Mdr25;
import uk.me.parabola.imgfmt.app.mdr.Mdr26;
import uk.me.parabola.imgfmt.app.mdr.Mdr27;
import uk.me.parabola.imgfmt.app.mdr.Mdr28;
import uk.me.parabola.imgfmt.app.mdr.Mdr29;
import uk.me.parabola.imgfmt.app.mdr.Mdr4;
import uk.me.parabola.imgfmt.app.mdr.Mdr5;
import uk.me.parabola.imgfmt.app.mdr.Mdr5Record;
import uk.me.parabola.imgfmt.app.mdr.Mdr6;
import uk.me.parabola.imgfmt.app.mdr.Mdr7;
import uk.me.parabola.imgfmt.app.mdr.Mdr8;
import uk.me.parabola.imgfmt.app.mdr.Mdr9;
import uk.me.parabola.imgfmt.app.mdr.MdrConfig;
import uk.me.parabola.imgfmt.app.mdr.MdrMapSection;
import uk.me.parabola.imgfmt.app.mdr.MdrSection;
import uk.me.parabola.imgfmt.app.mdr.MdrUtils;
import uk.me.parabola.imgfmt.app.net.RoadDef;
import uk.me.parabola.imgfmt.app.srt.Sort;
import uk.me.parabola.imgfmt.app.trergn.Point;
import uk.me.parabola.imgfmt.fs.ImgChannel;
import uk.me.parabola.log.Logger;

public class MDRFile
extends ImgFile {
    private final MDRHeader mdrHeader;
    private final Mdr1 mdr1;
    private final Mdr4 mdr4;
    private final Mdr5 mdr5;
    private final Mdr6 mdr6;
    private final Mdr7 mdr7;
    private final Mdr8 mdr8;
    private final Mdr9 mdr9;
    private final Mdr10 mdr10;
    private final Mdr11 mdr11;
    private final Mdr12 mdr12;
    private final Mdr13 mdr13;
    private final Mdr14 mdr14;
    private final Mdr15 mdr15;
    private final Mdr17 mdr17;
    private final Mdr18 mdr18;
    private final Mdr19 mdr19;
    private final Mdr20 mdr20;
    private final Mdr21 mdr21;
    private final Mdr22 mdr22;
    private final Mdr23 mdr23;
    private final Mdr24 mdr24;
    private final Mdr25 mdr25;
    private final Mdr26 mdr26;
    private final Mdr27 mdr27;
    private final Mdr28 mdr28;
    private final Mdr29 mdr29;
    private int currentMap;
    private final boolean forDevice;
    private final boolean isMulti;
    private final MdrSection[] sections;
    private MdrSection.PointerSizes sizes;
    private Set<String> mdr7Del;
    private Set<Integer> poiExclTypes;

    public MDRFile(ImgChannel chan, MdrConfig config) {
        Sort sort = config.getSort();
        this.forDevice = config.isForDevice();
        this.isMulti = config.getSort().isMulti();
        this.mdr7Del = config.getMdr7Del();
        this.poiExclTypes = config.getPoiExclTypes();
        this.mdrHeader = new MDRHeader(config.getHeaderLen());
        this.mdrHeader.setSort(sort);
        this.setHeader(this.mdrHeader);
        if (config.isWritable()) {
            FileBackedImgFileWriter fileWriter = new FileBackedImgFileWriter(chan, config.getOutputDir());
            this.setWriter(fileWriter);
            this.position(this.mdrHeader.getHeaderLength());
        } else {
            this.setReader(new BufferedImgFileReader(chan));
            this.mdrHeader.readHeader(this.getReader());
        }
        this.mdr1 = new Mdr1(config);
        this.mdr4 = new Mdr4(config);
        this.mdr5 = new Mdr5(config);
        this.mdr6 = new Mdr6(config);
        this.mdr7 = new Mdr7(config);
        this.mdr8 = new Mdr8(config);
        this.mdr9 = new Mdr9(config);
        this.mdr10 = new Mdr10(config);
        this.mdr11 = new Mdr11(config);
        this.mdr12 = new Mdr12(config);
        this.mdr13 = new Mdr13(config);
        this.mdr14 = new Mdr14(config);
        this.mdr15 = new Mdr15(config);
        this.mdr17 = new Mdr17(config);
        this.mdr18 = new Mdr18(config);
        this.mdr19 = new Mdr19(config);
        this.mdr20 = new Mdr20(config);
        this.mdr21 = new Mdr21(config);
        this.mdr22 = new Mdr22(config);
        this.mdr23 = new Mdr23(config);
        this.mdr24 = new Mdr24(config);
        this.mdr25 = new Mdr25(config);
        this.mdr26 = new Mdr26(config);
        this.mdr27 = new Mdr27(config);
        this.mdr28 = new Mdr28(config);
        this.mdr29 = new Mdr29(config);
        this.sections = new MdrSection[]{null, this.mdr1, null, null, this.mdr4, this.mdr5, this.mdr6, this.mdr7, this.mdr8, this.mdr9, this.mdr10, this.mdr11, this.mdr12, this.mdr13, this.mdr14, this.mdr15, null, this.mdr17, this.mdr18, this.mdr19, this.mdr20, this.mdr21, this.mdr22, this.mdr23, this.mdr24, this.mdr25, this.mdr26, this.mdr27, this.mdr28, this.mdr29};
        this.mdr11.setMdr10(this.mdr10);
    }

    public void addMap(int mapName, int codePage) {
        ++this.currentMap;
        this.mdr1.addMap(mapName, this.currentMap);
        Sort sort = this.mdrHeader.getSort();
        if (sort.getCodepage() != codePage) {
            Logger.defaultLogger.warn((Object)"Input files have different code pages");
        }
    }

    public Mdr14Record addCountry(Country country) {
        Mdr14Record record = new Mdr14Record();
        String name = country.getLabel().getText();
        record.setMapIndex(this.currentMap);
        record.setCountryIndex(country.getIndex());
        record.setLblOffset(country.getLabel().getOffset());
        record.setName(name);
        record.setStrOff(this.createString(name));
        this.mdr14.addCountry(record);
        return record;
    }

    public Mdr13Record addRegion(Region region, Mdr14Record country) {
        Mdr13Record record = new Mdr13Record();
        String name = region.getLabel().getText();
        record.setMapIndex(this.currentMap);
        record.setLblOffset(region.getLabel().getOffset());
        record.setCountryIndex(region.getCountry().getIndex());
        record.setRegionIndex(region.getIndex());
        record.setName(name);
        record.setStrOffset(this.createString(name));
        record.setMdr14(country);
        this.mdr13.addRegion(record);
        return record;
    }

    public void addCity(Mdr5Record city) {
        int labelOffset = city.getLblOffset();
        if (labelOffset != 0) {
            String name = city.getName();
            assert (name != null) : "off=" + labelOffset;
            city.setMapIndex(this.currentMap);
            city.setStringOffset(this.createString(name));
            this.mdr5.addCity(city);
        }
    }

    public void addZip(Zip zip) {
        int strOff = this.createString(zip.getLabel().getText());
        this.mdr6.addZip(this.currentMap, zip, strOff);
    }

    public void addPoint(Point point, Mdr5Record city, boolean isCity) {
        assert (this.currentMap > 0);
        int fullType = point.getType();
        if (!MdrUtils.canBeIndexed(fullType)) {
            return;
        }
        if (!this.poiExclTypes.isEmpty()) {
            int t;
            int n = t = fullType < 255 ? fullType << 8 : fullType;
            if (this.poiExclTypes.contains(t)) {
                return;
            }
        }
        Label label = point.getLabel();
        String name = label.getText();
        int strOff = this.createString(name);
        Mdr11Record poi = this.mdr11.addPoi(this.currentMap, point, name, strOff);
        poi.setCity(city);
        poi.setIsCity(isCity);
        poi.setType(fullType);
        this.mdr4.addType(fullType);
    }

    public void addStreet(RoadDef street, Mdr5Record mdrCity) {
        for (Label lab : street.getLabels()) {
            if (lab == null) break;
            if (lab.getOffset() == 0) continue;
            String name = lab.getText();
            if (!this.mdr7Del.isEmpty()) {
                String[] parts = name.split(" ");
                int pos = parts.length;
                int i = parts.length - 1;
                while (i >= 0 && this.mdr7Del.contains(parts[i])) {
                    pos = i--;
                }
                if (pos == 0) continue;
                if (pos < parts.length) {
                    StringBuilder sb = new StringBuilder();
                    int i2 = 0;
                    while (i2 + 1 < pos) {
                        sb.append(parts[i2]);
                        sb.append(" ");
                        ++i2;
                    }
                    sb.append(parts[pos - 1]);
                    name = sb.toString();
                }
            }
            int strOff = this.createString(name);
            this.mdr7.addStreet(this.currentMap, name, lab.getOffset(), strOff, mdrCity);
        }
    }

    public void write() {
        this.mdr15.release();
        ImgFileWriter writer = this.getWriter();
        this.writeSections(writer);
        this.position(0L);
        this.getHeader().writeHeader(writer);
    }

    private void writeSections(ImgFileWriter writer) {
        this.sizes = new MdrSection.PointerSizes(this.sections);
        this.mdr7.trim();
        this.mdr28.buildFromRegions(this.mdr13.getRegions());
        this.mdr23.sortRegions(this.mdr13.getRegions());
        this.mdr29.buildFromCountries(this.mdr14.getCountries());
        this.mdr24.sortCountries(this.mdr14.getCountries());
        this.mdr26.sortMdr28(this.mdr28.getIndex());
        this.writeSection(writer, 4, this.mdr4);
        this.mdr1.preWrite();
        this.mdr5.preWrite();
        this.mdr20.preWrite();
        this.writeSection(writer, 11, this.mdr11);
        this.mdr10.setNumberOfPois(this.mdr11.getNumberOfPois());
        this.mdr12.setIndex(this.mdr11.getIndex());
        this.mdr19.setPois(this.mdr11.getPois());
        if (this.forDevice && !this.isMulti) {
            this.mdr17.addPois(this.mdr11.getPois());
        }
        this.mdr11.release();
        if (this.forDevice) {
            this.mdr19.preWrite();
            this.writeSection(writer, 19, this.mdr19);
            this.mdr18.setPoiTypes(this.mdr19.getPoiTypes());
            this.mdr19.release();
            this.writeSection(writer, 18, this.mdr18);
        } else {
            this.mdr19.release();
        }
        this.writeSection(writer, 10, this.mdr10);
        this.mdr9.setGroups(this.mdr10.getGroupSizes());
        this.mdr10.release();
        this.mdr7.preWrite();
        this.mdr20.buildFromStreets(this.mdr7.getStreets());
        this.writeSection(writer, 7, this.mdr7);
        this.writeSection(writer, 5, this.mdr5);
        this.mdr25.sortCities(this.mdr5.getCities());
        this.mdr27.sortCities(this.mdr5.getCities());
        if (this.forDevice && !this.isMulti) {
            this.mdr17.addCities(this.mdr5.getSortedCities());
        }
        this.mdr5.release();
        this.writeSection(writer, 6, this.mdr6);
        this.writeSection(writer, 20, this.mdr20);
        this.mdr20.release();
        this.mdr21.buildFromStreets(this.mdr7.getStreets());
        this.writeSection(writer, 21, this.mdr21);
        this.mdr21.release();
        this.mdr22.buildFromStreets(this.mdr7.getStreets());
        if (this.forDevice && !this.isMulti) {
            this.mdr17.addStreets(this.mdr7.getSortedStreets());
        }
        this.mdr7.release();
        this.writeSection(writer, 22, this.mdr22);
        if (this.forDevice && !this.isMulti) {
            this.mdr17.addStreetsByCountry(this.mdr22.getStreets());
        }
        this.mdr22.release();
        if (this.forDevice) {
            this.writeSection(writer, 17, this.mdr17);
            this.mdr17.release();
        }
        this.writeSection(writer, 9, this.mdr9);
        if (!this.isMulti) {
            this.writeSection(writer, 12, this.mdr12);
        }
        this.writeSection(writer, 13, this.mdr13);
        this.writeSection(writer, 14, this.mdr14);
        this.writeSection(writer, 15, this.mdr15);
        this.writeSection(writer, 23, this.mdr23);
        this.writeSection(writer, 24, this.mdr24);
        this.writeSection(writer, 25, this.mdr25);
        this.mdr28.preWrite();
        this.writeSection(writer, 26, this.mdr26);
        this.writeSection(writer, 27, this.mdr27);
        this.writeSection(writer, 28, this.mdr28);
        this.writeSection(writer, 29, this.mdr29);
        this.mdr1.writeSubSections(writer);
        this.mdrHeader.setPosition(1, writer.position());
        this.mdr1.writeSectData(writer);
        this.mdrHeader.setItemSize(1, this.mdr1.getItemSize());
        this.mdrHeader.setEnd(1, writer.position());
        this.mdrHeader.setExtraValue(1, this.mdr1.getExtraValue());
        if (writer.position() < 0) {
            throw new MapFailedException("MDR sub file is too large");
        }
    }

    private void writeSection(ImgFileWriter writer, int sectionNumber, MdrSection section) {
        if (this.forDevice && Arrays.asList(13, 14, 15, 21, 23, 26, 27, 28).contains(sectionNumber)) {
            return;
        }
        section.setSizes(this.sizes);
        this.mdrHeader.setPosition(sectionNumber, writer.position());
        this.mdr1.setStartPosition(sectionNumber);
        section.preWrite();
        if (!this.forDevice && section instanceof MdrMapSection) {
            MdrMapSection mapSection = (MdrMapSection)section;
            mapSection.setMapIndex(this.mdr1);
            mapSection.initIndex(sectionNumber);
        }
        if (section instanceof HasHeaderFlags) {
            this.mdrHeader.setExtraValue(sectionNumber, ((HasHeaderFlags)((Object)section)).getExtraValue());
        }
        section.writeSectData(writer);
        int itemSize = section.getItemSize();
        if (itemSize > 0) {
            this.mdrHeader.setItemSize(sectionNumber, itemSize);
        }
        this.mdrHeader.setEnd(sectionNumber, writer.position());
        this.mdr1.setEndPosition(sectionNumber);
    }

    private int createString(String str) {
        if (this.forDevice) {
            return -1;
        }
        return this.mdr15.createString(str);
    }
}

