/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.BitmapAndAgg$;
import org.apache.spark.sql.catalyst.expressions.BitmapExpressionUtils;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.aggregate.ImperativeAggregate;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.trees.UnaryLike;
import org.apache.spark.sql.catalyst.types.DataTypeUtils$;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ExpressionDescription(usage="\n    _FUNC_(child) - Returns a bitmap that is the bitwise AND of all of the bitmaps from the child\n    expression. The input should be bitmaps created from bitmap_construct_agg().\n  ", examples="\n    Examples:\n      > SELECT substring(hex(_FUNC_(col)), 0, 6) FROM VALUES (X 'F0'), (X '70'), (X '30') AS tab(col);\n       300000\n      > SELECT substring(hex(_FUNC_(col)), 0, 6) FROM VALUES (X 'FF'), (X 'FF'), (X 'FF') AS tab(col);\n       FF0000\n  ", since="4.1.0", group="agg_funcs")
@ScalaSignature(bytes="\u0006\u0005\t\re\u0001B\u00193\u0001~B\u0001B\u0019\u0001\u0003\u0016\u0004%\ta\u0019\u0005\tI\u0002\u0011\t\u0012)A\u0005\u0019\"AQ\r\u0001BK\u0002\u0013\u0005a\r\u0003\u0005k\u0001\tE\t\u0015!\u0003h\u0011!Y\u0007A!f\u0001\n\u00031\u0007\u0002\u00037\u0001\u0005#\u0005\u000b\u0011B4\t\u000b5\u0004A\u0011\u00018\t\u000b5\u0004A\u0011A:\t\u000bU\u0004A\u0011\t<\t\u000bu\u0004A\u0011\t@\t\u000f\u0005-\u0001\u0001\"\u0011\u0002\u000e!9\u0011q\u0004\u0001\u0005R\u0005\u0005\u0002bBA\u0014\u0001\u0011\u0005\u0013\u0011\u0006\u0005\b\u0003_\u0001A\u0011IA\u0019\u0011\u001d\t9\u0004\u0001C!\u0003sAq!!\u0011\u0001\t\u0003\n\u0019\u0005C\u0005\u0002L\u0001\u0011\r\u0011\"\u0003\u0002N!A\u0011Q\u000b\u0001!\u0002\u0013\ty\u0005C\u0004\u0002X\u0001!\t%!\u0017\t\u000f\u0005\u0005\u0004\u0001\"\u0011\u0002d!I\u0011\u0011\u000f\u0001C\u0002\u0013\u0005\u0013\u0011\f\u0005\t\u0003g\u0002\u0001\u0015!\u0003\u0002\\!9\u0011Q\u000f\u0001\u0005B\u0005]\u0004bBAF\u0001\u0011\u0005\u0013Q\u0012\u0005\b\u0003+\u0003A\u0011IAL\u0011\u001d\t\t\u000b\u0001C!\u0003GC\u0011\"!,\u0001\u0003\u0003%\t!a,\t\u0013\u0005]\u0006!%A\u0005\u0002\u0005e\u0006\"CAh\u0001E\u0005I\u0011AAi\u0011%\t)\u000eAI\u0001\n\u0003\t\t\u000eC\u0005\u0002X\u0002\t\t\u0011\"\u0011\u0002Z\"A\u0011\u0011\u001e\u0001\u0002\u0002\u0013\u0005a\rC\u0005\u0002l\u0002\t\t\u0011\"\u0001\u0002n\"I\u00111\u001f\u0001\u0002\u0002\u0013\u0005\u0013Q\u001f\u0005\n\u0005\u0007\u0001\u0011\u0011!C\u0001\u0005\u000bA\u0011B!\u0003\u0001\u0003\u0003%\tEa\u0003\t\u0013\t=\u0001!!A\u0005B\tEq!\u0003B\u001be\u0005\u0005\t\u0012\u0001B\u001c\r!\t$'!A\t\u0002\te\u0002BB7(\t\u0003\u0011\t\u0006C\u0005\u0003T\u001d\n\t\u0011\"\u0012\u0003V!I!qK\u0014\u0002\u0002\u0013\u0005%\u0011\f\u0005\n\u0005C:\u0013\u0013!C\u0001\u0003#D\u0011Ba\u0019(#\u0003%\t!!5\t\u0013\t\u0015t%!A\u0005\u0002\n\u001d\u0004\"\u0003B;OE\u0005I\u0011AAi\u0011%\u00119hJI\u0001\n\u0003\t\t\u000eC\u0005\u0003z\u001d\n\t\u0011\"\u0003\u0003|\ta!)\u001b;nCB\fe\u000eZ!hO*\u00111\u0007N\u0001\fKb\u0004(/Z:tS>t7O\u0003\u00026m\u0005A1-\u0019;bYf\u001cHO\u0003\u00028q\u0005\u00191/\u001d7\u000b\u0005eR\u0014!B:qCJ\\'BA\u001e=\u0003\u0019\t\u0007/Y2iK*\tQ(A\u0002pe\u001e\u001c\u0001aE\u0003\u0001\u0001\u001a\u0003f\u000b\u0005\u0002B\t6\t!I\u0003\u0002De\u0005I\u0011mZ4sK\u001e\fG/Z\u0005\u0003\u000b\n\u00131#S7qKJ\fG/\u001b<f\u0003\u001e<'/Z4bi\u0016\u00042a\u0012&M\u001b\u0005A%BA%5\u0003\u0015!(/Z3t\u0013\tY\u0005JA\u0005V]\u0006\u0014\u0018\u0010T5lKB\u0011QJT\u0007\u0002e%\u0011qJ\r\u0002\u000b\u000bb\u0004(/Z:tS>t\u0007CA)U\u001b\u0005\u0011&\"A*\u0002\u000bM\u001c\u0017\r\\1\n\u0005U\u0013&a\u0002)s_\u0012,8\r\u001e\t\u0003/~s!\u0001W/\u000f\u0005ecV\"\u0001.\u000b\u0005ms\u0014A\u0002\u001fs_>$h(C\u0001T\u0013\tq&+A\u0004qC\u000e\\\u0017mZ3\n\u0005\u0001\f'\u0001D*fe&\fG.\u001b>bE2,'B\u00010S\u0003\u0015\u0019\u0007.\u001b7e+\u0005a\u0015AB2iS2$\u0007%\u0001\fnkR\f'\r\\3BO\u001e\u0014UO\u001a4fe>3gm]3u+\u00059\u0007CA)i\u0013\tI'KA\u0002J]R\fq#\\;uC\ndW-Q4h\u0005V4g-\u001a:PM\u001a\u001cX\r\u001e\u0011\u0002)%t\u0007/\u001e;BO\u001e\u0014UO\u001a4fe>3gm]3u\u0003UIg\u000e];u\u0003\u001e<')\u001e4gKJ|eMZ:fi\u0002\na\u0001P5oSRtD\u0003B8qcJ\u0004\"!\u0014\u0001\t\u000b\t<\u0001\u0019\u0001'\t\u000f\u0015<\u0001\u0013!a\u0001O\"91n\u0002I\u0001\u0002\u00049GCA8u\u0011\u0015\u0011\u0007\u00021\u0001M\u0003M\u0019\u0007.Z2l\u0013:\u0004X\u000f\u001e#bi\u0006$\u0016\u0010]3t)\u00059\bC\u0001=|\u001b\u0005I(B\u0001>5\u0003!\tg.\u00197zg&\u001c\u0018B\u0001?z\u0005=!\u0016\u0010]3DQ\u0016\u001c7NU3tk2$\u0018\u0001\u00033bi\u0006$\u0016\u0010]3\u0016\u0003}\u0004B!!\u0001\u0002\b5\u0011\u00111\u0001\u0006\u0004\u0003\u000b1\u0014!\u0002;za\u0016\u001c\u0018\u0002BA\u0005\u0003\u0007\u0011\u0001\u0002R1uCRK\b/Z\u0001\u000baJ,G\u000f^=OC6,WCAA\b!\u0011\t\t\"!\u0007\u000f\t\u0005M\u0011Q\u0003\t\u00033JK1!a\u0006S\u0003\u0019\u0001&/\u001a3fM&!\u00111DA\u000f\u0005\u0019\u0019FO]5oO*\u0019\u0011q\u0003*\u0002)]LG\u000f\u001b(fo\u000eC\u0017\u000e\u001c3J]R,'O\\1m)\ry\u00171\u0005\u0005\u0007\u0003Ka\u0001\u0019\u0001'\u0002\u00119,wo\u00115jY\u0012\fQd^5uQ:+w/T;uC\ndW-Q4h\u0005V4g-\u001a:PM\u001a\u001cX\r\u001e\u000b\u0004\u0001\u0006-\u0002BBA\u0017\u001b\u0001\u0007q-A\roK^lU\u000f^1cY\u0016\fum\u001a\"vM\u001a,'o\u00144gg\u0016$\u0018aG<ji\"tUm^%oaV$\u0018iZ4Ck\u001a4WM](gMN,G\u000fF\u0002A\u0003gAa!!\u000e\u000f\u0001\u00049\u0017a\u00068fo&s\u0007/\u001e;BO\u001e\u0014UO\u001a4fe>3gm]3u\u0003!qW\u000f\u001c7bE2,WCAA\u001e!\r\t\u0016QH\u0005\u0004\u0003\u007f\u0011&a\u0002\"p_2,\u0017M\\\u0001\u0010C\u001e<')\u001e4gKJ\u001c6\r[3nCV\u0011\u0011Q\t\t\u0005\u0003\u0003\t9%\u0003\u0003\u0002J\u0005\r!AC*ueV\u001cG\u000fV=qK\u0006Q!-\u001b;nCB\fE\u000f\u001e:\u0016\u0005\u0005=\u0003cA'\u0002R%\u0019\u00111\u000b\u001a\u0003%\u0005#HO]5ckR,'+\u001a4fe\u0016t7-Z\u0001\fE&$X.\u00199BiR\u0014\b%A\nbO\u001e\u0014UO\u001a4fe\u0006#HO]5ckR,7/\u0006\u0002\u0002\\A)q+!\u0018\u0002P%\u0019\u0011qL1\u0003\u0007M+\u0017/A\u0007eK\u001a\fW\u000f\u001c;SKN,H\u000e^\u000b\u0003\u0003K\u0002R!UA4\u0003WJ1!!\u001bS\u0005\u0019y\u0005\u000f^5p]B\u0019Q*!\u001c\n\u0007\u0005=$GA\u0004MSR,'/\u00197\u00021%t\u0007/\u001e;BO\u001e\u0014UO\u001a4fe\u0006#HO]5ckR,7/A\rj]B,H/Q4h\u0005V4g-\u001a:BiR\u0014\u0018NY;uKN\u0004\u0013AC5oSRL\u0017\r\\5{KR!\u0011\u0011PA@!\r\t\u00161P\u0005\u0004\u0003{\u0012&\u0001B+oSRDq!!!\u0018\u0001\u0004\t\u0019)\u0001\u0004ck\u001a4WM\u001d\t\u0005\u0003\u000b\u000b9)D\u00015\u0013\r\tI\t\u000e\u0002\f\u0013:$XM\u001d8bYJ{w/\u0001\u0004va\u0012\fG/\u001a\u000b\u0007\u0003s\ny)!%\t\u000f\u0005\u0005\u0005\u00041\u0001\u0002\u0004\"9\u00111\u0013\rA\u0002\u0005\r\u0015!B5oaV$\u0018!B7fe\u001e,GCBA=\u00033\u000bi\nC\u0004\u0002\u001cf\u0001\r!a!\u0002\u000f\t,hMZ3sc!9\u0011qT\rA\u0002\u0005\r\u0015a\u00022vM\u001a,'OM\u0001\u0005KZ\fG\u000e\u0006\u0003\u0002&\u0006-\u0006cA)\u0002(&\u0019\u0011\u0011\u0016*\u0003\u0007\u0005s\u0017\u0010C\u0005\u0002\u0002j\u0001\n\u00111\u0001\u0002\u0004\u0006!1m\u001c9z)\u001dy\u0017\u0011WAZ\u0003kCqAY\u000e\u0011\u0002\u0003\u0007A\nC\u0004f7A\u0005\t\u0019A4\t\u000f-\\\u0002\u0013!a\u0001O\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA^U\ra\u0015QX\u0016\u0003\u0003\u007f\u0003B!!1\u0002L6\u0011\u00111\u0019\u0006\u0005\u0003\u000b\f9-A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011\u001a*\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002N\u0006\r'!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TCAAjU\r9\u0017QX\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u00111\u001c\t\u0005\u0003;\f9/\u0004\u0002\u0002`*!\u0011\u0011]Ar\u0003\u0011a\u0017M\\4\u000b\u0005\u0005\u0015\u0018\u0001\u00026bm\u0006LA!a\u0007\u0002`\u0006a\u0001O]8ek\u000e$\u0018I]5us\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BAS\u0003_D\u0001\"!=\"\u0003\u0003\u0005\raZ\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005]\bCBA}\u0003\u007f\f)+\u0004\u0002\u0002|*\u0019\u0011Q *\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0003\u0002\u0005m(\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!a\u000f\u0003\b!I\u0011\u0011_\u0012\u0002\u0002\u0003\u0007\u0011QU\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0002\\\n5\u0001\u0002CAyI\u0005\u0005\t\u0019A4\u0002\r\u0015\fX/\u00197t)\u0011\tYDa\u0005\t\u0013\u0005EX%!AA\u0002\u0005\u0015\u0006f\u0005\u0001\u0003\u0018\tu!q\u0004B\u0012\u0005K\u0011ICa\u000b\u00030\tE\u0002cA'\u0003\u001a%\u0019!1\u0004\u001a\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012!\u0011E\u0001\u0002n)\u0001\u0003\u0005\t\u0011`\rVs5i\u0018\u0015dQ&dG-\u000b\u0011.AI+G/\u001e:og\u0002\n\u0007EY5u[\u0006\u0004\b\u0005\u001e5bi\u0002J7\u000f\t;iK\u0002\u0012\u0017\u000e^<jg\u0016\u0004\u0013I\u0014#!_\u001a\u0004\u0013\r\u001c7!_\u001a\u0004C\u000f[3!E&$X.\u00199tA\u0019\u0014x.\u001c\u0011uQ\u0016\u00043\r[5mI*\u0001\u0003\u0005\t\u0011fqB\u0014Xm]:j_:t\u0003\u0005\u00165fA%t\u0007/\u001e;!g\"|W\u000f\u001c3!E\u0016\u0004#-\u001b;nCB\u001c\be\u0019:fCR,G\r\t4s_6\u0004#-\u001b;nCB|6m\u001c8tiJ,8\r^0bO\u001eD\u0013F\f\u0006!A\u0005AQ\r_1na2,7/\t\u0002\u0003(\u0005\t9P\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011tk\n\u001cHO]5oO\"BW\r\u001f\u0015`\rVs5i\u0018\u0015d_2L\u0013\u0006\f\u00111Y\u00012\u0014\u0006\t$S\u001f6\u0003c+\u0011'V\u000bN\u0003\u0003\u0006\u0017\u0011(\rB:\u0013\u0006\f\u0011)1\u0002:s\u0007M\u0014*Y\u0001B\u0003\fI\u00144a\u001dJ\u0003%Q*!i\u0006\u0014\u0007fY8mSmR\u0001\u0005\t\u0011!A\u0001\u00023\u0007\r\u00191aAR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e];cgR\u0014\u0018N\\4)Q\u0016D\bf\u0018$V\u001d\u000e{\u0006fY8mS%b\u0003\u0005\r\u0017!m%\u0002cIU(NAY\u000bE*V#TA!B\u0006e\n$GO%b\u0003\u0005\u000b-!O\u00193u%\u000b\u0017!Qa\u0003sE\u0012$(S\u0001\n5\u000b\t;bE\"\u001aw\u000e\\\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u00193\u0005\u0007\r\u00191\u0015\u0001\u0002\u0013!B:j]\u000e,\u0017E\u0001B\u0017\u0003\u0015!d&\r\u00181\u0003\u00159'o\\;qC\t\u0011\u0019$A\u0005bO\u001e|f-\u001e8dg\u0006a!)\u001b;nCB\fe\u000eZ!hOB\u0011QjJ\n\u0006O\tm\"q\t\t\t\u0005{\u0011\u0019\u0005T4h_6\u0011!q\b\u0006\u0004\u0005\u0003\u0012\u0016a\u0002:v]RLW.Z\u0005\u0005\u0005\u000b\u0012yDA\tBEN$(/Y2u\rVt7\r^5p]N\u0002BA!\u0013\u0003P5\u0011!1\n\u0006\u0005\u0005\u001b\n\u0019/\u0001\u0002j_&\u0019\u0001Ma\u0013\u0015\u0005\t]\u0012\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005m\u0017!B1qa2LHcB8\u0003\\\tu#q\f\u0005\u0006E*\u0002\r\u0001\u0014\u0005\bK*\u0002\n\u00111\u0001h\u0011\u001dY'\u0006%AA\u0002\u001d\fq\"\u00199qYf$C-\u001a4bk2$HEM\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%g\u00059QO\\1qa2LH\u0003\u0002B5\u0005c\u0002R!UA4\u0005W\u0002b!\u0015B7\u0019\u001e<\u0017b\u0001B8%\n1A+\u001e9mKNB\u0001Ba\u001d.\u0003\u0003\u0005\ra\\\u0001\u0004q\u0012\u0002\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$#'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HeM\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0005{\u0002B!!8\u0003\u0000%!!\u0011QAp\u0005\u0019y%M[3di\u0002")
public class BitmapAndAgg
extends ImperativeAggregate
implements UnaryLike<Expression>,
Serializable {
    private final Expression child;
    private final int mutableAggBufferOffset;
    private final int inputAggBufferOffset;
    private final AttributeReference bitmapAttr;
    private final Seq<AttributeReference> inputAggBufferAttributes;
    private transient Seq<Expression> children;
    private volatile transient boolean bitmap$trans$0;

    public static int $lessinit$greater$default$3() {
        return BitmapAndAgg$.MODULE$.$lessinit$greater$default$3();
    }

    public static int $lessinit$greater$default$2() {
        return BitmapAndAgg$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple3<Expression, Object, Object>> unapply(BitmapAndAgg x$0) {
        return BitmapAndAgg$.MODULE$.unapply(x$0);
    }

    public static int apply$default$3() {
        return BitmapAndAgg$.MODULE$.apply$default$3();
    }

    public static int apply$default$2() {
        return BitmapAndAgg$.MODULE$.apply$default$2();
    }

    public static Function1<Tuple3<Expression, Object, Object>, BitmapAndAgg> tupled() {
        return BitmapAndAgg$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Object, Function1<Object, BitmapAndAgg>>> curried() {
        return BitmapAndAgg$.MODULE$.curried();
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return UnaryLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return UnaryLike.withNewChildrenInternal$(this, newChildren);
    }

    private Seq<Expression> children$lzycompute() {
        BitmapAndAgg bitmapAndAgg = this;
        synchronized (bitmapAndAgg) {
            if (!this.bitmap$trans$0) {
                this.children = UnaryLike.children$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.children;
    }

    @Override
    public final Seq<Expression> children() {
        if (!this.bitmap$trans$0) {
            return this.children$lzycompute();
        }
        return this.children;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public int mutableAggBufferOffset() {
        return this.mutableAggBufferOffset;
    }

    @Override
    public int inputAggBufferOffset() {
        return this.inputAggBufferOffset;
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        DataType dataType = this.child().dataType();
        BinaryType$ binaryType$ = BinaryType$.MODULE$;
        if (dataType == null ? binaryType$ != null : !dataType.equals(binaryType$)) {
            return new TypeCheckResult.DataTypeMismatch("UNEXPECTED_INPUT_TYPE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paramIndex"), (Object)TypeUtils$.MODULE$.ordinalNumber(0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"requiredType"), (Object)TypeUtils$.MODULE$.toSQLType((AbstractDataType)BinaryType$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputSql"), (Object)TypeUtils$.MODULE$.toSQLExpr(this.child())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"inputType"), (Object)TypeUtils$.MODULE$.toSQLType((AbstractDataType)this.child().dataType()))}))));
        }
        return TypeCheckResult$TypeCheckSuccess$.MODULE$;
    }

    @Override
    public DataType dataType() {
        return BinaryType$.MODULE$;
    }

    @Override
    public String prettyName() {
        return "bitmap_and_agg";
    }

    @Override
    public BitmapAndAgg withNewChildInternal(Expression newChild) {
        return this.copy(newChild, this.copy$default$2(), this.copy$default$3());
    }

    @Override
    public ImperativeAggregate withNewMutableAggBufferOffset(int newMutableAggBufferOffset) {
        int x$1 = newMutableAggBufferOffset;
        Expression x$2 = this.copy$default$1();
        int x$3 = this.copy$default$3();
        return this.copy(x$2, x$1, x$3);
    }

    @Override
    public ImperativeAggregate withNewInputAggBufferOffset(int newInputAggBufferOffset) {
        int x$1 = newInputAggBufferOffset;
        Expression x$2 = this.copy$default$1();
        int x$3 = this.copy$default$2();
        return this.copy(x$2, x$3, x$1);
    }

    @Override
    public boolean nullable() {
        return false;
    }

    @Override
    public StructType aggBufferSchema() {
        return DataTypeUtils$.MODULE$.fromAttributes(this.aggBufferAttributes());
    }

    private AttributeReference bitmapAttr() {
        return this.bitmapAttr;
    }

    @Override
    public Seq<AttributeReference> aggBufferAttributes() {
        AttributeReference attributeReference = this.bitmapAttr();
        return Nil$.MODULE$.$colon$colon((Object)attributeReference);
    }

    @Override
    public Option<Literal> defaultResult() {
        return Option$.MODULE$.apply((Object)Literal$.MODULE$.apply(Array$.MODULE$.fill(BitmapExpressionUtils.NUM_BYTES, (Function0)(JFunction0.mcB.sp & Serializable)() -> -1, (ClassTag)ClassTag$.MODULE$.Byte())));
    }

    @Override
    public Seq<AttributeReference> inputAggBufferAttributes() {
        return this.inputAggBufferAttributes;
    }

    @Override
    public void initialize(InternalRow buffer) {
        buffer.update(this.mutableAggBufferOffset(), Array$.MODULE$.fill(BitmapExpressionUtils.NUM_BYTES, (Function0)(JFunction0.mcB.sp & Serializable)() -> -1, (ClassTag)ClassTag$.MODULE$.Byte()));
    }

    @Override
    public void update(InternalRow buffer, InternalRow input) {
        byte[] input_bitmap = (byte[])this.child().eval(input);
        if (input_bitmap != null) {
            byte[] bitmap = buffer.getBinary(this.mutableAggBufferOffset());
            BitmapExpressionUtils.bitmapAndMerge(bitmap, input_bitmap);
            return;
        }
    }

    @Override
    public void merge(InternalRow buffer1, InternalRow buffer2) {
        byte[] bitmap1 = buffer1.getBinary(this.mutableAggBufferOffset());
        byte[] bitmap2 = buffer2.getBinary(this.inputAggBufferOffset());
        BitmapExpressionUtils.bitmapAndMerge(bitmap1, bitmap2);
    }

    @Override
    public Object eval(InternalRow buffer) {
        return buffer.getBinary(this.mutableAggBufferOffset());
    }

    public BitmapAndAgg copy(Expression child, int mutableAggBufferOffset, int inputAggBufferOffset) {
        return new BitmapAndAgg(child, mutableAggBufferOffset, inputAggBufferOffset);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public int copy$default$2() {
        return this.mutableAggBufferOffset();
    }

    public int copy$default$3() {
        return this.inputAggBufferOffset();
    }

    @Override
    public String productPrefix() {
        return "BitmapAndAgg";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.child();
            }
            case 1: {
                return BoxesRunTime.boxToInteger((int)this.mutableAggBufferOffset());
            }
            case 2: {
                return BoxesRunTime.boxToInteger((int)this.inputAggBufferOffset());
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof BitmapAndAgg;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "child";
            }
            case 1: {
                return "mutableAggBufferOffset";
            }
            case 2: {
                return "inputAggBufferOffset";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof BitmapAndAgg)) return false;
        boolean bl = true;
        if (!bl) return false;
        BitmapAndAgg bitmapAndAgg = (BitmapAndAgg)x$1;
        if (this.mutableAggBufferOffset() != bitmapAndAgg.mutableAggBufferOffset()) return false;
        if (this.inputAggBufferOffset() != bitmapAndAgg.inputAggBufferOffset()) return false;
        Expression expression = this.child();
        Expression expression2 = bitmapAndAgg.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!bitmapAndAgg.canEqual(this)) return false;
        return true;
    }

    public BitmapAndAgg(Expression child, int mutableAggBufferOffset, int inputAggBufferOffset) {
        this.child = child;
        this.mutableAggBufferOffset = mutableAggBufferOffset;
        this.inputAggBufferOffset = inputAggBufferOffset;
        UnaryLike.$init$(this);
        String x$1 = "bitmap";
        BinaryType$ x$2 = BinaryType$.MODULE$;
        boolean x$32 = false;
        Metadata x$4 = AttributeReference$.MODULE$.apply$default$4();
        ExprId x$5 = AttributeReference$.MODULE$.apply$default$5("bitmap", (DataType)x$2, false, x$4);
        Seq<String> x$6 = AttributeReference$.MODULE$.apply$default$6("bitmap", (DataType)x$2, false, x$4);
        this.bitmapAttr = new AttributeReference("bitmap", (DataType)x$2, false, x$4, x$5, x$6);
        this.inputAggBufferAttributes = (Seq)this.aggBufferAttributes().map((Function1 & Serializable)x$3 -> x$3.newInstance());
    }

    public BitmapAndAgg(Expression child) {
        this(child, 0, 0);
    }
}

