/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.tdbfmt;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import uk.me.parabola.io.StructuredInputStream;
import uk.me.parabola.io.StructuredOutputStream;
import uk.me.parabola.mkgmap.combiners.SubFileInfo;
import uk.me.parabola.tdbfmt.OverviewMapBlock;

public class DetailMapBlock
extends OverviewMapBlock {
    public static final int BLOCK_ID = 76;
    private int tdbVersion;
    private List<SubFileInfo> subFiles;

    public DetailMapBlock(int tdbVersion) {
        super(76);
        this.tdbVersion = tdbVersion;
    }

    public DetailMapBlock(StructuredInputStream ds) throws IOException {
        super(ds);
        int i;
        ds.read2();
        int n = ds.read2();
        int[] sizes = new int[n];
        for (i = 0; i < n; ++i) {
            sizes[i] = ds.read4();
        }
        ds.read();
        ds.read();
        ds.read();
        ds.read4();
        this.subFiles = new ArrayList<SubFileInfo>();
        for (i = 0; i < n; ++i) {
            String name = ds.readString();
            SubFileInfo si = new SubFileInfo(name, sizes[i]);
            this.subFiles.add(si);
        }
    }

    @Override
    public void writeBody(StructuredOutputStream os) throws IOException {
        super.writeBody(os);
        assert (this.tdbVersion >= 407);
        int n = this.subFiles.size();
        os.write2(n + 1);
        os.write2(n);
        for (SubFileInfo si : this.subFiles) {
            os.write4((int)si.getSize());
        }
        os.write4(-16727295);
        os.write(0);
        os.write(0);
        os.write(0);
        for (SubFileInfo si : this.subFiles) {
            os.writeString(si.getName());
        }
    }

    public void setSubFiles(List<SubFileInfo> subFiles) {
        this.subFiles = subFiles;
    }
}

