/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.reader.polish;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import uk.me.parabola.imgfmt.MapFailedException;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.imgfmt.app.CoordNode;
import uk.me.parabola.imgfmt.app.net.Numbers;
import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.general.MapLine;
import uk.me.parabola.mkgmap.general.MapRoad;

class RoadHelper {
    private static final Logger log = Logger.getLogger(RoadHelper.class);
    private final Map<Long, CoordNode> nodeCoords = new HashMap<Long, CoordNode>();
    private int roadId;
    private final List<NodeIndex> nodes = new ArrayList<NodeIndex>();
    private int speed;
    private int roadClass;
    private boolean oneway;
    private boolean toll;
    private byte mkgmapAccess;
    private SortedMap<Integer, Numbers> numbersMap;

    public RoadHelper() {
        this.clear();
    }

    public void clear() {
        this.roadId = 0;
        this.nodes.clear();
        this.speed = 0;
        this.roadClass = 0;
        this.oneway = false;
        this.toll = false;
        this.numbersMap = null;
    }

    public void setRoadId(int roadId) {
        this.roadId = roadId;
    }

    public void addNode(String value) {
        String[] f = value.split(",");
        this.nodes.add(new NodeIndex(f));
    }

    public void setParam(String param) {
        String[] f = param.split(",");
        this.speed = Integer.parseInt(f[0]);
        if (this.speed < 0) {
            this.speed = 0;
        }
        if (this.speed > 7) {
            this.speed = 7;
        }
        this.roadClass = Integer.parseInt(f[1]);
        if (this.roadClass < 0) {
            this.roadClass = 0;
        }
        if (this.roadClass > 4) {
            this.roadClass = 4;
        }
        this.oneway = f.length > 2 && Integer.parseInt(f[2]) > 0;
        this.toll = f.length > 3 && Integer.parseInt(f[3]) > 0;
        int noAccess = 0;
        block10: for (int j = 0; j < f.length - 4; ++j) {
            if (Integer.parseInt(f[4 + j]) == 0) continue;
            switch (j) {
                case 0: {
                    noAccess = (byte)(noAccess | 0xFFFFFF80);
                    continue block10;
                }
                case 1: {
                    noAccess = (byte)(noAccess | 8);
                    continue block10;
                }
                case 2: {
                    noAccess = (byte)(noAccess | 4);
                    continue block10;
                }
                case 3: {
                    noAccess = (byte)(noAccess | 0x20);
                    continue block10;
                }
                case 4: {
                    noAccess = (byte)(noAccess | 0x40);
                    continue block10;
                }
                case 5: {
                    noAccess = (byte)(noAccess | 1);
                    continue block10;
                }
                case 6: {
                    noAccess = (byte)(noAccess | 2);
                    continue block10;
                }
                case 7: {
                    noAccess = (byte)(noAccess | 0x10);
                }
            }
        }
        this.mkgmapAccess = (byte)(~noAccess);
    }

    public MapRoad makeRoad(MapLine l) {
        assert (this.roadId != 0);
        if (log.isDebugEnabled()) {
            log.debug((Object)("finishing road id " + this.roadId));
        }
        MapRoad road = new MapRoad(this.roadId, this.roadId, l);
        road.setRoadClass(this.roadClass);
        road.setSpeed(this.speed);
        if (this.oneway) {
            road.setOneway();
        }
        if (this.toll) {
            road.setToll();
        }
        road.setAccess(this.mkgmapAccess);
        List<Coord> points = road.getPoints();
        for (NodeIndex ni : this.nodes) {
            int n2 = ni.index;
            if (log.isDebugEnabled()) {
                log.debug((Object)("road has " + points.size() + " points"));
            }
            if (n2 < 0 || n2 >= points.size()) {
                throw new MapFailedException("bad node index " + n2 + " in road id " + this.roadId);
            }
            Coord coord = points.get(n2);
            long id = coord.getId();
            if (id == 0L) {
                CoordNode node = this.nodeCoords.get(ni.nodeId);
                if (node == null) {
                    node = new CoordNode(coord, ni.nodeId, ni.boundary, false);
                    this.nodeCoords.put(Long.valueOf(ni.nodeId), node);
                }
                points.set(n2, node);
                continue;
            }
            if (id == (long)ni.nodeId) continue;
            log.warn((Object)"Inconsistant node ids");
        }
        if (this.numbersMap != null) {
            if (this.numbersMap.values().stream().anyMatch(n -> !n.isEmpty())) {
                this.convertNodesForHouseNumbers(road);
            } else {
                this.numbersMap = null;
            }
        }
        return road;
    }

    private void convertNodesForHouseNumbers(MapRoad road) {
        List<Coord> points = road.getPoints();
        if (points.isEmpty()) {
            return;
        }
        for (Integer idx : this.numbersMap.keySet()) {
            if (idx < 0 || idx >= points.size()) {
                throw new MapFailedException("bad number node index " + idx + " in road id " + this.roadId);
            }
            road.getPoints().get(idx).setNumberNode(true);
        }
        points.get(0).setNumberNode(true);
        int roadNodeNumber = 0;
        for (int i = 0; i < points.size(); ++i) {
            if (!points.get(i).isNumberNode()) continue;
            Numbers nums = (Numbers)this.numbersMap.get(i);
            if (nums != null) {
                nums.setIndex(roadNodeNumber);
            }
            ++roadNodeNumber;
        }
        road.setNumbers(new ArrayList<Numbers>(this.numbersMap.values()));
    }

    public boolean isRoad() {
        return this.roadId != 0;
    }

    public Map<Long, CoordNode> getNodeCoords() {
        return this.nodeCoords;
    }

    public void addNumbers(Numbers nums) {
        if (this.numbersMap == null) {
            this.numbersMap = new TreeMap<Integer, Numbers>();
        }
        this.numbersMap.put(nums.getPolishIndex(), nums);
    }

    private static class NodeIndex {
        private final int index;
        private final int nodeId;
        private boolean boundary;

        private NodeIndex(String[] f) {
            this.index = Integer.parseInt(f[0]);
            this.nodeId = Integer.parseInt(f[1]);
            if (f.length > 2) {
                boolean bl = this.boundary = Integer.parseInt(f[2]) > 0;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("ind=" + this.index + "node=" + this.nodeId + "bound=" + this.boundary));
            }
        }

        public String toString() {
            return String.format("%d,%d,%b", this.index, this.nodeId, this.boundary);
        }
    }
}

