/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.mkgmap.osmstyle.function;

import uk.me.parabola.log.Logger;
import uk.me.parabola.mkgmap.build.LocatorConfig;
import uk.me.parabola.mkgmap.osmstyle.function.CachedFunction;
import uk.me.parabola.mkgmap.reader.osm.Element;
import uk.me.parabola.mkgmap.reader.osm.TagDict;

public class IsDriveOnLeftFunction
extends CachedFunction {
    private static final Logger log = Logger.getLogger(IsDriveOnLeftFunction.class);
    private static final short TKM_ADM_LVL2 = TagDict.getInstance().xlate("mkgmap:admin_level2");
    private static final short TKM_COUNTRY = TagDict.getInstance().xlate("mkgmap:country");

    public IsDriveOnLeftFunction() {
        super(null);
    }

    @Override
    protected String calcImpl(Element el) {
        String iso = el.getTag(TKM_ADM_LVL2);
        if (iso == null) {
            iso = el.getTag(TKM_COUNTRY);
        }
        if (iso == null && log.isInfoEnabled()) {
            log.info(this.getName(), el.getBasicLogInformation(), "Neither mkgmap:admin_level2 nor mkgmap:country is set, assuming this element is not in a drive-on-left country");
        }
        return Boolean.toString(LocatorConfig.get().getDriveOnLeftFlag(iso));
    }

    @Override
    public String getName() {
        return "is_drive_on_left";
    }

    @Override
    public boolean supportsNode() {
        return true;
    }

    @Override
    public boolean supportsWay() {
        return true;
    }
}

