/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.srt;

import uk.me.parabola.imgfmt.ReadFailedException;
import uk.me.parabola.imgfmt.app.CommonHeader;
import uk.me.parabola.imgfmt.app.ImgFileReader;
import uk.me.parabola.imgfmt.app.ImgFileWriter;
import uk.me.parabola.imgfmt.app.Section;
import uk.me.parabola.imgfmt.app.SectionWriter;
import uk.me.parabola.imgfmt.app.srt.Sort;

public class SRTHeader
extends CommonHeader {
    public static final int HEADER_LEN = 29;
    protected static final int HEADER2_LEN = 16;
    protected static final int HEADER3_LEN = 52;
    protected static final int HEADER3_MULTI_LEN = 92;
    private final Section header2 = new Section();
    private final Section desc = new Section(this.header2);
    private final Section subheader = new Section(this.desc);
    private final Section chartab = new Section(3);
    private final Section expansions = new Section(this.chartab, 2);
    private final Section srt8 = new Section(this.expansions, 5);
    private final Section srt7 = new Section(this.srt8, 4);
    private Sort sort;

    public SRTHeader() {
        this(29);
    }

    public SRTHeader(int headerLen) {
        super(headerLen, "GARMIN SRT");
        this.header2.setPosition(headerLen);
        this.header2.setSize(16);
        this.chartab.setPosition(52);
    }

    @Override
    protected void readFileHeader(ImgFileReader reader) throws ReadFailedException {
        reader.get2u();
        this.header2.setPosition(reader.get4());
        this.header2.setSize(reader.get2u());
    }

    @Override
    protected void writeFileHeader(ImgFileWriter writer) {
        if (this.getHeaderLength() <= 29) {
            writer.put2u(1);
            writer.put4(this.header2.getPosition());
            writer.put2u(this.header2.getSize());
        } else {
            writer.put2u(0);
            writer.put4(this.header2.getPosition());
            writer.put2u(this.header2.getSize());
            writer.put2u(1);
            writer.put4(this.header2.getPosition());
            writer.put2u(this.header2.getSize());
        }
    }

    SectionWriter makeSectionWriter(ImgFileWriter writer) {
        return new SectionWriter(writer, this.subheader);
    }

    protected void writeHeader2(ImgFileWriter writer) {
        this.desc.writeSectionInfo(writer);
        this.subheader.writeSectionInfo(writer);
    }

    protected void writeHeader3(ImgFileWriter writer) {
        if (this.sort.isMulti()) {
            writer.put2u(92);
        } else {
            writer.put2u(52);
        }
        writer.put2u(this.sort.getId1());
        writer.put2u(this.sort.getId2());
        writer.put2u(this.sort.getCodepage());
        if (this.sort.isMulti()) {
            writer.put4(28418);
        } else {
            writer.put4(8194);
        }
        this.chartab.writeSectionInfo(writer, true, true);
        writer.put2u(0);
        this.expansions.writeSectionInfo(writer, true, true);
        writer.put2u(0);
        writer.put4(this.chartab.getPosition());
        writer.put4(0);
        if (this.sort.isMulti()) {
            writer.put4(1);
            writer.put4(this.sort.getMaxPage());
            this.srt7.writeSectionInfo(writer, true);
            writer.put2u(0);
            writer.put4(0);
            this.srt8.writeSectionInfo(writer, true);
            writer.put2u(0);
            writer.put4(0);
        }
    }

    public void setSort(Sort sort) {
        this.sort = sort;
        if (sort.isMulti()) {
            this.chartab.setPosition(92);
            this.chartab.setItemSize(5);
            this.expansions.setItemSize(4);
        }
    }

    public void endDescription(int position) {
        this.desc.setSize(position - this.desc.getPosition());
        this.subheader.setPosition(position);
    }

    public void endCharTable(int position) {
        this.chartab.setSize(position - this.chartab.getPosition());
    }

    public void endTab2(int postition) {
        this.subheader.setSize(postition - this.subheader.getPosition());
        this.expansions.setSize(postition - this.expansions.getPosition());
    }

    public void endSrt8(int position) {
        this.srt8.setSize(position - this.srt8.getPosition());
    }

    public void endSrt7(int position) {
        this.srt7.setSize(position - this.srt7.getPosition());
    }
}

