/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.net;

import uk.me.parabola.imgfmt.app.ImgFileWriter;
import uk.me.parabola.imgfmt.app.net.NODHeader;
import uk.me.parabola.imgfmt.app.net.RoadDef;
import uk.me.parabola.imgfmt.app.net.RouteNode;
import uk.me.parabola.log.Logger;

public class RouteArc {
    private static final Logger log = Logger.getLogger(RouteArc.class);
    private static final int FLAG_HASNET = 128;
    private static final int FLAG_FORWARD = 64;
    private static final int MASK_DESTCLASS = 7;
    public static final int MASK_CURVE_LEN = 56;
    private static final int FLAG_LAST_LINK = 128;
    private static final int FLAG_EXTERNAL = 64;
    private int offset;
    private float initialHeading;
    private final float directHeading;
    private final RoadDef roadDef;
    private final RouteNode source;
    private final RouteNode dest;
    private int indexA;
    private int indexB;
    private int flagA;
    private int flagB;
    private final boolean haveCurve;
    private final int length;
    private final byte lengthRatio;
    private final int pointsHash;
    private boolean isForward;
    private final float lengthInMeter;
    private boolean isDirect = true;
    private byte maxDestClass = (byte)-1;
    private RouteArc reverseArc;

    public RouteArc(RoadDef roadDef, RouteNode source, RouteNode dest, double initialBearing, double directBearing, double arcLength, double pathLength, double directLength, int pointsHash) {
        int directEncoded;
        this.roadDef = roadDef;
        this.source = source;
        this.dest = dest;
        this.initialHeading = initialBearing >= 180.0 ? (float)(initialBearing - 360.0) : (float)initialBearing;
        this.directHeading = directBearing >= 180.0 ? (float)(directBearing - 360.0) : (float)directBearing;
        int len = NODHeader.metersToRaw(arcLength);
        if (len >= 0x400000) {
            log.error("Way " + roadDef.getName() + " (id " + roadDef.getId() + ") contains an arc whose length (" + len + " units) is too big to be encoded, using length", 0x3FFFFF);
            len = 0x3FFFFF;
        }
        this.length = len;
        this.lengthInMeter = (float)arcLength;
        this.pointsHash = pointsHash;
        int ratio = 0;
        int pathEncoded = NODHeader.metersToRaw(pathLength);
        if (pathEncoded >= 2 && pathEncoded > (directEncoded = NODHeader.metersToRaw(directLength))) {
            ratio = (int)Math.min(31L, Math.round(32.0 * directLength / pathLength));
        }
        if (ratio == 0 && len >= 16384) {
            ratio = 31;
        }
        this.lengthRatio = (byte)ratio;
        this.haveCurve = this.lengthRatio > 0;
    }

    public float getInitialHeading() {
        return this.initialHeading;
    }

    public float getDirectHeading() {
        return this.directHeading;
    }

    public void setInitialHeading(float ih) {
        this.initialHeading = ih;
    }

    public void modInitialHeading(float adjust) {
        this.initialHeading += adjust;
        if (this.initialHeading >= 180.0f) {
            this.initialHeading -= 360.0f;
        } else if (this.initialHeading < -180.0f) {
            this.initialHeading += 360.0f;
        }
    }

    public float getFinalHeading() {
        float fh = 0.0f;
        if (this.lengthInMeter != 0.0f && (fh = this.getReverseArc().getInitialHeading() + 180.0f) >= 180.0f) {
            fh -= 360.0f;
        }
        return fh;
    }

    public RouteNode getSource() {
        return this.source;
    }

    public RouteNode getDest() {
        return this.dest;
    }

    public int getLength() {
        return this.length;
    }

    public int getPointsHash() {
        return this.pointsHash;
    }

    public int boundSize() {
        int[] lendat = this.encodeLength();
        int size = 5 + lendat.length;
        if (this.haveCurve) {
            size += this.encodeCurve().length;
        }
        return size;
    }

    public boolean isInternal() {
        return (this.flagB & 0x40) == 0;
    }

    public void setInternal(boolean internal) {
        this.flagB = internal ? (this.flagB &= 0xFFFFFFBF) : (this.flagB |= 0x40);
    }

    public void setIndexA(int indexA) {
        this.indexA = indexA;
    }

    public int getIndexA() {
        return this.indexA;
    }

    public void setIndexB(int indexB) {
        assert (!this.isInternal()) : "Trying to set index on internal arc.";
        this.indexB = indexB;
    }

    public int getIndexB() {
        return this.indexB;
    }

    public int getArcDestClass() {
        return Math.min(this.getRoadDef().getRoadClass(), this.dest.getGroup());
    }

    public float getLengthInMeter() {
        return this.lengthInMeter;
    }

    public static byte directionFromDegrees(float dir) {
        return (byte)Math.round(dir * 256.0f / 360.0f);
    }

    public static int compactDirFromDegrees(float dir) {
        return RouteArc.directionFromDegrees(dir) + 8 >> 4 & 0xF;
    }

    public void write(ImgFileWriter writer, RouteArc lastArc, boolean useCompactDirs, Byte compactedDir) {
        boolean first;
        boolean bl = first = lastArc == null;
        if (first) {
            if (useCompactDirs) {
                this.flagA |= 0x80;
            }
        } else if (lastArc.getRoadDef() != this.getRoadDef()) {
            this.flagA |= 0x80;
        }
        if (this.isForward) {
            this.flagA |= 0x40;
        }
        this.offset = writer.position();
        if (log.isDebugEnabled()) {
            log.debug("writing arc at", this.offset, ", flagA=", Integer.toHexString(this.flagA));
        }
        this.setDestinationClass(this.getArcDestClass());
        int[] lendat = this.encodeLength();
        writer.put1u(this.flagA);
        if (this.isInternal()) {
            writer.put1u(this.flagB);
            writer.put1u(0);
        } else if (this.indexB < 0 || this.indexB >= 63) {
            writer.put1u(this.flagB | 0x3F);
            writer.put1u(this.indexB);
        } else {
            writer.put1u(this.flagB | this.indexB);
        }
        if (first || lastArc.indexA != this.indexA) {
            writer.put1u(this.indexA);
        }
        if (log.isDebugEnabled()) {
            log.debug("writing length", this.length);
        }
        for (int aLendat : lendat) {
            writer.put((byte)aLendat);
        }
        if (first || lastArc.indexA != this.indexA || lastArc.isForward != this.isForward) {
            if (useCompactDirs) {
                if (compactedDir != null) {
                    writer.put(compactedDir);
                }
            } else {
                writer.put(RouteArc.directionFromDegrees(this.initialHeading));
            }
        }
        if (this.haveCurve) {
            int[] curvedat;
            for (int aCurvedat : curvedat = this.encodeCurve()) {
                writer.put((byte)aCurvedat);
            }
        }
    }

    public void writeSecond(ImgFileWriter writer) {
        if (!this.isInternal()) {
            return;
        }
        writer.position((long)this.offset + 1L);
        int val = this.flagB << 8;
        int diff = this.dest.getOffsetNod1() - this.source.getOffsetNod1();
        assert (diff < 8192 && diff >= -8192) : "relative pointer too large for 14 bits (source offset = " + this.source.getOffsetNod1() + ", dest offset = " + this.dest.getOffsetNod1() + ")";
        val |= diff & 0x3FFF;
        if (log.isDebugEnabled()) {
            log.debug("val is", Integer.toHexString(val));
        }
        writer.put1u(val >> 8);
        writer.put1u(val & 0xFF);
    }

    private int[] encodeLength() {
        int[] lendat;
        if (this.length < 768 || this.length < 1024 && !this.haveCurve) {
            this.flagA &= 0xFFFFFFC7;
            if (this.haveCurve) {
                this.flagA |= 0x20;
            }
            this.flagA |= this.length >> 5 & 0x18;
            lendat = new int[]{this.length};
            assert ((this.flagA & 0x38) != 56);
        } else {
            this.flagA |= 0x38;
            lendat = this.length >= 16384 ? new int[]{0xC0 | this.length & 0x3F, this.length >> 6 & 0xFF, this.length >> 14 & 0xFF} : (this.haveCurve ? new int[]{this.length & 0x7F, this.length >> 7 & 0xFF} : new int[]{0x80 | this.length & 0x3F, this.length >> 6 & 0xFF});
        }
        return lendat;
    }

    private int[] encodeCurve() {
        int[] curveData;
        assert (this.lengthRatio != 0);
        byte dh = RouteArc.directionFromDegrees(this.directHeading);
        if (this.lengthRatio >= 1 && this.lengthRatio <= 17) {
            curveData = new int[]{this.lengthRatio, dh};
        } else {
            int compactedRatio = this.lengthRatio / 2 - 8;
            assert (compactedRatio > 0 && compactedRatio < 8);
            curveData = new int[]{compactedRatio << 5 | dh >> 3 & 0x1F};
        }
        return curveData;
    }

    public RoadDef getRoadDef() {
        return this.roadDef;
    }

    public void setForward() {
        this.isForward = true;
    }

    public boolean isForward() {
        return this.isForward;
    }

    public void setLast() {
        this.flagB |= 0x80;
    }

    protected void setDestinationClass(int destinationClass) {
        if (log.isDebugEnabled()) {
            log.debug("setting destination class", destinationClass);
        }
        this.flagA |= destinationClass & 7;
    }

    public void setIndirect() {
        this.isDirect = false;
    }

    public boolean isDirect() {
        return this.isDirect;
    }

    public void setMaxDestClass(int destClass) {
        if (this.maxDestClass < 0) {
            this.maxDestClass = (byte)destClass;
        } else if (destClass < this.maxDestClass) {
            this.maxDestClass = (byte)destClass;
        }
    }

    public String toString() {
        return "RouteArc [" + (this.isForward ? "->" : "<-") + (this.isDirect ? "direct" : "indirect") + this.roadDef + " " + this.dest + "]";
    }

    public RouteArc getReverseArc() {
        return this.reverseArc;
    }

    public void setReverseArc(RouteArc reverseArc) {
        this.reverseArc = reverseArc;
    }
}

