/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.net;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import uk.me.parabola.imgfmt.app.Coord;
import uk.me.parabola.imgfmt.app.net.RoadDef;
import uk.me.parabola.imgfmt.app.net.RouteArc;
import uk.me.parabola.imgfmt.app.net.RouteNode;
import uk.me.parabola.log.Logger;
import uk.me.parabola.util.EnhancedProperties;

public class RoundaboutCheck {
    private final Logger log = Logger.getLogger(RoundaboutCheck.class);
    private boolean checkRoundaboutLoops = false;
    private boolean checkRoundaboutDirections = false;
    private boolean checkRoundaboutOverlaps = false;
    private boolean checkRoundaboutJunctions = false;
    private boolean checkRoundaboutFlares = false;
    private boolean checkRoundabouts = false;
    private int maxFlareLength = 200;
    private int maxFlareLengthMultiple = 3;
    private int flareSeparationOverride = 5;
    private int maxFlareToSeparationMultiple = 7;
    private int maxFlareAngle = 90;
    private int maxFlareBearing = 90;
    private int maxEntryAngle = 145;
    private boolean discardBothFlaresExtend = true;
    private boolean discardMultipleFlares = true;
    private boolean discardDifferentFlareNames = true;
    private boolean discardDifferentAccesses = true;
    private RouteNode nodeToCheck;
    private Coord coord;
    private List<RouteNode> roundaboutNodes = new ArrayList<RouteNode>();

    private static void printOptionHelpMsg(String option) {
        if (!"help".equals(option)) {
            System.err.println("Unknown report-roundabout-issues option '" + option + "'");
        }
        System.err.println("Report roundabout issues options are:");
        System.err.println("  all         apply all the checks");
        System.err.println("  loop        check that each roundabouts is formed from a single loop with no");
        System.err.println("              forks or gaps");
        System.err.println("  direction   check the direction of travel around the roundabout");
        System.err.println("  overlaps    check that highways do not overlap the roundabout");
        System.err.println("  junctions   check that no more than one connecting highway joins at each node");
        System.err.println("  flares      check that roundabout flare roads are one-way, are in the right");
        System.err.println("              direction, and don't extend beyond the flare");
    }

    public void config(EnhancedProperties props) {
        String checkRoundaboutsOption;
        String mflr;
        if (props.getProperty("check-roundabouts", false)) {
            this.checkRoundaboutDirections = this.checkRoundaboutLoops = RouteNode.isWarningLogged();
            this.checkRoundaboutJunctions = this.checkRoundaboutLoops;
            this.log.error((Object)"The check-roundabouts option is deprecated - use report-roundabout-issues.");
        }
        if (props.getProperty("check-roundabout-flares", false)) {
            this.checkRoundaboutFlares = RouteNode.isWarningLogged();
            this.log.error((Object)"The check-roundabout-flares option is deprecated - use report-roundabout-issues.");
        }
        if ((mflr = props.getProperty("max-flare-length-ratio")) != null) {
            this.maxFlareToSeparationMultiple = props.getProperty("max-flare-length-ratio", this.maxFlareToSeparationMultiple);
            this.log.error((Object)"The max-flare-length-ratio option is deprecated - use roundabout-flare-rules-config.");
        }
        if ((checkRoundaboutsOption = props.getProperty("report-roundabout-issues")) != null) {
            if ("".equals(checkRoundaboutsOption)) {
                this.checkRoundaboutLoops = true;
                this.checkRoundaboutDirections = true;
                this.checkRoundaboutOverlaps = true;
                this.checkRoundaboutJunctions = true;
                this.checkRoundaboutFlares = true;
            }
            for (String option : checkRoundaboutsOption.split(",")) {
                if ("all".equals(option)) {
                    this.checkRoundaboutLoops = true;
                    this.checkRoundaboutDirections = true;
                    this.checkRoundaboutOverlaps = true;
                    this.checkRoundaboutJunctions = true;
                    this.checkRoundaboutFlares = true;
                    continue;
                }
                if ("loop".equals(option)) {
                    this.checkRoundaboutLoops = true;
                    continue;
                }
                if ("direction".equals(option)) {
                    this.checkRoundaboutDirections = true;
                    continue;
                }
                if ("overlaps".equals(option)) {
                    this.checkRoundaboutOverlaps = true;
                    continue;
                }
                if ("junctions".equals(option)) {
                    this.checkRoundaboutJunctions = true;
                    continue;
                }
                if ("flares".equals(option)) {
                    this.checkRoundaboutFlares = true;
                    continue;
                }
                if (option.isEmpty()) continue;
                RoundaboutCheck.printOptionHelpMsg(option);
            }
        }
        this.checkRoundabouts = this.checkRoundaboutLoops || this.checkRoundaboutOverlaps || this.checkRoundaboutJunctions || this.checkRoundaboutFlares;
        String configFilename = props.getProperty("roundabout-flare-rules-config", "");
        if (!configFilename.isEmpty()) {
            File file = new File(configFilename);
            try {
                List<String> rules = Files.readAllLines(file.toPath());
                for (int i = 0; i < rules.size(); ++i) {
                    String rule = rules.get(i);
                    int hashPos = rule.indexOf(35);
                    if (hashPos >= 0) {
                        rule = rule.substring(0, hashPos);
                    }
                    if ((rule = rule.replaceAll("\\s+", "")).isEmpty()) continue;
                    String[] ruleParts = rule.split(":");
                    if (ruleParts.length == 2) {
                        try {
                            switch (ruleParts[0]) {
                                case "max-flare-length": {
                                    this.maxFlareLength = Integer.decode(ruleParts[1]);
                                    break;
                                }
                                case "max-flare-length-multiple": {
                                    this.maxFlareLengthMultiple = Integer.decode(ruleParts[1]);
                                    break;
                                }
                                case "flare-separation-override": {
                                    this.flareSeparationOverride = Integer.decode(ruleParts[1]);
                                    break;
                                }
                                case "max-flare-to-separation-multiple": {
                                    this.maxFlareToSeparationMultiple = Integer.decode(ruleParts[1]);
                                    break;
                                }
                                case "max-flare-angle": {
                                    this.maxFlareAngle = Integer.decode(ruleParts[1]);
                                    break;
                                }
                                case "max-flare-bearing": {
                                    this.maxFlareBearing = Integer.decode(ruleParts[1]);
                                    break;
                                }
                                case "max-entry-angle": {
                                    this.maxEntryAngle = Integer.decode(ruleParts[1]);
                                    break;
                                }
                                case "discard-both-flares-extend": {
                                    this.discardBothFlaresExtend = Boolean.getBoolean(ruleParts[1]);
                                    break;
                                }
                                case "discard-multiple-flares": {
                                    this.discardMultipleFlares = Boolean.getBoolean(ruleParts[1]);
                                    break;
                                }
                                case "discard-different-flare-names": {
                                    this.discardDifferentFlareNames = Boolean.getBoolean(ruleParts[1]);
                                    break;
                                }
                                case "discard-different-accesses": {
                                    this.discardDifferentAccesses = Boolean.getBoolean(ruleParts[1]);
                                    break;
                                }
                                default: {
                                    this.log.error("Unrecognised roundabout flare rule", ruleParts[0], "in", configFilename);
                                    break;
                                }
                            }
                        }
                        catch (Exception ex) {
                            this.log.error("Invalid value", ruleParts[1], "for roundabout flare rule", ruleParts[0], "in", configFilename);
                        }
                        continue;
                    }
                    this.log.error("Invalid roundabout flare rule", rule, "in", configFilename);
                }
            }
            catch (IOException ex) {
                this.log.error("Error reading roundabout flare rules file", configFilename);
            }
        }
    }

    public void check(RouteNode routeNode) {
        if (this.checkRoundabouts) {
            this.nodeToCheck = routeNode;
            this.coord = this.nodeToCheck.getCoord();
            this.roundaboutNodes.clear();
            ArrayList<RouteArc> roundaboutArcs = new ArrayList<RouteArc>();
            ArrayList<RouteArc> nonRoundaboutArcs = new ArrayList<RouteArc>();
            for (RouteArc routeArc : this.nodeToCheck.getArcs()) {
                RoadDef rd;
                if (!routeArc.isDirect() || (rd = routeArc.getRoadDef()).isSynthesised()) continue;
                if (rd.isRoundabout()) {
                    roundaboutArcs.add(routeArc);
                    continue;
                }
                nonRoundaboutArcs.add(routeArc);
            }
            if (!roundaboutArcs.isEmpty()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Roundabout node", this.coord.toOSMURL());
                }
                this.roundaboutNodes.add(this.nodeToCheck);
                boolean roundaboutComplete = true;
                block1: for (RouteArc ra : roundaboutArcs) {
                    if (!ra.isForward()) continue;
                    for (RouteArc ra1 : nonRoundaboutArcs) {
                        if (ra1.getDirectHeading() != ra.getDirectHeading() || ra1.getInitialHeading() != ra.getInitialHeading() || ra1.getFinalHeading() != ra.getFinalHeading() || ra1.getLengthInMeter() != ra.getLengthInMeter()) continue;
                        nonRoundaboutArcs.remove(ra1);
                        if (!this.checkRoundaboutOverlaps || ra.getRoadDef().messagePreviouslyIssued("overlaps roundabout")) break;
                        this.log.diagnostic("Highway " + ra1.getRoadDef() + " overlaps roundabout " + ra.getRoadDef() + " at " + this.coord.toOSMURL());
                        break;
                    }
                    RouteNode rn = ra.getDest();
                    while (!this.roundaboutNodes.contains(rn)) {
                        this.roundaboutNodes.add(rn);
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Roundabout node", rn.getCoord().toOSMURL());
                        }
                        RouteNode nrn = null;
                        for (RouteArc nra : rn.getArcs()) {
                            RoadDef nrd;
                            if (!nra.isDirect() || !nra.isForward() || !(nrd = nra.getRoadDef()).isRoundabout() || nrd.isSynthesised()) continue;
                            nrn = nra.getDest();
                        }
                        rn = nrn;
                        if (rn != null) continue;
                        roundaboutComplete = false;
                        this.log.info("Incomplete roundabout", this.coord.toOSMURL());
                        continue block1;
                    }
                }
                Coord coord = this.getRoundaboutCentre();
                if (nonRoundaboutArcs.size() > 1) {
                    int countNonRoundaboutRoads = 0;
                    int countNonRoundaboutOtherHighways = 0;
                    int countHighwaysInsideRoundabout = 0;
                    for (RouteArc ra : nonRoundaboutArcs) {
                        RoadDef rd = ra.getRoadDef();
                        byte access = rd.getAccess();
                        if (access != 0 && access != 1) {
                            if (roundaboutComplete && this.goesInsideRoundabout(ra, this.nodeToCheck, coord)) {
                                ++countHighwaysInsideRoundabout;
                                for (RouteArc ra2 : nonRoundaboutArcs) {
                                    ra2.getRoadDef().doFlareCheck(false);
                                }
                                continue;
                            }
                            if ((access & 4) != 0) {
                                ++countNonRoundaboutRoads;
                                continue;
                            }
                            if ((access & 0x72) == 0) continue;
                            ++countNonRoundaboutOtherHighways;
                            continue;
                        }
                        rd.doFlareCheck(false);
                    }
                    RouteArc roundaboutArc = (RouteArc)roundaboutArcs.get(0);
                    if (this.checkRoundaboutLoops) {
                        if (this.nodeToCheck.getArcs().size() > 1 && roundaboutArcs.size() == 1) {
                            this.log.diagnostic("Roundabout " + roundaboutArc.getRoadDef() + (roundaboutArc.isForward() ? " starts at " : " ends at ") + this.coord.toOSMURL());
                        }
                        if (roundaboutArcs.size() > 2) {
                            for (RouteArc fa : roundaboutArcs) {
                                if (!fa.isForward()) continue;
                                RoadDef rd = fa.getRoadDef();
                                for (RouteArc fb : roundaboutArcs) {
                                    if (fb == fa) continue;
                                    if (fa.getPointsHash() == fb.getPointsHash() && (fb.isForward() && fb.getDest() == fa.getDest() || !fb.isForward() && fb.getSource() == fa.getDest())) {
                                        if (rd.messagePreviouslyIssued("roundabout forks/overlaps")) continue;
                                        this.log.diagnostic("Roundabout " + rd + " overlaps " + fb.getRoadDef() + " at " + this.coord.toOSMURL());
                                        continue;
                                    }
                                    if (!fb.isForward() || rd.messagePreviouslyIssued("roundabout forks/overlaps")) continue;
                                    this.log.diagnostic("Roundabout " + rd + " forks at " + this.coord.toOSMURL());
                                }
                            }
                        }
                    }
                    if (this.checkRoundaboutJunctions) {
                        if (countNonRoundaboutRoads > 1) {
                            if (!this.nodeToCheck.getRestrictions().isEmpty()) {
                                this.log.diagnostic("Roundabout " + roundaboutArc.getRoadDef() + " with restriction is connected to more than one road at " + this.coord.toOSMURL());
                            } else {
                                this.log.diagnostic("Roundabout " + roundaboutArc.getRoadDef() + " is connected to more than one road at " + this.coord.toOSMURL());
                            }
                        } else if (countNonRoundaboutRoads == 1) {
                            if (countNonRoundaboutOtherHighways > 0) {
                                if (countHighwaysInsideRoundabout > 0) {
                                    this.log.diagnostic("Roundabout " + roundaboutArc.getRoadDef() + " is connected to a road, " + countNonRoundaboutOtherHighways + " other highway(s) and " + countHighwaysInsideRoundabout + " highways inside the roundabout at " + this.coord.toOSMURL());
                                } else {
                                    this.log.diagnostic("Roundabout " + roundaboutArc.getRoadDef() + " is connected to a road and " + countNonRoundaboutOtherHighways + " other highway(s) at " + this.coord.toOSMURL());
                                }
                            } else if (countHighwaysInsideRoundabout > 0) {
                                this.log.diagnostic("Roundabout " + roundaboutArc.getRoadDef() + " is connected to a road and " + countHighwaysInsideRoundabout + " highway(s) inside the roundabout at " + this.coord.toOSMURL());
                            }
                        } else if (countNonRoundaboutOtherHighways > 0) {
                            if (countHighwaysInsideRoundabout > 0) {
                                this.log.diagnostic("Roundabout " + roundaboutArc.getRoadDef() + " is connected to " + countNonRoundaboutOtherHighways + " highway(s) and " + countHighwaysInsideRoundabout + " inside the roundabout at " + this.coord.toOSMURL());
                            } else if (countNonRoundaboutOtherHighways > 1) {
                                this.log.diagnostic("Roundabout " + roundaboutArc.getRoadDef() + " is connected to " + countNonRoundaboutOtherHighways + " highways at " + this.coord.toOSMURL());
                            }
                        } else if (countHighwaysInsideRoundabout > 1) {
                            this.log.diagnostic("Roundabout " + roundaboutArc.getRoadDef() + " is connected to " + countHighwaysInsideRoundabout + " highways inside the roundabout at " + this.coord.toOSMURL());
                        }
                    }
                }
                if (roundaboutComplete && this.checkRoundaboutFlares) {
                    this.checkRoundaboutFlares(coord);
                }
            }
        }
    }

    public void checkRoundaboutFlares(Coord centre) {
        for (RouteArc r : this.nodeToCheck.getArcs()) {
            if (!r.isForward() || !r.isDirect() || !r.getRoadDef().isRoundabout() || r.getRoadDef().isSynthesised()) continue;
            RouteNode nextExitNode = null;
            RouteNode nextButOneExitNode = null;
            RouteNode precedingExitNode = null;
            for (RouteNode rn : this.roundaboutNodes) {
                if (rn == this.nodeToCheck) continue;
                for (RouteArc ra : rn.getArcs()) {
                    RoadDef rd;
                    if (!ra.isDirect() || (rd = ra.getRoadDef()).isSynthesised() || rd.isRoundabout()) continue;
                    byte access = rd.getAccess();
                    if (access != 0 && access != 1) {
                        if (this.goesInsideRoundabout(ra, rn, centre)) {
                            for (RouteArc ra2 : rn.getArcs()) {
                                ra2.getRoadDef().doFlareCheck(false);
                            }
                        }
                        if (nextExitNode == null) {
                            nextExitNode = rn;
                            continue;
                        }
                        if (nextButOneExitNode == null) {
                            nextButOneExitNode = rn;
                        }
                        precedingExitNode = rn;
                        continue;
                    }
                    rd.doFlareCheck(false);
                }
            }
            if (nextExitNode == null) continue;
            for (RouteArc fa : this.nodeToCheck.getArcs()) {
                RoadDef rda;
                if (!fa.isDirect() || (rda = fa.getRoadDef()).isSynthesised() || !rda.doFlareCheck()) continue;
                for (RouteArc fb : nextExitNode.getArcs()) {
                    float fbLength;
                    float faLength;
                    RoadDef rdb;
                    if (!fb.isDirect() || fa == fb || (rdb = fb.getRoadDef()).isSynthesised() || !rdb.doFlareCheck() || fa.getDest() != fb.getDest() || RoundaboutCheck.roundaboutSegmentLength(this.nodeToCheck, nextExitNode) >= RoundaboutCheck.roundaboutSegmentLength(nextExitNode, this.nodeToCheck)) continue;
                    boolean hasRoad = false;
                    for (RouteArc ra2 : fa.getDest().getArcs()) {
                        RoadDef rd2;
                        byte access;
                        if (!ra2.isDirect() || ra2 == fa || ra2 == fb || (access = (rd2 = ra2.getRoadDef()).getAccess()) == 0 || access == 1) continue;
                        hasRoad = true;
                        break;
                    }
                    if (!hasRoad) {
                        this.log.info("Discarding possible roundabout flare", rda, "with", rdb, "no ongoing road");
                        continue;
                    }
                    if (this.maxFlareLength > 0) {
                        float faLength2 = fa.getLengthInMeter();
                        float fbLength2 = fb.getLengthInMeter();
                        if (faLength2 > (float)this.maxFlareLength || fbLength2 > (float)this.maxFlareLength) {
                            this.log.info("Discarding possible roundabout flare", rda, "with", rdb, "where the flares are", Float.valueOf(faLength2), "and", Float.valueOf(fbLength2), "m");
                            continue;
                        }
                    }
                    if (this.maxFlareLengthMultiple > 0 && ((faLength = fa.getLengthInMeter()) > (float)this.maxFlareLengthMultiple * (fbLength = fb.getLengthInMeter()) || fbLength > (float)this.maxFlareLengthMultiple * faLength)) {
                        this.log.info("Discarding possible roundabout flare", rda, "with", rdb, "where one flare is", String.format("%.1f", Float.valueOf(Math.max(faLength, fbLength) / Math.min(faLength, fbLength))), "times longer than the other");
                        continue;
                    }
                    if (this.maxFlareBearing > 0) {
                        double flareAngle = (double)fa.getReverseArc().getInitialHeading() - fa.getDest().getCoord().bearingTo(centre);
                        if (flareAngle < -180.0) {
                            flareAngle += 360.0;
                        }
                        if (flareAngle > 180.0) {
                            flareAngle -= 360.0;
                        }
                        if (Math.abs(flareAngle) > (double)this.maxFlareBearing) {
                            this.log.info("Discarding possible roundabout flare", rda, "with", rdb, "where angle to centre is", String.format("%.1f", flareAngle));
                            continue;
                        }
                        flareAngle = (double)fb.getReverseArc().getInitialHeading() - fb.getDest().getCoord().bearingTo(centre);
                        if (flareAngle < -180.0) {
                            flareAngle += 360.0;
                        }
                        if (flareAngle > 180.0) {
                            flareAngle -= 360.0;
                        }
                        if (Math.abs(flareAngle) > (double)this.maxFlareBearing) {
                            this.log.info("Discarding possible roundabout flare", rda, "with", rdb, "where angle to centre is", String.format("%.1f", flareAngle));
                            continue;
                        }
                    }
                    if (this.maxFlareAngle > 0) {
                        double flareAngle = fa.getReverseArc().getInitialHeading() - fb.getReverseArc().getInitialHeading();
                        if (flareAngle < -180.0) {
                            flareAngle += 360.0;
                        }
                        if (flareAngle > 180.0) {
                            flareAngle -= 360.0;
                        }
                        if (Math.abs(flareAngle) > (double)this.maxFlareAngle) {
                            this.log.info("Discarding possible roundabout flare", rda, "with", rdb, "where subtended angle is", String.format("%.1f", flareAngle));
                            continue;
                        }
                    }
                    boolean faExtended = false;
                    boolean fbExtended = false;
                    boolean thirdArcToRoundabout = false;
                    block7: for (RouteArc ra2 : fa.getDest().getArcs()) {
                        byte access;
                        if (!ra2.isDirect() || ra2.getDest() == this.nodeToCheck || ra2.getSource() == this.nodeToCheck || ra2.getDest() == nextExitNode || ra2.getSource() == nextExitNode) continue;
                        RoadDef rd2 = ra2.getRoadDef();
                        if (rd2 == rda) {
                            faExtended = true;
                        }
                        if (rd2 == rdb) {
                            fbExtended = true;
                        }
                        if (thirdArcToRoundabout || (access = rd2.getAccess()) == 0 || access == 1) continue;
                        for (RouteNode rn : this.roundaboutNodes) {
                            if (rn != ra2.getSource() && rn != ra2.getDest()) continue;
                            thirdArcToRoundabout = true;
                            continue block7;
                        }
                    }
                    if (faExtended && fbExtended && this.discardBothFlaresExtend) {
                        this.log.info("Discarding possible roundabout flare", rda, "with", rdb, "where flares both extend at", fa.getDest().getCoord().toOSMURL());
                        continue;
                    }
                    if (this.discardMultipleFlares && thirdArcToRoundabout) {
                        this.log.info("Discarding possible roundabout flare", rda, "with", rdb, "where more than two roads join roundabout from", fa.getDest().getCoord().toOSMURL());
                        continue;
                    }
                    String namea = rda.getName();
                    String nameb = rdb.getName();
                    if (this.discardDifferentFlareNames && namea != null && nameb != null && !namea.equals(nameb) && !namea.contains(nameb) && !nameb.contains(namea)) {
                        this.log.info("Discarding possible roundabout flare", rda, "with", rdb, "where flares have different names", namea, "and", nameb);
                        continue;
                    }
                    byte accessa = rda.getAccess();
                    byte accessb = rdb.getAccess();
                    if (this.discardDifferentAccesses && accessa != accessb) {
                        this.log.info("Discarding possible roundabout flare", rda, "with", rdb, "where flares have different accesses");
                        continue;
                    }
                    if (centre != null && this.maxEntryAngle > 0) {
                        double bearingFrom = centre.bearingTo(this.coord);
                        double bearingTo = centre.bearingTo(nextExitNode.getCoord());
                        double angle = bearingTo - bearingFrom;
                        if (angle < 0.0) {
                            angle = -angle;
                        }
                        if (angle > 180.0) {
                            angle = 360.0 - angle;
                        }
                        if (angle > (double)this.maxEntryAngle) {
                            this.log.info("Discarding possible roundabout flare", rda, "with", rdb, this.coord.toOSMURL(), nextExitNode.getCoord().toOSMURL(), "where angle", angle, "from centre is too large");
                            continue;
                        }
                    }
                    if (this.maxFlareToSeparationMultiple > 0) {
                        int roundaboutSegmentLength = RoundaboutCheck.roundaboutSegmentLength(this.nodeToCheck, nextExitNode);
                        int maxLength = (this.flareSeparationOverride == 0 ? roundaboutSegmentLength : Math.max(this.flareSeparationOverride, roundaboutSegmentLength)) * this.maxFlareToSeparationMultiple;
                        if (maxLength > 0 && fa.getLength() > maxLength && fb.getLength() > maxLength) {
                            this.log.info("Discarding possible roundabout flare", rda, "with", rdb, "where roads are", fa.getLength(), "and", fb.getLength(), "m long with a separation of", roundaboutSegmentLength, "m");
                            continue;
                        }
                    }
                    boolean processed = false;
                    RoadDef extendedRoad = null;
                    for (RouteArc a : fa.getDest().getArcs()) {
                        byte access;
                        RoadDef rdc;
                        RoadDef ard;
                        if (!a.isDirect() || a.getDest() == this.nodeToCheck || a.getDest() == nextExitNode || (ard = a.getRoadDef()) != rda && ard != rdb) continue;
                        if (nextButOneExitNode != null) {
                            for (RouteArc fc : nextButOneExitNode.getArcs()) {
                                if (!fc.isDirect() || (rdc = fc.getRoadDef()).isSynthesised() || (access = rdc.getAccess()) == 0 || access == 1 || a.getDest() != fc.getDest()) continue;
                                processed = true;
                                this.log.info("Discarding possible roundabout flare", rda, "at", fa.getDest().getCoord().toOSMURL(), "multiple flares found");
                                break;
                            }
                        }
                        if (!processed && precedingExitNode != null) {
                            for (RouteArc fc : precedingExitNode.getArcs()) {
                                if (!fc.isDirect() || (rdc = fc.getRoadDef()).isSynthesised() || (access = rdc.getAccess()) == 0 || access == 1 || a.getDest() != fc.getDest()) continue;
                                processed = true;
                                this.log.info("Discarding possible roundabout flare", rda, "at", fa.getDest().getCoord().toOSMURL(), "multiple flares found");
                                break;
                            }
                        }
                        if (processed) break;
                        extendedRoad = ard;
                    }
                    if (processed) continue;
                    if (!rda.isOneway()) {
                        this.log.diagnostic("Outgoing roundabout flare road " + rda + " is not oneway " + fa.getSource().getCoord().toOSMURL());
                        continue;
                    }
                    if (!rdb.isOneway()) {
                        this.log.diagnostic("Incoming roundabout flare road " + rdb + " is not oneway " + fb.getDest().getCoord().toOSMURL());
                        continue;
                    }
                    if (!fa.isForward()) {
                        this.log.diagnostic("Outgoing roundabout flare road " + rda + " points in wrong direction " + fa.getSource().getCoord().toOSMURL());
                        continue;
                    }
                    if (fb.isForward()) {
                        this.log.diagnostic("Incoming roundabout flare road " + rdb + " points in wrong direction " + fb.getSource().getCoord().toOSMURL());
                        continue;
                    }
                    if (extendedRoad != null) {
                        if (extendedRoad == rda) {
                            this.log.diagnostic("Outgoing roundabout flare road " + rda + " does not finish at flare " + fa.getDest().getCoord().toOSMURL());
                            continue;
                        }
                        if (extendedRoad != rdb) continue;
                        this.log.diagnostic("Incoming roundabout flare road " + rdb + " does not start at flare " + fb.getDest().getCoord().toOSMURL());
                        continue;
                    }
                    if (namea != null && nameb != null && !namea.equals(nameb)) {
                        this.log.diagnostic("Roundabout flare roads " + rda + " and " + rdb + " have different names " + namea + " and " + nameb);
                        continue;
                    }
                    if (namea != null && nameb == null) {
                        this.log.diagnostic("Roundabout flare road " + rda + " has name " + namea + " but " + rdb + " is unnamed");
                        continue;
                    }
                    if (namea != null || nameb == null) continue;
                    this.log.diagnostic("Roundabout flare road " + rdb + " has name " + nameb + " but " + rda + " is unnamed");
                }
            }
        }
    }

    private static int roundaboutSegmentLength(RouteNode n1, RouteNode n2) {
        ArrayList<RouteNode> seen = new ArrayList<RouteNode>();
        int len = 0;
        RouteNode n = n1;
        boolean checkMoreLinks = true;
        block0: while (checkMoreLinks && !seen.contains(n)) {
            checkMoreLinks = false;
            seen.add(n);
            for (RouteArc a : n.getArcs()) {
                if (!a.isForward() || !a.getRoadDef().isRoundabout() || a.getRoadDef().isSynthesised()) continue;
                len += a.getLength();
                n = a.getDest();
                if (n == n2) {
                    return len;
                }
                checkMoreLinks = true;
                continue block0;
            }
        }
        return Integer.MAX_VALUE;
    }

    private boolean goesInsideRoundabout(RouteArc ra, RouteNode rn, Coord roundaboutCentre) {
        RouteNode nextNode = ra.getSource() == rn ? ra.getDest() : ra.getSource();
        Coord nextCoord = nextNode.getCoord();
        boolean rejoinsRoundabout = false;
        for (RouteNode roundaboutNode : this.roundaboutNodes) {
            if (roundaboutNode != nextNode) continue;
            rejoinsRoundabout = true;
            nextCoord = rn.getCoord().offset(ra.getSource() == rn ? (double)ra.getInitialHeading() : (double)ra.getReverseArc().getInitialHeading(), rn.getCoord().distance(nextCoord) / 2.0);
            break;
        }
        double distanceToCentre = roundaboutCentre.distance(rn.getCoord());
        double nextDistanceToCentre = roundaboutCentre.distance(nextCoord);
        RoadDef rd = ra.getRoadDef();
        if (Math.abs(nextDistanceToCentre - distanceToCentre) < 5.0) {
            if (rejoinsRoundabout) {
                Coord nextCoord2 = nextCoord.offset(rn.getCoord().bearingTo(nextCoord), nextCoord.distance(rn.getCoord()) / 2.0);
                double nextDistanceToCentre2 = roundaboutCentre.distance(nextCoord2);
                if (Math.abs(nextDistanceToCentre2 - distanceToCentre) > 2.0) {
                    return nextDistanceToCentre2 < distanceToCentre;
                }
            } else {
                for (RouteArc nra : nextNode.getArcs()) {
                    double nextDistanceToCentre2;
                    RouteNode nextNode2;
                    if (nra == ra || nra.getRoadDef() != rd) continue;
                    RouteNode routeNode = nextNode2 = nra.getSource() == nextNode ? nra.getDest() : nra.getSource();
                    if (nextNode2 == rn) continue;
                    Coord nextCoord2 = nextNode2.getCoord();
                    for (RouteNode roundaboutNode : this.roundaboutNodes) {
                        if (roundaboutNode != nextNode2) continue;
                        nextCoord2 = nextCoord.offset(nra.getSource() == nextNode ? (double)nra.getInitialHeading() : (double)nra.getReverseArc().getInitialHeading(), nextCoord.distance(nextCoord2) / 2.0);
                        break;
                    }
                    if (nextCoord.distance(nextCoord2) > distanceToCentre) {
                        nextCoord2 = nextCoord.offset(nextCoord.bearingTo(nextCoord2), distanceToCentre / 2.0);
                    }
                    if (!(Math.abs((nextDistanceToCentre2 = roundaboutCentre.distance(nextCoord2)) - distanceToCentre) > 2.0)) continue;
                    return nextDistanceToCentre2 < distanceToCentre;
                }
                Coord nextCoord3 = nextCoord.offset(rn.getCoord().bearingTo(nextCoord), distanceToCentre / 2.0);
                double nextDistanceToCentre3 = roundaboutCentre.distance(nextCoord3);
                if (Math.abs(nextDistanceToCentre3 - distanceToCentre) > 2.0) {
                    return nextDistanceToCentre3 < distanceToCentre;
                }
            }
        }
        if (Math.abs(nextDistanceToCentre - distanceToCentre) < 2.0 && !rd.messagePreviouslyIssued("inside roundabout")) {
            this.log.info("Way", rd, "unable to accurately determine whether", nextCoord.toOSMURL(), " is inside roundabout centred at", roundaboutCentre.toOSMURL());
        }
        return nextDistanceToCentre < distanceToCentre;
    }

    private Coord getRoundaboutCentre() {
        int numPoints = this.roundaboutNodes.size();
        double centreLat = 0.0;
        double centreLon = 0.0;
        for (RouteNode rn : this.roundaboutNodes) {
            centreLat += (double)rn.getCoord().getHighPrecLat();
            centreLon += (double)rn.getCoord().getHighPrecLon();
        }
        Coord roundaboutCentre = Coord.makeHighPrecCoord((int)Math.round(centreLat / (double)numPoints), (int)Math.round(centreLon / (double)numPoints));
        if (this.log.isDebugEnabled()) {
            this.log.debug("Roundabout centre of gravity", roundaboutCentre.toOSMURL());
        }
        if (this.roundaboutNodes.size() > 2) {
            CentreFinder cf = this.getDeltaDistanceFromCentre(roundaboutCentre);
            while (cf.delta > 1.0) {
                double bearing = roundaboutCentre.bearingTo(cf.furthestNodeFromCentre.getCoord());
                Coord betterCentre = roundaboutCentre.offset(bearing, cf.delta / 3.0);
                CentreFinder bettercf = this.getDeltaDistanceFromCentre(betterCentre);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Trying centre", betterCentre.toOSMURL());
                }
                if (bettercf.delta < cf.delta) {
                    cf = bettercf;
                    roundaboutCentre = betterCentre;
                    continue;
                }
                bearing = cf.nearestNodeToCentre.getCoord().bearingTo(roundaboutCentre);
                betterCentre = roundaboutCentre.offset(bearing, cf.delta / 3.0);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Trying centre", betterCentre.toOSMURL());
                }
                bettercf = this.getDeltaDistanceFromCentre(betterCentre);
                if (!(bettercf.delta < cf.delta)) break;
                cf = bettercf;
                roundaboutCentre = betterCentre;
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Roundabout centre", roundaboutCentre.toOSMURL());
        }
        return roundaboutCentre;
    }

    private CentreFinder getDeltaDistanceFromCentre(Coord centreCoord) {
        CentreFinder cf = new CentreFinder();
        double minDistanceToCentre = 9999999.0;
        double maxDistanceToCentre = 0.0;
        for (RouteNode rn : this.roundaboutNodes) {
            double distanceToCentre = centreCoord.distance(rn.getCoord());
            if (minDistanceToCentre > distanceToCentre) {
                minDistanceToCentre = distanceToCentre;
                cf.nearestNodeToCentre = rn;
            }
            if (!(maxDistanceToCentre < distanceToCentre)) continue;
            maxDistanceToCentre = distanceToCentre;
            cf.furthestNodeFromCentre = rn;
        }
        cf.delta = maxDistanceToCentre - minDistanceToCentre;
        return cf;
    }

    private class CentreFinder {
        double delta;
        RouteNode nearestNodeToCentre;
        RouteNode furthestNodeFromCentre;

        private CentreFinder() {
        }
    }
}

