/*
 * Decompiled with CFR 0.152.
 */
package uk.me.parabola.imgfmt.app.mdr;

import java.text.Collator;
import java.util.ArrayList;
import java.util.List;
import uk.me.parabola.imgfmt.app.mdr.Mdr2x;
import uk.me.parabola.imgfmt.app.mdr.Mdr5Record;
import uk.me.parabola.imgfmt.app.mdr.Mdr7Record;
import uk.me.parabola.imgfmt.app.mdr.MdrConfig;

public class Mdr20
extends Mdr2x {
    public Mdr20(MdrConfig config) {
        this.setConfig(config);
    }

    public void buildFromStreets(List<Mdr7Record> inStreets) {
        ArrayList<Mdr7Record> sorted = new ArrayList<Mdr7Record>(inStreets);
        sorted.sort((o1, o2) -> {
            int d = Integer.compare(o1.getCity().getMdr20SortPos(), o2.getCity().getMdr20SortPos());
            if (d != 0) {
                return d;
            }
            return Integer.compare(o1.getIndex(), o2.getIndex());
        });
        Collator collator = this.getConfig().getSort().getCollator();
        collator.setStrength(1);
        Mdr5Record lastCity = null;
        Mdr7Record lastStreet = null;
        int record = 0;
        int cityRecord = 1;
        for (Mdr7Record street : sorted) {
            Mdr5Record city = street.getCity();
            boolean citySameByName = lastCity != null && city.getMdr20SortPos() == lastCity.getMdr20SortPos();
            int rr = street.checkRepeat(lastStreet, collator);
            if (!citySameByName || rr != 3 || lastStreet.getIndex() != street.getIndex()) {
                ++record;
                this.streets.add(street);
            }
            if (citySameByName) {
                assert (cityRecord != 0);
                city.setMdr20(cityRecord);
            } else {
                assert (cityRecord != 0);
                cityRecord = record;
                city.setMdr20(cityRecord);
                lastCity = city;
            }
            lastStreet = street;
        }
    }

    @Override
    protected boolean sameGroup(Mdr7Record street1, Mdr7Record street2) {
        return street2 != null && street1.getCity().getMdr20() == street2.getCity().getMdr20();
    }

    @Override
    public int getExtraValue() {
        return this.isForDevice() ? 14 : 34816;
    }
}

