% WURZEL DOCUMENT CLASS -- Released September 2007 for LaTeX2e
% tf@wurzel.org
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
\def\wzlversion{2008}
\def\filedate{2010/12/10}
\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{wurzel\wzlversion}[\filedate]

%%% COMPLILER (LATEX/PDFLATEX) UND AUSGABEFORMAT (DVI/PDF) ERMITTELN
\newif\ifpdflatex\pdflatexfalse
\ifx\pdfoutput\undefined\else\ifx\pdfoutput\relax\else\pdflatextrue\fi\fi
\newif\ifpdfoutput\pdfoutputfalse
\ifpdflatex\ifcase\pdfoutput\else\pdfoutputtrue\fi\fi

%%% VARIABLEN ZUR SPEICHERUNG DER KLASSENOPTIONEN
\newif\ifunicode\unicodetrue
\newif\ifafive\afivetrue
\newif\ifmpost\mpostfalse
\newif\iffinal\finalfalse
\newif\ifprint\printfalse
\newif\ifmain\mainfalse
\newif\ifweb\webfalse
\newif\ifwatermark\watermarkfalse
\newif\ifbluelinks\bluelinksfalse
%%% DEKLARATION DER ALLGEMEINEN KLASSENOPTIONEN
\DeclareOption{utf8}       {\unicodetrue}     % UTF8-Kodierung (jetzt default)
\DeclareOption{latin1}     {\unicodefalse}    % LATIN1-Kodierung (ISO-8859)
\DeclareOption{dvioutput}  {\pdfoutputfalse}
\DeclareOption{pdfoutput}  {\pdfoutputtrue}
\DeclareOption{a5}         {\afivetrue}       % A5-Format fuer Einzelseiten
\DeclareOption{a4}         {\afivefalse}      % A4-Format fuer Einzelseiten
\DeclareOption{mpost}      {\mposttrue\pdfoutputfalse}% Zur Verwendung in Metapost
\DeclareOption{final}      {\finaltrue}       % Endversion (ohne Markierungen)
\DeclareOption{print}      {\printtrue\finaltrue} % Druckversion (ohne hyperref)
\DeclareOption{main}       {\maintrue}        % Steuerdatei fuer gesamtes Heft
\DeclareOption{web}        {\webtrue\pdfoutputtrue} % WEB-Version (Querformat)
\DeclareOption{digital}    {\finaltrue\watermarktrue\bluelinkstrue} % Digital-Version
%%% LISTE DER ARTIKELOPTIONEN
\def\@wzloptionlist{firstpage,bookcorner,bookscorner,exercises,solutions}
\@for\@opt:=\@wzloptionlist\do{
  \expandafter\newif\csname if\@opt\endcsname % \if-Befehl erzeugen
  \csname\@opt false\endcsname                % Option auf false setzen
  %% Erzeuge \DeclareOption{xyz}{\xyztrue} mit xyz=\@opt
  \expandafter\DeclareOption\expandafter\@opt\csname\@opt true\endcsname
}
%%% OPTIONEN AUSFUEHREN (VARABLEN BELEGEN)
\pdfoutputtrue                                % Default: pdf-Ausgabe
\ProcessOptions

% Ausgabeformat je nach Programm und Klassenoptionen endgueltig festlegen
\ifpdflatex
  \ifpdfoutput\pdfoutput=1\else\pdfoutput=0\fi
\else
  \pdfoutputfalse
\fi

%%% KLASSE UND PAKETE LADEN
\ifweb
  \LoadClass[landscape]{article}
\else
  \LoadClass[twoside]{article}          % Standard Article-Klasse, zweiseitig
\fi
\ifunicode
  \RequirePackage[utf8]{inputenc}       % UTF8 Eingabekodierung
\else
  \RequirePackage[latin1]{inputenc}     % LATIN1 Eingabekodierung
\fi
\RequirePackage{ifthen,calc}            % Abfragen und Arithmetik
\RequirePackage{amsmath,amssymb,amsthm} % AMS-Pakete
\let\mpoststop\relax\ifmpost            % Falls Metapost-Modus
  \RequirePackage{wzlfont\wzlversion}     % Zeichensatzanpassungen
  \RequirePackage{wzltool\wzlversion}     % Hilfsbefehle
  \AtBeginDocument{\small}                % Alle Label in \small setzen
  \let\mpoststop\endinput                 % ganzen Rest ignorieren
\fi\mpoststop
\RequirePackage[english,ngerman]{babel} % mit \frenchspacing
\RequirePackage{wzlpage\wzlversion}     % Seiteneinrichtung
\ifpdfoutput                            % Hyperrefs, \url-Befehl
  \RequirePackage[pdftex]{hyperref}
\else
  \RequirePackage[dvips]{hyperref}
\fi
% Einstellungen fuer Hyperref
\ifafive\hypersetup{a5paper}\else\hypersetup{a4paper}\fi
\ifprint\hypersetup{draft}\fi
\pdfstringdefDisableCommands{\renewcommand\Wurzel{Wurzel}\renewcommand\\{ }}
\def\UrlFont{\vttfamily}
% Grafik, Spezialbefehle (\scalebox, \rotatebox, etc.)
\ifpdfoutput
  \RequirePackage[pdftex]{graphicx}
  \DeclareGraphicsExtensions{.png,.jpg,.mps,.pdf}
  \pdfcompresslevel=9
  \ifweb
    \RequirePackage[pdftex,rgb]{xcolor}
    \definecolor{linkcol}{rgb}{0.1,0.05,0.9}
    \hypersetup{colorlinks=true,linkcolor=linkcol,urlcolor=linkcol,citecolor=linkcol}
  \else
    \RequirePackage[pdftex,cmyk]{xcolor}
  \fi  
\else
  \RequirePackage[dvips]{graphicx}
  \DeclareGraphicsExtensions{.eps,.mps}
  \RequirePackage[dvips,cmyk]{xcolor}
\fi
%%% TITLE AND AUTHOR COMMANDS
\renewcommand\author[1]{\def\@author{#1}}
\renewcommand\title[2][\@title]{\def\@title{#2}\def\@headtitle{#1}}
\newcommand\name[1]{#1}
\newcommand\contentsignore[1]{#1}
\newcommand\onlycontents[1]{#1}
\newcommand\maketitleauthor{\maketitle[author]}
\renewcommand\maketitle[1][noauthor]{%
  \@maketitle{#1}%
  \markboth\@headtitle\@headtitle%
  \ifmain\writetitletotoc\fi%
}
\newcommand\titlefont{\normalfont\sffamily\bfseries}
\newcommand\authorformat[1]{\rmfamily von #1}
\renewcommand\@maketitle[1]{%
  \renewcommand\contentsignore[1]{##1}%
  \renewcommand\onlycontents[1]{}%
  \renewcommand\name[1]{\textsc{##1}}%
  \part{\@title}
  {\centering
    \vspace{-3pt}\vspace*{-3pt}
    {\Large\linespread{0.95}\titlefont\@title\par}
    \ifthenelse{\equal{#1}{author}}{\vspace{4pt}\authorformat{\@author}}{}
    \vspace{4pt}\par\smallskip
  }\nopagebreak%
}
\newcommand\makeauthor{\@makeauthor}
\newcommand\@makeauthor{\par\nopagebreak%
  \renewcommand\name[1]{##1}%
  \begin{flushright}{\sffamily\slshape\@author}\end{flushright}\vspace{-2ex}%
}
% Jeden Artikel als \part behandeln
\renewcommand\@part[2][]{%
  \refstepcounter{part}%
  \stepcounter{losequation}%
  \addcontentsline{toc}{part}{#1}%
  \@afterheading%
}
\setcounter{tocdepth}{2}

%%% Dokument-Einstellungen
\newcommand\extrafoot[1]{\def\outerfoot{#1}}
\newcommand\articleinfo[1]{\def\@articleinfo{[#1]}}\articleinfo{}
\newcommand\twodigits[1]{\two@digits{\value{#1}}}
\newcounter{hours}\newcounter{mins}\renewcommand\themins{\twodigits{mins}}
\newcommand\timestamp{%
  \setcounter{hours}{\time/60}\setcounter{mins}{\time-\value{hours}*60}%
  \texttt{\number\day.\,\number\month.\,\number\year~~\thehours:\themins~~}%
  \url{\jobname.tex}\ifx\@articleinfo\@empty\else~\texttt{\@articleinfo}\fi}

%%% IMPLEMENTATION DER ARTIKELOPTIONEN
\newcommand\processwzldocumentoptions{
  \ifbookcorner \title{Buchvorstellung} \fi
  \ifbookscorner\title{Buchvorstellungen} \fi
  \ifexercises  \title{\Wurzel-Aufgaben}\author{} \fi
  \ifsolutions  \author{} \fi
  \iffirstpage
    \thispagestyle{title}\enlargethispage{-125pt}
    \renewcommand\author[1]{\@latex@error{\string\author\space not allowed for firstpage. Use
                            \string\title\space for cover description}{}}%
    \renewcommand\title[1]{\ifmain\writetocfile{\string\cntcover{##1}}\fi}%
  \fi
}
\processwzldocumentoptions

%%% UMBRUCHBEFEHLE, DIE NUR IM MAIN-MODUS AKTIV SIND
\newcommand\finalvspace{\@ifstar{\@gobble}{\@gobble}}
\newcommand\finalpagebreak[1][4]{}
\newcommand\finalnewpage{}
\newcommand\finalenlargethispage{\@ifstar{\@gobble}{\@gobble}}

%%% ALLGEMEINE ZUSATZBEFEHLE LADEN
\RequirePackage{wzlfont\wzlversion}     % Zeichensatzanpassungen
\RequirePackage{wzltool\wzlversion}     % Hilfsbefehle
\RequirePackage{wzlbook\wzlversion}     % Fuer Buchbesprechung(en)
\RequirePackage{wzlprob\wzlversion}     % Fuer Aufgaben und Loesungen
%%% ZUSATZBEFEHLE FUER KOMPLETTWURZEL LADEN
\ifmain
  \RequirePackage{wzlmain\wzlversion}
\fi

%%% INITIALISIERUNG
\def\@Preis{0,00\,\euro}
\def\@Zeitschrift{Zeitschrift f\"ur Mathematik}%
\def\@Ausgabe{0.~Jahrgang}%
\def\@Heft{Nullheft}
\def\@Wurzelheft{\Wurzel{}}
\ifweb\def\@Wurzelheft{\href{http://www.wurzel.org}{\Wurzel} -- \@Zeitschrift}\fi
\def\@articleinfo{}
\pagestyle{headings}
\newcounter{losequation}
\@addtoreset{equation}{losequation}

%%% MARKIERUNGEN (IM FINAL-MODUS AUS)
\iffinal
  \overfullrule0pt
  \extrafoot{}
  \newcommand\rem[1]{}
\else
  \overfullrule8pt
  \extrafoot{\timestamp}
  \newcommand\rem[1]{{\normalmarginpar\marginparwidth4cm\marginpar{%
                      \footnotesize\sffamily\sbcseries #1}}}
  \RequirePackage{showlabels}[2005/05/26]
  \showlabels{cite}
  \showlabels{bibitem}
\fi

%%% WASSERZEICHEN
% die folgenden vier Kommandos sollten immer sichtbar sein
\newcommand{\@visiblewatermarkvalue}{}
\newcommand{\@invisiblewatermarkvalue}{}
\newcommand{\visiblewatermark}[1]{\renewcommand{\@visiblewatermarkvalue}{#1}}
\newcommand{\invisiblewatermark}[1]{\renewcommand{\@invisiblewatermarkvalue}{#1}}
\ifwatermark
  \RequirePackage{wzlwatermark\wzlversion}
  \extrafoot{\@visiblewatermarkvalue}
  \RequirePackage{everypage}
  \AddEverypageHook{\@doinvisiblewatermark}
\fi
\ifbluelinks
  \hypersetup{allcolors=blue, colorlinks=true}
\fi

%%% Hyperref verunstaltet i.V.m. \def\UrlFont{\vttfamily} den ersten \url-Link
%   durch ein vorgestelltes "j". Deshalb erzeugen wir einen 0-ten Wegwerf-Link:
\AtBeginDocument{\newsavebox\@bugbox\begin{lrbox}\@bugbox\url{www}\end{lrbox}}
\endinput
