// Copyright 2016-2023 the nyan authors, LGPLv3+. See copying.md for legal info.

#pragma once


/**
 * @file
 * Main header file for nyan.
 */

#include "config.h"

#include "ast.h"
#include "database.h"
#include "error.h"
#include "file.h"
#include "lexer/lexer.h"
#include "member.h"
#include "namespace.h"
#include "object.h"
#include "ops.h"
#include "parser.h"
#include "token.h"
#include "type.h"
#include "util.h"
#include "value/container.h"
#include "value/dict.h"
#include "value/file.h"
#include "value/number.h"
#include "value/object.h"
#include "value/orderedset.h"
#include "value/set.h"
#include "value/text.h"
#include "value/value.h"
#include "view.h"


/**
 * The nyan engine and interpreter is defined in this namespace.
 */
namespace nyan {

} // namespace nyan
