"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createStubExe = void 0;
const fs = require("fs-extra");
const path = require("path");
const rcedit = require("rcedit");
const rcinfo = require("rcinfo");
const fs_helper_1 = require("./fs-helper");
function getExtractIcon() {
    if (process.platform === "win32") {
        return require("@bitdisaster/exe-icon-extractor").extractIcon;
    }
    else {
        return () => {
            throw new Error("Not implemented");
        };
    }
}
function getFileInfo(exePath) {
    return new Promise((resolve, reject) => {
        rcinfo(exePath, (error, info) => {
            return error ? reject(error) : resolve(info);
        });
    });
}
function extractIconFromApp(exePath, tempFolder) {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            const buffer = getExtractIcon()(exePath, "large");
            const iconPath = path.join(tempFolder, "app.ico");
            yield fs.writeFile(iconPath, buffer);
            return iconPath;
        }
        catch (error) {
            console.error("Unable to extract icon from exe. Please provide an explicit icon via parameter.", error);
            return "";
        }
    });
}
function createStubExe(appDirectory, exe, name, manufacturer, description, version, icon) {
    return __awaiter(this, void 0, void 0, function* () {
        const { tempFolderPath, tempFilePath } = (0, fs_helper_1.getTempFilePath)(exe, "exe");
        const stubPath = path.join(__dirname, "../../vendor/StubExecutable.exe");
        yield fs.copyFile(stubPath, tempFilePath);
        const appExe = path.join(appDirectory, `${exe}.exe`);
        let appIconPath;
        if (!icon) {
            appIconPath = yield extractIconFromApp(appExe, path.join(tempFolderPath));
        }
        let rcInfo;
        try {
            rcInfo = yield getFileInfo(appExe);
        }
        catch (error) {
            console.warn("Unable to read file info from exe. Falling back to packaging description.", error);
        }
        const rcOptions = {
            "version-string": {
                CompanyName: (rcInfo === null || rcInfo === void 0 ? void 0 : rcInfo.CompanyName) || manufacturer,
                FileDescription: (rcInfo === null || rcInfo === void 0 ? void 0 : rcInfo.FileDescription) || description,
                LegalCopyright: (rcInfo === null || rcInfo === void 0 ? void 0 : rcInfo.LegalCopyright) || `${new Date().getFullYear()}@${manufacturer}`,
                ProductName: (rcInfo === null || rcInfo === void 0 ? void 0 : rcInfo.ProductName) || name,
            },
            "file-version": (rcInfo === null || rcInfo === void 0 ? void 0 : rcInfo.FileVersion) || version,
            "product-version": (rcInfo === null || rcInfo === void 0 ? void 0 : rcInfo.ProductVersion) || version,
            icon: icon || appIconPath,
        };
        yield rcedit(tempFilePath, rcOptions);
        return tempFilePath;
    });
}
exports.createStubExe = createStubExe;
//# sourceMappingURL=rc-edit.js.map