import { WindowsSignOptions } from "./interfaces";
export interface MSICreatorOptions {
    appDirectory: string;
    appUserModelId?: string;
    toastActivatorClsid?: string;
    description: string;
    exe: string;
    icon?: string;
    extensions?: Array<string>;
    lightSwitches?: Array<string>;
    cultures?: string;
    language?: number;
    manufacturer: string;
    name: string;
    outputDirectory: string;
    programFilesFolderName?: string;
    nestedFolderName?: string;
    shortName?: string;
    shortcutFolderName?: string;
    shortcutName?: string;
    ui?: UIOptions | boolean;
    upgradeCode?: string;
    version: string;
    arch?: "x64" | "ia64" | "x86";
    features?: Features | false;
    autoRun?: boolean;
    defaultInstallMode?: "perUser" | "perMachine";
    rebootMode?: string;
    installLevel?: number;
    associateExtensions?: string;
    bundled?: boolean;
    windowsSign?: WindowsSignOptions;
    signWithParams?: string;
    certificateFile?: string;
    certificatePassword?: string;
}
export interface UIOptions {
    chooseDirectory?: boolean;
    template?: string;
    images?: UIImages;
    localizations?: Array<string>;
}
export interface UIImages {
    background?: string;
    banner?: string;
    exclamationIcon?: string;
    infoIcon?: string;
    newIcon?: string;
    upIcon?: string;
}
export interface AutoLaunchOptions {
    enabled: boolean;
    arguments: Array<string>;
}
export interface Features {
    autoUpdate: boolean;
    autoLaunch: boolean | AutoLaunchOptions;
}
export declare class MSICreator {
    fileComponentTemplate: string;
    registryComponentTemplate: string;
    permissionTemplate: string;
    componentRefTemplate: string;
    directoryTemplate: string;
    directoryNestedInstallTemplate: string;
    wixTemplate: string;
    uiTemplate: string;
    wixVariableTemplate: string;
    updaterTemplate: string;
    updaterPermissions: string;
    autoLaunchTemplate: string;
    shortcutPropertyTemplate: string;
    autoRunTemplate: string;
    fileAssociationHeaderTemplate: string;
    fileAssociationTemplate: string;
    iconTemplate: string;
    wxsFile: string;
    appDirectory: string;
    appUserModelId: string;
    toastActivatorClsid?: string;
    description: string;
    exe: string;
    icon?: string;
    extensions: Array<string>;
    lightSwitches: Array<string>;
    cultures?: string;
    language: number;
    manufacturer: string;
    name: string;
    outputDirectory: string;
    programFilesFolderName: string;
    nestedFolderName: string;
    shortName: string;
    shortcutFolderName: string;
    shortcutName: string;
    upgradeCode: string;
    windowsCompliantVersion: string;
    semanticVersion: string;
    arch: "x64" | "ia64" | "x86";
    autoUpdate: boolean;
    autoLaunch: boolean;
    autoLaunchArgs: Array<string>;
    autoRun?: boolean;
    defaultInstallMode: "perUser" | "perMachine";
    productCode: string;
    rebootMode: string;
    installLevel: number;
    hasAssociateExtensions: boolean;
    associateExtensions?: string;
    bundled: boolean;
    windowsSign?: WindowsSignOptions;
    ui: UIOptions | boolean;
    private files;
    private specialFiles;
    private directories;
    private registry;
    private tree;
    private components;
    private exeFilename;
    private exeFilePath;
    constructor(options: MSICreatorOptions);
    create(): Promise<{
        wxsFile: string;
        wxsContent: string;
        supportBinaries: Array<string>;
    }>;
    compile(): Promise<{
        wixobjFile: string;
        msiFile: string;
    }>;
    private createWxs;
    private createWixobj;
    private createMsi;
    private createFire;
    private signMSI;
    private getIcon;
    private getUI;
    private getUIVariables;
    private getDirectoryForTree;
    private getTree;
    private getFeatureComponentRefs;
    private getFileComponent;
    private getExtensionAssociation;
    private getExtensionAssociationList;
    private getRegistryComponent;
    private getShortcutProperty;
    private getComponentId;
    private getSpecialFiles;
    private getRegistryKeys;
}
