"use strict";

var _electron = require("electron");
// Expose protected methods that allow the renderer process to use
// the ipcRenderer without exposing the entire object
_electron.contextBridge.exposeInMainWorld('desktopApi', {
  send: (channel, data) => {
    // allowed channels
    const validChannels = ['setMenu', 'locale', 'appConfig', 'pluginsLoaded', 'run-command', 'plugin-manager', 'request-backend-token'];
    if (validChannels.includes(channel)) {
      _electron.ipcRenderer.send(channel, data);
    }
  },
  receive: (channel, func) => {
    const validChannels = ['currentMenu', 'setMenu', 'locale', 'appConfig', 'command-stdout', 'command-stderr', 'command-exit', 'plugin-manager', 'backend-token'];
    if (validChannels.includes(channel)) {
      // Deliberately strip event as it includes `sender`
      _electron.ipcRenderer.on(channel, (event, ...args) => func(...args));
    }
  },
  removeListener: (channel, func) => {
    _electron.ipcRenderer.removeListener(channel, func);
  }
});