"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _i18next = _interopRequireDefault(require("i18next"));
var _i18nHelper = require("./i18n-helper");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const i18nextBackend = require('i18next-fs-backend');
const en = {}; // To keep TS happy.

_i18next.default
// Use dynamic imports (webpack code splitting) to load javascript bundles.
// @see https://www.i18next.com/misc/creating-own-plugins#backend
// @see https://webpack.js.org/guides/code-splitting/
.use(i18nextBackend).use({
  type: 'backend',
  read(language, namespace, callback) {
    (specifier => new Promise(r => r(specifier)).then(s => _interopRequireWildcard(require(s))))(`./locales/${language}/${namespace}.json`).then(resources => {
      callback(null, resources);
    }).catch(error => {
      callback(error, null);
    });
  }
}).init({
  debug: process.env.NODE_ENV === 'development',
  fallbackLng: 'en',
  supportedLngs: _i18nHelper.CURRENT_LOCALES,
  ns: ['app'],
  defaultNS: 'app',
  interpolation: {
    escapeValue: false,
    // not needed for react as it escapes by default
    format: function (value, format, lng) {
      // https://www.i18next.com/translation-function/formatting
      if (format === 'number') return new Intl.NumberFormat(lng).format(value);
      if (format === 'date') return new Intl.DateTimeFormat(lng).format(value);
      return value;
    }
  },
  returnEmptyString: false,
  nsSeparator: '|',
  keySeparator: false
});
var _default = exports.default = _i18next.default;