/*!--------------------------------------------------------
 * Copyright (C) Microsoft Corporation. All rights reserved.
 *--------------------------------------------------------*/define("vs/code/electron-main/main.nls",{"sql/base/common/locConstants":["Enable automatic update checks. Azure Data Studio will check for updates automatically and periodically.","Enable to download and install new Azure Data Studio Versions in the background on Windows","Show Release Notes after an update. The Release Notes are opened in a new web browser window.","The dashboard toolbar action menu","The notebook cell title menu","The notebook title menu","The notebook toolbar menu","The dataexplorer view container title action menu","The dataexplorer item context menu","The object explorer item context menu","The connection dialog's browse tree context menu","The data grid item context menu","Sets the security policy for downloading extensions.","Your extension policy does not allow installing extensions. Please change your extension policy and try again.","Completed installing {0} extension from VSIX. Please reload Azure Data Studio to enable it.","Please reload Azure Data Studio to complete the uninstallation of this extension.","Please reload Azure Data Studio to enable the updated extension.","Please reload Azure Data Studio to enable this extension locally.","Please reload Azure Data Studio to enable this extension.","Please reload Azure Data Studio to disable this extension.","Please reload Azure Data Studio to complete the uninstallation of the extension {0}.","Please reload Azure Data Studio to enable this extension in {0}.","Installing extension {0} is completed. Please reload Azure Data Studio to enable it.","Please reload Azure Data Studio to complete reinstalling the extension {0}.","Marketplace","The scenario type for extension recommendations must be provided.","Unable to install version '{0}' of extension '{1}' as it is not compatible with Azure Data Studio '{2}'. Update to Azure Data Studio {3} to install the extension.","New Query","New &&Query","&&New Notebook","New &&Deployment...","Controls the memory available to Azure Data Studio after restart when trying to open large files. Same effect as specifying `--max-memory=NEWSIZE` on the command line.","Configure glob patterns of file paths to exclude from file watching. Patterns must match on absolute paths, i.e. prefix with `**/` or the full path to match properly and suffix with `/**` to match files within a path (for example `**/build/output/**` or `/Users/name/workspaces/project/build/output/**`). Changing this setting requires a restart. When you experience Azure Data Studio consuming lots of CPU time on startup, you can exclude large folders to reduce the initial load.","Would you like to change Azure Data Studio's UI language to {0} and restart?","In order to use Azure Data Studio in {0}, Azure Data Studio needs to restart.","New SQL File","New Notebook","Install Extension from VSIX Package","Controls whether or not workspace trust is enabled within Azure Data Studio.","Controls whether or not the empty window is trusted by default within Azure Data Studio. When used with `#{0}#`, you can enable the full functionality of Azure Data Studio without prompting in an empty window.","VS Code notebook extensions are not supported in Azure Data Studio.","Could not parse `{0}` value {1}. Please use, for example: ^1.22.0, ^1.22.x, etc.","Extension is not compatible with Azure Data Studio {0}. Extension requires: {1}.","Extension is not compatible with Azure Data Studio {0}. Extension requires a newer VS Code Engine Version {1}, which is newer than what is currently supported ({2}).","`${appName}`: e.g. Azure Data Studio.","Whether or not to allow chord keybindings in the terminal. Note that when this is true and the keystroke results in a chord it will bypass `#terminal.integrated.commandsToSkipShell#`, setting this to false is particularly useful when you want ctrl+k to go to your shell (not Azure Data Studio).",`A set of messages that when encountered in the terminal will be automatically responded to. Provided the message is specific enough, this can help automate away common responses.

Remarks:

- Use {0} to automatically respond to the terminate batch job prompt on Windows.
- The message includes escape sequences so the reply might not happen with styled text.
- Each reply can only happen once every second.
- Use {1} in the reply to mean the enter key.
- To unset a default key, set the value to null.
- Restart Azured Data Studio if new don't apply.`,`A set of command IDs whose keybindings will not be sent to the shell but instead always be handled by Azure Data Studio. This allows keybindings that would normally be consumed by the shell to act instead the same as when the terminal is not focused, for example \`Ctrl+P\` to launch Quick Open.

&nbsp;

Many commands are skipped by default. To override a default and pass that command's keybinding to the shell instead, add the command prefixed with the \`-\` character. For example add \`-workbench.action.quickOpen\` to allow \`Ctrl+P\` to reach the shell.

&nbsp;

The following list of default skipped commands is truncated when viewed in Settings Editor. To see the full list, {1} and search for the first command from the list below.

&nbsp;

Default Skipped Commands:

{0}`,"open the default settings JSON","Open Default Settings (JSON)","Controls whether to detect and set the `$LANG` environment variable to a UTF-8 compliant option since Azure Data Studio's terminal only supports UTF-8 encoded data coming from the shell.","Object with environment variables that will be added to the Azure Data Studio process to be used by the terminal on macOS. Set to `null` to delete the environment variable.","Object with environment variables that will be added to the Azure Data Studio process to be used by the terminal on Linux. Set to `null` to delete the environment variable.","Object with environment variables that will be added to the Azure Data Studio process to be used by the terminal on Windows. Set to `null` to delete the environment variable.","Whether new shells should inherit their environment from Azure Data Studio, which may source a login shell to ensure $PATH and other development variables are initialized. This has no effect on Windows.","Azure Data Studio",'Before you report an issue here please <a href="https://github.com/microsoft/azuredatastudio/wiki/Submitting-Bugs-and-Suggestions" target="_blank">review the guidance we provide</a>.',"Priority list for output mime types. (for VS Code Notebooks only)","Where the cell toolbar should be shown, or whether it should be hidden. (for VS Code Notebooks only)","Whether the cell status bar should be shown. (for VS Code Notebooks only)","Whether to use the enhanced text diff editor for notebook. (for VS Code Notebooks only)","Whether the cell toolbar should appear on hover or click. (for VS Code Notebooks only)","Whether to use separate undo/redo stack for each cell. (for VS Code Notebooks only)","Control whether the notebook editor should be rendered in a compact form. For example, when turned on, it will decrease the left margin width. (for VS Code Notebooks only)","Controls where the focus indicator is rendered, either along the cell borders or on the left gutter. (for VS Code Notebooks only)","Control where the insert cell actions should appear. (for VS Code Notebooks only)","Control whether to render a global toolbar inside the notebook editor. (for VS Code Notebooks only)","Control whether outputs action should be rendered in the output toolbar. (for VS Code Notebooks only)","Controls when the Markdown header folding arrow is shown. (for VS Code Notebooks only)","Control whether the notebook editor should allow moving cells through drag and drop. (for VS Code Notebooks only)","Control whether extra actions are shown in a dropdown next to the run button. (for VS Code Notebooks only)","Control whether the actions on the notebook toolbar should render label or not. (for VS Code Notebooks only)","Control how many lines of text in a text output is rendered. (for VS Code Notebooks only)","Controls the font size in pixels of rendered markup in notebooks. When set to `0`, 120% of `#editor.fontSize#` is used. (for VS Code Notebooks only)","Controls whether code cells in the interactive window are collapsed by default. (for VS Code Notebooks only)",`Line height of the output text for notebook cells.
 - Values between 0 and 8 will be used as a multiplier with the font size.
 - Values greater than or equal to 8 will be used as effective values. (for VS Code Notebooks only)`,"Font size for the output text for notebook cells. When set to 0 `#editor.fontSize#` is used. (for VS Code Notebooks only)","The font family for the output text for notebook cells. When set to empty, the `#editor.fontFamily#` is used. (for VS Code Notebooks only)","Settings for code editors used in notebooks. This can be used to customize most editor.* settings. (for VS Code Notebooks only)","Download","Download this extension from an external source","Install this extension","Azure Data Studio now ships with a new default theme '{0}'. If you prefer, you can switch back to the old theme or try one of the many other color themes available.","Azure Data Studio now ships with a new default theme '{0}'. Do you want to give it a try?",`Version: {0}
Commit: {1}
Date: {2}
VS Code: {3}
Electron: {4}
Chromium: {5}
Node.js: {6}
V8: {7}
OS: {8}`],"vs/base/common/date":["in {0}","now","{0} second ago","{0} sec ago","{0} seconds ago","{0} secs ago","{0} second","{0} sec","{0} seconds","{0} secs","{0} minute ago","{0} min ago","{0} minutes ago","{0} mins ago","{0} minute","{0} min","{0} minutes","{0} mins","{0} hour ago","{0} hr ago","{0} hours ago","{0} hrs ago","{0} hour","{0} hr","{0} hours","{0} hrs","{0} day ago","{0} days ago","{0} day","{0} days","{0} week ago","{0} wk ago","{0} weeks ago","{0} wks ago","{0} week","{0} wk","{0} weeks","{0} wks","{0} month ago","{0} mo ago","{0} months ago","{0} mos ago","{0} month","{0} mo","{0} months","{0} mos","{0} year ago","{0} yr ago","{0} years ago","{0} yrs ago","{0} year","{0} yr","{0} years","{0} yrs"],"vs/base/common/errorMessage":["{0}: {1}","A system error occurred ({0})","An unknown error occurred. Please consult the log for more details.","An unknown error occurred. Please consult the log for more details.","{0} ({1} errors in total)","An unknown error occurred. Please consult the log for more details."],"vs/base/common/jsonErrorMessages":["Invalid symbol","Invalid number format","Property name expected","Value expected","Colon expected","Comma expected","Closing brace expected","Closing bracket expected","End of file expected"],"vs/base/common/platform":["_"],"vs/code/electron-main/app":["&&Yes","&&No","An external application wants to open '{0}' in {1}. Do you want to open this file or folder?","If you did not initiate this request, it may represent an attempted attack on your system. Unless you took an explicit action to initiate this request, you should press 'No'"],"vs/code/electron-main/main":["Main","Another instance of {0} is already running as administrator.","Please close the other instance and try again.","Another instance of {0} is running but not responding","Please close all other instances and try again.","Warning: The --status argument can only be used if {0} is already running. Please run it again after {0} has started.","Unable to write program user data.",`{0}

Please make sure the following directories are writeable:

{1}`,"&&Close"],"vs/platform/configuration/common/configurationRegistry":["Default Language Configuration Overrides","Configure settings to be overridden for the {0} language.","Configure editor settings to be overridden for a language.","This setting does not support per-language configuration.","Configure editor settings to be overridden for a language.","This setting does not support per-language configuration.","Cannot register an empty property","Cannot register '{0}'. This matches property pattern '\\\\[.*\\\\]$' for describing language specific editor settings. Use 'configurationDefaults' contribution.","Cannot register '{0}'. This property is already registered.","Cannot register '{0}'. The associated policy {1} is already registered with {2}."],"vs/platform/contextkey/common/contextkey":["Empty context key expression","Did you forget to write an expression? You can also put 'false' or 'true' to always evaluate to false or true, respectively.","'in' after 'not'.","closing parenthesis ')'","Unexpected token","Did you forget to put && or || before the token?","Unexpected end of expression","Did you forget to put a context key?",`Expected: {0}
Received: '{1}'.`,"Unexpected token. Hint: {0}","Unexpected token."],"vs/platform/contextkey/common/scanner":["Did you mean {0}?","Did you mean {0} or {1}?","Did you mean {0}, {1} or {2}?","Did you forget to open or close the quote?","Did you forget to escape the '/' (slash) character? Put two backslashes before it to escape, e.g., '\\\\/'."],"vs/platform/dialogs/common/dialogs":["&&Yes","Cancel","Cancel","Cancel","&&OK","&&OK","Cancel","...1 additional file not shown","...{0} additional files not shown"],"vs/platform/dialogs/electron-main/dialogMainService":["Open","Open Folder","Open File","Open Workspace from File","&&Open"],"vs/platform/environment/node/argv":["Options","Extensions Management","Troubleshooting","Directory where CLI metadata should be stored.","Directory where CLI metadata should be stored.","Compare two files with each other.","Perform a three-way merge by providing paths for two modified versions of a file, the common origin of both modified versions and the output file to save merge results.","Add folder(s) to the last active window.","Open a file at the path on the specified line and character position.","Force to open a new window.","Force to open a file or folder in an already opened window.","Wait for the files to be closed before returning.","The locale to use (e.g. en-US or zh-TW).","Specifies the directory that user data is kept in. Can be used to open multiple distinct instances of Code.","Opens the provided folder or workspace with the given profile and associates the profile with the workspace. If the profile does not exist, a new empty one is created. A folder or workspace must be provided for the profile to take effect.","Print usage.","Set the root path for extensions.","List the installed extensions.","Show versions of installed extensions, when using --list-extensions.","Filters installed extensions by provided category, when using --list-extensions.","Installs or updates an extension. The argument is either an extension id or a path to a VSIX. The identifier of an extension is '${publisher}.${name}'. Use '--force' argument to update to latest version. To install a specific version provide '@${version}'. For example: 'vscode.csharp@1.2.3'.","Installs the pre-release version of the extension, when using --install-extension","Uninstalls an extension.","Enables proposed API features for extensions. Can receive one or more extension IDs to enable individually.","Print version.","Print verbose output (implies --wait).","Log level to use. Default is 'info'. Allowed values are 'critical', 'error', 'warn', 'info', 'debug', 'trace', 'off'. You can also configure the log level of an extension by passing extension id and log level in the following format: '${publisher}.${name}:${logLevel}'. For example: 'vscode.csharp:trace'. Can receive one or more such entries.","Print process usage and diagnostics information.","Run CPU profiler during startup.","Disable all installed extensions. This option is not persisted and is effective only when the command opens a new window.","Disable the provided extension. This option is not persisted and is effective only when the command opens a new window.","Turn sync on or off.","Allow debugging and profiling of extensions. Check the developer tools for the connection URI.","Allow debugging and profiling of extensions with the extension host being paused after start. Check the developer tools for the connection URI.","Disable GPU hardware acceleration.","Use this option only when there is requirement to launch the application as sudo user on Linux or when running as an elevated user in an applocker environment on Windows.","Shows all telemetry events which VS code collects.","Use Microsoft Entra authentication, this option is depcrecated - use 'authenticationType' instead.","Supports providing applicationName that will be used for connection profile app name.","Provide authentication mode to be used. Accepted values: AzureMFA, SqlLogin, Integrated, etc.","Name of command to run, accepted values: connect (default), openConnectionDialog or Id of a command supported by Azure Data Studio.",`Supports providing advanced connection properties that providers support. Value must be a json object containing key-value pairs in format: '{"key1":"value1"}'`,"Name of database","Use Integrated authentication, this option is depcrecated - use 'authenticationType' instead.","Connection provider to use, e.g. MSSQL, PGSQL, etc. ","Name of target server or host name.","Whether or not to show dashboard on connection, false by default.","User name/email address","Use {0} instead.","paths","Usage","options","To read output from another program, append '-' (e.g. 'echo Hello World | {0} -')","To read from stdin, append '-' (e.g. 'ps aux | grep code | {0} -')","Subcommands","Unknown version","Unknown commit"],"vs/platform/environment/node/argvHelper":["Option '{0}' is defined more than once. Using value '{1}'.","Option '{0}' requires a non empty value. Ignoring the option.","Option '{0}' is deprecated: {1}","Warning: '{0}' is not in the list of known options for subcommand '{1}'","Warning: '{0}' is not in the list of known options, but still passed to Electron/Chromium.","Arguments in `--goto` mode should be in the format of `FILE(:LINE(:CHARACTER))`."],"vs/platform/extensionManagement/common/extensionManagement":["Extensions","Preferences"],"vs/platform/extensionManagement/common/extensionNls":["Couldn't find message for key {0}."],"vs/platform/extensionManagement/common/extensionsScannerService":["Cannot read file {0}: {1}.","Failed to parse {0}: [{1}, {2}] {3}.","Invalid manifest file {0}: Not an JSON object.","Failed to parse {0}: {1}.","Invalid format {0}: JSON object expected.","Failed to parse {0}: {1}.","Invalid format {0}: JSON object expected."],"vs/platform/extensions/common/extensionValidator":["property publisher must be of type `string`.","property `{0}` is mandatory and must be of type `string`","property `{0}` is mandatory and must be of type `string`","property `{0}` is mandatory and must be of type `object`","property `{0}` is mandatory and must be of type `string`","property `{0}` can be omitted or must be of type `string[]`","property `{0}` can be omitted or must be of type `string[]`","property `{0}` should be omitted if the extension doesn't have a `{1}` or `{2}` property.","property `{0}` can be defined only if property `main` is also defined.","property `{0}` can be omitted or must be of type `string`","Expected `main` ({0}) to be included inside extension's folder ({1}). This might make the extension non-portable.","property `{0}` can be omitted or must be of type `string`","Expected `browser` ({0}) to be included inside extension's folder ({1}). This might make the extension non-portable.","Extension version is not semver compatible."],"vs/platform/externalTerminal/node/externalTerminalService":["VS Code Console","Script '{0}' failed with exit code {1}","'{0}' not supported","Press any key to continue...","'{0}' failed with exit code {1}","can't find terminal application '{0}'"],"vs/platform/files/common/fileService":["Unable to resolve filesystem provider with relative file path '{0}'","ENOPRO: No file system provider found for resource '{0}'","Unable to resolve nonexistent file '{0}'","Unable to create file '{0}' that already exists when overwrite flag is not set","Unable to write file '{0}' ({1})","Unable to unlock file '{0}' because provider does not support it.","Unable to atomically write file '{0}' because provider does not support it.","Unable to unlock file '{0}' because atomic write is enabled.","Unable to write file '{0}' that is actually a directory","File Modified Since","Unable to read file '{0}' ({1})","Unable to read file '{0}' that is actually a directory","File not modified since","Unable to read file '{0}' that is too large to open","Unable to copy when source '{0}' is same as target '{1}' with different path case on a case insensitive file system","Unable to move/copy when source '{0}' is parent of target '{1}'.","Unable to move/copy '{0}' because target '{1}' already exists at destination.","Unable to move/copy '{0}' into '{1}' since a file would replace the folder it is contained in.","Unable to create folder '{0}' that already exists but is not a directory","Unable to delete file '{0}' via trash because provider does not support it.","Unable to delete file '{0}' atomically because provider does not support it.","Unable to atomically delete file '{0}' because using trash is enabled.","Unable to delete nonexistent file '{0}'","Unable to delete non-empty folder '{0}'.","Unable to modify read-only file '{0}'","Unable to modify read-only file '{0}'"],"vs/platform/files/common/files":["Unknown Error","{0}B","{0}KB","{0}MB","{0}GB","{0}TB"],"vs/platform/files/common/io":["File is too large to open"],"vs/platform/files/electron-main/diskFileSystemProviderServer":["Failed to move '{0}' to the recycle bin","Failed to move '{0}' to the trash"],"vs/platform/files/node/diskFileSystemProvider":["File already exists","File does not exist","Unable to move '{0}' into '{1}' ({2}).","Unable to copy '{0}' into '{1}' ({2}).","File cannot be copied to same path with different path case","File to move/copy does not exist","File at target already exists and thus will not be moved/copied to unless overwrite is specified"],"vs/platform/issue/electron-main/issueMainService":["Local","Issue Reporter","Process Explorer","Successfully created the trace file",`Please create an issue and manually attach the following file:
{0}`,"&&OK","Your input will not be saved. Are you sure you want to close this window?","&&Yes","Cancel","There is too much data to send to GitHub directly. The data will be copied to the clipboard, please paste it into the GitHub issue page that is opened.","&&OK","Cancel"],"vs/platform/menubar/electron-main/menubar":["New &&Window","&&File","&&Edit","&&View","Window","&&Help","About {0}","&&Preferences","Services","Hide {0}","Hide Others","Show All","Quit {0}","&&Quit","Cancel","Are you sure you want to quit?","Minimize","Zoom","Bring All to Front","Switch &&Window...","New Tab","Show Previous Tab","Show Next Tab","Move Tab to New Window","Merge All Windows","Check for &&Updates...","Checking for Updates...","D&&ownload Available Update","Downloading Update...","Install &&Update...","Installing Update...","Restart to &&Update"],"vs/platform/native/electron-main/nativeHostMainService":["{0} will now prompt with 'osascript' for Administrator privileges to install the shell command.","&&OK","Cancel","Unable to install the shell command '{0}'.","{0} will now prompt with 'osascript' for Administrator privileges to uninstall the shell command.","&&OK","Cancel","Unable to uninstall the shell command '{0}'.","Unable to find shell script in '{0}'"],"vs/platform/request/common/request":["Network Requests","HTTP","The proxy setting to use. If not set, will be inherited from the `http_proxy` and `https_proxy` environment variables.","Controls whether the proxy server certificate should be verified against the list of supplied CAs.","Overrides the principal service name for Kerberos authentication with the HTTP proxy. A default based on the proxy hostname is used when this is not set.","The value to send as the `Proxy-Authorization` header for every network request.","Disable proxy support for extensions.","Enable proxy support for extensions.","Enable proxy support for extensions, fall back to request options, when no proxy found.","Enable proxy support for extensions, override request options.","Use the proxy support for extensions.","Controls whether CA certificates should be loaded from the OS. (On Windows and macOS, a reload of the window is required after turning this off.)"],"vs/platform/shell/node/shellEnv":["Unable to resolve your shell environment in a reasonable time. Please review your shell configuration and restart.","Unable to resolve your shell environment: {0}","Unexpected exit code from spawned shell (code {0}, signal {1})"],"vs/platform/telemetry/common/telemetryService":["Controls {0} telemetry, first-party extension telemetry, and participating third-party extension telemetry. Some third party extensions might not respect this setting. Consult the specific extension's documentation to be sure. Telemetry helps us better understand how {0} is performing, where improvements need to be made, and how features are being used.","Read more about the [data we collect]({0}).","Read more about the [data we collect]({0}) and our [privacy statement]({1}).","A full restart of the application is necessary for crash reporting changes to take effect.","Crash Reports","Error Telemetry","Usage Data","The following table outlines the data sent with each setting:","****Note:*** If this setting is 'off', no telemetry will be sent regardless of other telemetry settings. If this setting is set to anything except 'off' and telemetry is disabled with deprecated settings, no telemetry will be sent.*","Telemetry","Sends usage data, errors, and crash reports.","Sends general error telemetry and crash reports.","Sends OS level crash reports.","Disables all product telemetry.","Telemetry","Enable diagnostic data to be collected. This helps us to better understand how {0} is performing and where improvements need to be made.","Enable diagnostic data to be collected. This helps us to better understand how {0} is performing and where improvements need to be made. [Read more]({1}) about what we collect and our privacy statement.","If this setting is false, no telemetry will be sent regardless of the new setting's value. Deprecated in favor of the {0} setting."],"vs/platform/terminal/common/terminalPlatformConfiguration":["An optional set of arguments to run the shell executable with.","Controls whether or not the profile name overrides the auto detected one.","A codicon ID to associate with the terminal icon.","A theme color ID to associate with the terminal icon.","An object with environment variables that will be added to the terminal profile process. Set to `null` to delete environment variables from the base environment.","A single path to a shell executable or an array of paths that will be used as fallbacks when one fails.","A single path to a shell executable.",`A set of terminal profile customizations for {0} which allows adding, removing or changing how terminals are launched. Profiles are made up of a mandatory path, optional arguments and other presentation options.

To override an existing profile use its profile name as the key, for example:

{1}

{2}Read more about configuring profiles{3}.`,"Integrated Terminal","The terminal profile to use on Linux for automation-related terminal usage like tasks and debug.","The terminal profile to use on macOS for automation-related terminal usage like tasks and debug.","The terminal profile to use for automation-related terminal usage like tasks and debug. This setting will currently be ignored if {0} (now deprecated) is set.","A profile source that will auto detect the paths to the shell. Note that non-standard executable locations are not supported and must be created manually in a new profile.","The extension that contributed this profile.","The id of the extension terminal","The name of the extension terminal","The extension that contributed this profile.","The id of the extension terminal","The name of the extension terminal","The extension that contributed this profile.","The id of the extension terminal","The name of the extension terminal","Controls whether or not WSL distros are shown in the terminal dropdown","Controls the maximum amount of lines that will be restored when reconnecting to a persistent terminal session. Increasing this will restore more lines of scrollback at the cost of more memory and increase the time it takes to connect to terminals on start up. This setting requires a restart to take effect and should be set to a value less than or equal to `#terminal.integrated.scrollback#`.","Whether to show hovers for links in the terminal output.","A set of process names to ignore when using the {0} setting.","Integrated Terminal","The default terminal profile on Linux.","The default terminal profile on macOS.","The default terminal profile on Windows."],"vs/platform/terminal/common/terminalProfiles":["Automatically detect the default"],"vs/platform/update/common/update.config.contribution":["Update","Configure whether you receive automatic updates. Requires a restart after change. The updates are fetched from a Microsoft online service.","Disable updates.","Disable automatic background update checks. Updates will be available if you manually check for updates.","Check for updates only on startup. Disable automatic background update checks.","Configure whether you receive automatic updates. Requires a restart after change. The updates are fetched from a Microsoft online service.","This setting is deprecated, please use '{0}' instead.","Enable Background Updates on Windows"],"vs/platform/userDataProfile/common/userDataProfile":["Default"],"vs/platform/windows/electron-main/windowImpl":["&&Reopen","&&Close","&&Keep Waiting","The window is not responding","You can reopen or close the window or keep waiting.","Don't restore editors","The window terminated unexpectedly","The window terminated unexpectedly (reason: '{0}', code: '{1}')","&&Reopen","&&New Window","&&Close","We are sorry for the inconvenience. You can reopen the window to continue where you left off.","We are sorry for the inconvenience. You can open a new empty window to start again.","Don't restore editors","You can still access the menu bar by pressing the Alt-key."],"vs/platform/windows/electron-main/windowsMainService":["&&OK","Path does not exist","URI can not be opened","The path '{0}' does not exist on this computer.","The URI '{0}' is not valid and can not be opened.","&&Allow","&&Cancel","&&Learn More","The host '{0}' was not found in the list of allowed hosts. Do you want to allow it anyway?","The path '{0}' uses a host that is not allowed. Unless you trust the host, you should press 'Cancel'","Permanently allow host '{0}'"],"vs/platform/workspace/common/workspace":["Code Workspace"],"vs/platform/workspaces/electron-main/workspacesHistoryMainService":["New Window","Opens a new window","Recent Folders & Workspaces","Recent Folders","Untitled (Workspace)","{0} (Workspace)"],"vs/platform/workspaces/electron-main/workspacesManagementMainService":["&&OK","Unable to save workspace '{0}'","The workspace is already opened in another window. Please close that window first and then try again."]});

//# sourceMappingURL=https://sqlopsbuilds.blob.core.windows.net/sourcemaps/4970733324ef8254b7c22a5dc55af7f8a1dea93f/core/vs/code/electron-main/main.nls.js.map
