/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 * Changes may cause incorrect behavior and will be lost if the code is
 * regenerated.
 */

import * as msRest from "@azure/ms-rest-js";
import * as msRestAzure from "@azure/ms-rest-azure-js";
import * as Models from "../models";
import * as Mappers from "../models/aliasMappers";
import * as Parameters from "../models/parameters";
import { SubscriptionClientContext } from "../subscriptionClientContext";

/** Class representing a Alias. */
export class Alias {
  private readonly client: SubscriptionClientContext;

  /**
   * Create a Alias.
   * @param {SubscriptionClientContext} client Reference to the service client.
   */
  constructor(client: SubscriptionClientContext) {
    this.client = client;
  }

  /**
   * Create Alias Subscription.
   * @param aliasName Alias Name
   * @param body
   * @param [options] The optional parameters
   * @returns Promise<Models.AliasCreateResponse>
   */
  create(aliasName: string, body: Models.PutAliasRequest, options?: msRest.RequestOptionsBase): Promise<Models.AliasCreateResponse> {
    return this.beginCreate(aliasName,body,options)
      .then(lroPoller => lroPoller.pollUntilFinished()) as Promise<Models.AliasCreateResponse>;
  }

  /**
   * Get Alias Subscription.
   * @param aliasName Alias Name
   * @param [options] The optional parameters
   * @returns Promise<Models.AliasGetResponse>
   */
  get(aliasName: string, options?: msRest.RequestOptionsBase): Promise<Models.AliasGetResponse>;
  /**
   * @param aliasName Alias Name
   * @param callback The callback
   */
  get(aliasName: string, callback: msRest.ServiceCallback<Models.PutAliasResponse>): void;
  /**
   * @param aliasName Alias Name
   * @param options The optional parameters
   * @param callback The callback
   */
  get(aliasName: string, options: msRest.RequestOptionsBase, callback: msRest.ServiceCallback<Models.PutAliasResponse>): void;
  get(aliasName: string, options?: msRest.RequestOptionsBase | msRest.ServiceCallback<Models.PutAliasResponse>, callback?: msRest.ServiceCallback<Models.PutAliasResponse>): Promise<Models.AliasGetResponse> {
    return this.client.sendOperationRequest(
      {
        aliasName,
        options
      },
      getOperationSpec,
      callback) as Promise<Models.AliasGetResponse>;
  }

  /**
   * Delete Alias.
   * @param aliasName Alias Name
   * @param [options] The optional parameters
   * @returns Promise<msRest.RestResponse>
   */
  deleteMethod(aliasName: string, options?: msRest.RequestOptionsBase): Promise<msRest.RestResponse>;
  /**
   * @param aliasName Alias Name
   * @param callback The callback
   */
  deleteMethod(aliasName: string, callback: msRest.ServiceCallback<void>): void;
  /**
   * @param aliasName Alias Name
   * @param options The optional parameters
   * @param callback The callback
   */
  deleteMethod(aliasName: string, options: msRest.RequestOptionsBase, callback: msRest.ServiceCallback<void>): void;
  deleteMethod(aliasName: string, options?: msRest.RequestOptionsBase | msRest.ServiceCallback<void>, callback?: msRest.ServiceCallback<void>): Promise<msRest.RestResponse> {
    return this.client.sendOperationRequest(
      {
        aliasName,
        options
      },
      deleteMethodOperationSpec,
      callback);
  }

  /**
   * Get Alias Subscription.
   * @param [options] The optional parameters
   * @returns Promise<Models.AliasListResponse>
   */
  list(options?: msRest.RequestOptionsBase): Promise<Models.AliasListResponse>;
  /**
   * @param callback The callback
   */
  list(callback: msRest.ServiceCallback<Models.PutAliasListResult>): void;
  /**
   * @param options The optional parameters
   * @param callback The callback
   */
  list(options: msRest.RequestOptionsBase, callback: msRest.ServiceCallback<Models.PutAliasListResult>): void;
  list(options?: msRest.RequestOptionsBase | msRest.ServiceCallback<Models.PutAliasListResult>, callback?: msRest.ServiceCallback<Models.PutAliasListResult>): Promise<Models.AliasListResponse> {
    return this.client.sendOperationRequest(
      {
        options
      },
      listOperationSpec,
      callback) as Promise<Models.AliasListResponse>;
  }

  /**
   * Create Alias Subscription.
   * @param aliasName Alias Name
   * @param body
   * @param [options] The optional parameters
   * @returns Promise<msRestAzure.LROPoller>
   */
  beginCreate(aliasName: string, body: Models.PutAliasRequest, options?: msRest.RequestOptionsBase): Promise<msRestAzure.LROPoller> {
    return this.client.sendLRORequest(
      {
        aliasName,
        body,
        options
      },
      beginCreateOperationSpec,
      options);
  }
}

// Operation Specifications
const serializer = new msRest.Serializer(Mappers);
const getOperationSpec: msRest.OperationSpec = {
  httpMethod: "GET",
  path: "providers/Microsoft.Subscription/aliases/{aliasName}",
  urlParameters: [
    Parameters.aliasName
  ],
  queryParameters: [
    Parameters.apiVersion1
  ],
  headerParameters: [
    Parameters.acceptLanguage
  ],
  responses: {
    200: {
      bodyMapper: Mappers.PutAliasResponse
    },
    default: {
      bodyMapper: Mappers.ErrorResponseBody
    }
  },
  serializer
};

const deleteMethodOperationSpec: msRest.OperationSpec = {
  httpMethod: "DELETE",
  path: "providers/Microsoft.Subscription/aliases/{aliasName}",
  urlParameters: [
    Parameters.aliasName
  ],
  queryParameters: [
    Parameters.apiVersion1
  ],
  headerParameters: [
    Parameters.acceptLanguage
  ],
  responses: {
    200: {},
    204: {},
    default: {
      bodyMapper: Mappers.ErrorResponseBody
    }
  },
  serializer
};

const listOperationSpec: msRest.OperationSpec = {
  httpMethod: "GET",
  path: "providers/Microsoft.Subscription/aliases",
  queryParameters: [
    Parameters.apiVersion1
  ],
  headerParameters: [
    Parameters.acceptLanguage
  ],
  responses: {
    200: {
      bodyMapper: Mappers.PutAliasListResult
    },
    default: {
      bodyMapper: Mappers.ErrorResponseBody
    }
  },
  serializer
};

const beginCreateOperationSpec: msRest.OperationSpec = {
  httpMethod: "PUT",
  path: "providers/Microsoft.Subscription/aliases/{aliasName}",
  urlParameters: [
    Parameters.aliasName
  ],
  queryParameters: [
    Parameters.apiVersion1
  ],
  headerParameters: [
    Parameters.acceptLanguage
  ],
  requestBody: {
    parameterPath: "body",
    mapper: {
      ...Mappers.PutAliasRequest,
      required: true
    }
  },
  responses: {
    200: {
      bodyMapper: Mappers.PutAliasResponse
    },
    201: {
      bodyMapper: Mappers.PutAliasResponse
    },
    default: {
      bodyMapper: Mappers.ErrorResponseBody
    }
  },
  serializer
};
