/*
 * Copyright (c) Microsoft Corporation.
 * Licensed under the MIT License.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 * Changes may cause incorrect behavior and will be lost if the code is
 * regenerated.
 */
import { __assign, __extends } from "tslib";
import * as msRest from "@azure/ms-rest-js";
import * as Models from "./models";
import * as Mappers from "./models/mappers";
import * as Parameters from "./models/parameters";
import * as operations from "./operations";
import { ResourceGraphClientContext } from "./resourceGraphClientContext";
var ResourceGraphClient = /** @class */ (function (_super) {
    __extends(ResourceGraphClient, _super);
    /**
     * Initializes a new instance of the ResourceGraphClient class.
     * @param credentials Credentials needed for the client to connect to Azure. Credentials
     * implementing the TokenCredential interface from the @azure/identity package are recommended. For
     * more information about these credentials, see
     * {@link https://www.npmjs.com/package/@azure/identity}. Credentials implementing the
     * ServiceClientCredentials interface from the older packages @azure/ms-rest-nodeauth and
     * @azure/ms-rest-browserauth are also supported.
     * @param [options] The parameter options
     */
    function ResourceGraphClient(credentials, options) {
        var _this = _super.call(this, credentials, options) || this;
        _this.operations = new operations.Operations(_this);
        return _this;
    }
    ResourceGraphClient.prototype.resourceChanges = function (parameters, options, callback) {
        return this.sendOperationRequest({
            parameters: parameters,
            options: options
        }, resourceChangesOperationSpec, callback);
    };
    ResourceGraphClient.prototype.resourceChangeDetails = function (parameters, options, callback) {
        return this.sendOperationRequest({
            parameters: parameters,
            options: options
        }, resourceChangeDetailsOperationSpec, callback);
    };
    ResourceGraphClient.prototype.resources = function (query, options, callback) {
        return this.sendOperationRequest({
            query: query,
            options: options
        }, resourcesOperationSpec, callback);
    };
    ResourceGraphClient.prototype.resourcesHistory = function (request, options, callback) {
        return this.sendOperationRequest({
            request: request,
            options: options
        }, resourcesHistoryOperationSpec, callback);
    };
    return ResourceGraphClient;
}(ResourceGraphClientContext));
// Operation Specifications
var serializer = new msRest.Serializer(Mappers);
var resourceChangesOperationSpec = {
    httpMethod: "POST",
    path: "providers/Microsoft.ResourceGraph/resourceChanges",
    queryParameters: [Parameters.apiVersion0],
    headerParameters: [Parameters.acceptLanguage],
    requestBody: {
        parameterPath: "parameters",
        mapper: __assign(__assign({}, Mappers.ResourceChangesRequestParameters), { required: true })
    },
    responses: {
        200: {
            bodyMapper: Mappers.ResourceChangeList
        },
        default: {
            bodyMapper: Mappers.ErrorResponse
        }
    },
    serializer: serializer
};
var resourceChangeDetailsOperationSpec = {
    httpMethod: "POST",
    path: "providers/Microsoft.ResourceGraph/resourceChangeDetails",
    queryParameters: [Parameters.apiVersion0],
    headerParameters: [Parameters.acceptLanguage],
    requestBody: {
        parameterPath: "parameters",
        mapper: __assign(__assign({}, Mappers.ResourceChangeDetailsRequestParameters), { required: true })
    },
    responses: {
        200: {
            bodyMapper: {
                serializedName: "parsedResponse",
                type: {
                    name: "Sequence",
                    element: {
                        type: {
                            name: "Composite",
                            className: "ResourceChangeData"
                        }
                    }
                }
            }
        },
        default: {
            bodyMapper: Mappers.ErrorResponse
        }
    },
    serializer: serializer
};
var resourcesOperationSpec = {
    httpMethod: "POST",
    path: "providers/Microsoft.ResourceGraph/resources",
    queryParameters: [Parameters.apiVersion1],
    headerParameters: [Parameters.acceptLanguage],
    requestBody: {
        parameterPath: "query",
        mapper: __assign(__assign({}, Mappers.QueryRequest), { required: true })
    },
    responses: {
        200: {
            bodyMapper: Mappers.QueryResponse
        },
        default: {
            bodyMapper: Mappers.ErrorResponse
        }
    },
    serializer: serializer
};
var resourcesHistoryOperationSpec = {
    httpMethod: "POST",
    path: "providers/Microsoft.ResourceGraph/resourcesHistory",
    queryParameters: [Parameters.apiVersion2],
    headerParameters: [Parameters.acceptLanguage],
    requestBody: {
        parameterPath: "request",
        mapper: __assign(__assign({}, Mappers.ResourcesHistoryRequest), { required: true })
    },
    responses: {
        200: {
            bodyMapper: {
                serializedName: "parsedResponse",
                type: {
                    name: "Object"
                }
            }
        },
        default: {
            bodyMapper: Mappers.ErrorResponse
        }
    },
    serializer: serializer
};
export { ResourceGraphClient, ResourceGraphClientContext, Models as ResourceGraphModels, Mappers as ResourceGraphMappers };
export * from "./operations";
//# sourceMappingURL=resourceGraphClient.js.map