/*
 * Copyright (c) Microsoft Corporation.
 * Licensed under the MIT License.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 * Changes may cause incorrect behavior and will be lost if the code is regenerated.
 */
(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('@azure/ms-rest-js'), require('@azure/ms-rest-azure-js')) :
    typeof define === 'function' && define.amd ? define(['exports', '@azure/ms-rest-js', '@azure/ms-rest-azure-js'], factory) :
    (global = global || self, factory((global.Azure = global.Azure || {}, global.Azure.ArmResourcegraph = {}), global.msRest, global.msRestAzure));
}(this, (function (exports, msRest, msRestAzure) { 'use strict';

    /*! *****************************************************************************
    Copyright (c) Microsoft Corporation.

    Permission to use, copy, modify, and/or distribute this software for any
    purpose with or without fee is hereby granted.

    THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
    REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
    AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
    INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
    LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
    OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
    PERFORMANCE OF THIS SOFTWARE.
    ***************************************************************************** */
    /* global Reflect, Promise */

    var extendStatics = function(d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };

    function __extends(d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    }

    var __assign = function() {
        __assign = Object.assign || function __assign(t) {
            for (var s, i = 1, n = arguments.length; i < n; i++) {
                s = arguments[i];
                for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p)) t[p] = s[p];
            }
            return t;
        };
        return __assign.apply(this, arguments);
    };

    /*
     * Copyright (c) Microsoft Corporation.
     * Licensed under the MIT License.
     *
     * Code generated by Microsoft (R) AutoRest Code Generator.
     * Changes may cause incorrect behavior and will be lost if the code is regenerated.
     */

    var index = /*#__PURE__*/Object.freeze({
        __proto__: null
    });

    /*
     * Copyright (c) Microsoft Corporation.
     * Licensed under the MIT License.
     *
     * Code generated by Microsoft (R) AutoRest Code Generator.
     * Changes may cause incorrect behavior and will be lost if the code is regenerated.
     */
    var CloudError = msRestAzure.CloudErrorMapper;
    var BaseResource = msRestAzure.BaseResourceMapper;
    var DateTimeInterval = {
        serializedName: "DateTimeInterval",
        type: {
            name: "Composite",
            className: "DateTimeInterval",
            modelProperties: {
                start: {
                    required: true,
                    serializedName: "start",
                    type: {
                        name: "DateTime"
                    }
                },
                end: {
                    required: true,
                    serializedName: "end",
                    type: {
                        name: "DateTime"
                    }
                }
            }
        }
    };
    var ResourceChangesRequestParametersInterval = {
        serializedName: "ResourceChangesRequestParameters_interval",
        type: {
            name: "Composite",
            className: "ResourceChangesRequestParametersInterval",
            modelProperties: __assign({}, DateTimeInterval.type.modelProperties)
        }
    };
    var ResourceChangesRequestParameters = {
        serializedName: "ResourceChangesRequestParameters",
        type: {
            name: "Composite",
            className: "ResourceChangesRequestParameters",
            modelProperties: {
                resourceIds: {
                    serializedName: "resourceIds",
                    type: {
                        name: "Sequence",
                        element: {
                            type: {
                                name: "String"
                            }
                        }
                    }
                },
                subscriptionId: {
                    serializedName: "subscriptionId",
                    type: {
                        name: "String"
                    }
                },
                interval: {
                    required: true,
                    serializedName: "interval",
                    type: {
                        name: "Composite",
                        className: "ResourceChangesRequestParametersInterval"
                    }
                },
                skipToken: {
                    serializedName: "$skipToken",
                    type: {
                        name: "String"
                    }
                },
                top: {
                    serializedName: "$top",
                    constraints: {
                        InclusiveMaximum: 1000,
                        InclusiveMinimum: 1
                    },
                    type: {
                        name: "Number"
                    }
                },
                table: {
                    serializedName: "table",
                    type: {
                        name: "String"
                    }
                },
                fetchPropertyChanges: {
                    serializedName: "fetchPropertyChanges",
                    type: {
                        name: "Boolean"
                    }
                },
                fetchSnapshots: {
                    serializedName: "fetchSnapshots",
                    type: {
                        name: "Boolean"
                    }
                }
            }
        }
    };
    var ResourceSnapshotData = {
        serializedName: "ResourceSnapshotData",
        type: {
            name: "Composite",
            className: "ResourceSnapshotData",
            modelProperties: {
                snapshotId: {
                    serializedName: "snapshotId",
                    type: {
                        name: "String"
                    }
                },
                timestamp: {
                    required: true,
                    serializedName: "timestamp",
                    type: {
                        name: "DateTime"
                    }
                },
                content: {
                    serializedName: "content",
                    type: {
                        name: "Object"
                    }
                }
            }
        }
    };
    var ResourceChangeDataBeforeSnapshot = {
        serializedName: "ResourceChangeData_beforeSnapshot",
        type: {
            name: "Composite",
            className: "ResourceChangeDataBeforeSnapshot",
            modelProperties: __assign({}, ResourceSnapshotData.type.modelProperties)
        }
    };
    var ResourceChangeDataAfterSnapshot = {
        serializedName: "ResourceChangeData_afterSnapshot",
        type: {
            name: "Composite",
            className: "ResourceChangeDataAfterSnapshot",
            modelProperties: __assign({}, ResourceSnapshotData.type.modelProperties)
        }
    };
    var ResourcePropertyChange = {
        serializedName: "ResourcePropertyChange",
        type: {
            name: "Composite",
            className: "ResourcePropertyChange",
            modelProperties: {
                propertyName: {
                    required: true,
                    serializedName: "propertyName",
                    type: {
                        name: "String"
                    }
                },
                beforeValue: {
                    serializedName: "beforeValue",
                    type: {
                        name: "String"
                    }
                },
                afterValue: {
                    serializedName: "afterValue",
                    type: {
                        name: "String"
                    }
                },
                changeCategory: {
                    required: true,
                    serializedName: "changeCategory",
                    type: {
                        name: "Enum",
                        allowedValues: ["User", "System"]
                    }
                },
                propertyChangeType: {
                    required: true,
                    serializedName: "propertyChangeType",
                    type: {
                        name: "Enum",
                        allowedValues: ["Insert", "Update", "Remove"]
                    }
                }
            }
        }
    };
    var ResourceChangeData = {
        serializedName: "ResourceChangeData",
        type: {
            name: "Composite",
            className: "ResourceChangeData",
            modelProperties: {
                resourceId: {
                    serializedName: "resourceId",
                    type: {
                        name: "String"
                    }
                },
                changeId: {
                    required: true,
                    serializedName: "changeId",
                    type: {
                        name: "String"
                    }
                },
                beforeSnapshot: {
                    required: true,
                    serializedName: "beforeSnapshot",
                    type: {
                        name: "Composite",
                        className: "ResourceChangeDataBeforeSnapshot"
                    }
                },
                afterSnapshot: {
                    required: true,
                    serializedName: "afterSnapshot",
                    type: {
                        name: "Composite",
                        className: "ResourceChangeDataAfterSnapshot"
                    }
                },
                changeType: {
                    serializedName: "changeType",
                    type: {
                        name: "Enum",
                        allowedValues: ["Create", "Update", "Delete"]
                    }
                },
                propertyChanges: {
                    serializedName: "propertyChanges",
                    type: {
                        name: "Sequence",
                        element: {
                            type: {
                                name: "Composite",
                                className: "ResourcePropertyChange"
                            }
                        }
                    }
                }
            }
        }
    };
    var ResourceChangeList = {
        serializedName: "ResourceChangeList",
        type: {
            name: "Composite",
            className: "ResourceChangeList",
            modelProperties: {
                changes: {
                    serializedName: "changes",
                    type: {
                        name: "Sequence",
                        element: {
                            type: {
                                name: "Composite",
                                className: "ResourceChangeData"
                            }
                        }
                    }
                },
                skipToken: {
                    serializedName: "$skipToken",
                    type: {
                        name: "Object"
                    }
                }
            }
        }
    };
    var ResourceChangeDetailsRequestParameters = {
        serializedName: "ResourceChangeDetailsRequestParameters",
        type: {
            name: "Composite",
            className: "ResourceChangeDetailsRequestParameters",
            modelProperties: {
                resourceIds: {
                    required: true,
                    serializedName: "resourceIds",
                    type: {
                        name: "Sequence",
                        element: {
                            type: {
                                name: "String"
                            }
                        }
                    }
                },
                changeIds: {
                    required: true,
                    serializedName: "changeIds",
                    type: {
                        name: "Sequence",
                        element: {
                            type: {
                                name: "String"
                            }
                        }
                    }
                }
            }
        }
    };
    var ErrorDetails = {
        serializedName: "ErrorDetails",
        type: {
            name: "Composite",
            className: "ErrorDetails",
            modelProperties: {
                code: {
                    required: true,
                    serializedName: "code",
                    type: {
                        name: "String"
                    }
                },
                message: {
                    required: true,
                    serializedName: "message",
                    type: {
                        name: "String"
                    }
                }
            },
            additionalProperties: {
                type: {
                    name: "Object"
                }
            }
        }
    };
    var ErrorModel = {
        serializedName: "Error",
        type: {
            name: "Composite",
            className: "ErrorModel",
            modelProperties: {
                code: {
                    required: true,
                    serializedName: "code",
                    type: {
                        name: "String"
                    }
                },
                message: {
                    required: true,
                    serializedName: "message",
                    type: {
                        name: "String"
                    }
                },
                details: {
                    serializedName: "details",
                    type: {
                        name: "Sequence",
                        element: {
                            type: {
                                name: "Composite",
                                className: "ErrorDetails",
                                additionalProperties: {
                                    type: {
                                        name: "Object"
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    };
    var ErrorResponse = {
        serializedName: "ErrorResponse",
        type: {
            name: "Composite",
            className: "ErrorResponse",
            modelProperties: {
                error: {
                    required: true,
                    serializedName: "error",
                    type: {
                        name: "Composite",
                        className: "ErrorModel"
                    }
                }
            }
        }
    };
    var QueryRequestOptions = {
        serializedName: "QueryRequestOptions",
        type: {
            name: "Composite",
            className: "QueryRequestOptions",
            modelProperties: {
                skipToken: {
                    serializedName: "$skipToken",
                    type: {
                        name: "String"
                    }
                },
                top: {
                    serializedName: "$top",
                    constraints: {
                        InclusiveMaximum: 1000,
                        InclusiveMinimum: 1
                    },
                    type: {
                        name: "Number"
                    }
                },
                skip: {
                    serializedName: "$skip",
                    constraints: {
                        InclusiveMinimum: 0
                    },
                    type: {
                        name: "Number"
                    }
                },
                resultFormat: {
                    serializedName: "resultFormat",
                    defaultValue: "objectArray",
                    type: {
                        name: "Enum",
                        allowedValues: ["table", "objectArray"]
                    }
                },
                allowPartialScopes: {
                    serializedName: "allowPartialScopes",
                    defaultValue: false,
                    type: {
                        name: "Boolean"
                    }
                }
            }
        }
    };
    var FacetRequestOptions = {
        serializedName: "FacetRequestOptions",
        type: {
            name: "Composite",
            className: "FacetRequestOptions",
            modelProperties: {
                sortBy: {
                    serializedName: "sortBy",
                    type: {
                        name: "String"
                    }
                },
                sortOrder: {
                    serializedName: "sortOrder",
                    defaultValue: "desc",
                    type: {
                        name: "Enum",
                        allowedValues: ["asc", "desc"]
                    }
                },
                filter: {
                    serializedName: "filter",
                    type: {
                        name: "String"
                    }
                },
                top: {
                    serializedName: "$top",
                    constraints: {
                        InclusiveMaximum: 1000,
                        InclusiveMinimum: 1
                    },
                    type: {
                        name: "Number"
                    }
                }
            }
        }
    };
    var FacetRequest = {
        serializedName: "FacetRequest",
        type: {
            name: "Composite",
            className: "FacetRequest",
            modelProperties: {
                expression: {
                    required: true,
                    serializedName: "expression",
                    type: {
                        name: "String"
                    }
                },
                options: {
                    serializedName: "options",
                    type: {
                        name: "Composite",
                        className: "FacetRequestOptions"
                    }
                }
            }
        }
    };
    var QueryRequest = {
        serializedName: "QueryRequest",
        type: {
            name: "Composite",
            className: "QueryRequest",
            modelProperties: {
                subscriptions: {
                    serializedName: "subscriptions",
                    type: {
                        name: "Sequence",
                        element: {
                            type: {
                                name: "String"
                            }
                        }
                    }
                },
                managementGroups: {
                    serializedName: "managementGroups",
                    type: {
                        name: "Sequence",
                        element: {
                            type: {
                                name: "String"
                            }
                        }
                    }
                },
                query: {
                    required: true,
                    serializedName: "query",
                    type: {
                        name: "String"
                    }
                },
                options: {
                    serializedName: "options",
                    type: {
                        name: "Composite",
                        className: "QueryRequestOptions"
                    }
                },
                facets: {
                    serializedName: "facets",
                    type: {
                        name: "Sequence",
                        element: {
                            type: {
                                name: "Composite",
                                className: "FacetRequest"
                            }
                        }
                    }
                }
            }
        }
    };
    var Facet = {
        serializedName: "Facet",
        type: {
            name: "Composite",
            polymorphicDiscriminator: {
                serializedName: "resultType",
                clientName: "resultType"
            },
            uberParent: "Facet",
            className: "Facet",
            modelProperties: {
                expression: {
                    required: true,
                    serializedName: "expression",
                    type: {
                        name: "String"
                    }
                },
                resultType: {
                    required: true,
                    serializedName: "resultType",
                    type: {
                        name: "String"
                    }
                }
            }
        }
    };
    var QueryResponse = {
        serializedName: "QueryResponse",
        type: {
            name: "Composite",
            className: "QueryResponse",
            modelProperties: {
                totalRecords: {
                    required: true,
                    serializedName: "totalRecords",
                    type: {
                        name: "Number"
                    }
                },
                count: {
                    required: true,
                    serializedName: "count",
                    type: {
                        name: "Number"
                    }
                },
                resultTruncated: {
                    required: true,
                    serializedName: "resultTruncated",
                    type: {
                        name: "Enum",
                        allowedValues: ["true", "false"]
                    }
                },
                skipToken: {
                    serializedName: "$skipToken",
                    type: {
                        name: "String"
                    }
                },
                data: {
                    required: true,
                    serializedName: "data",
                    type: {
                        name: "Object"
                    }
                },
                facets: {
                    serializedName: "facets",
                    type: {
                        name: "Sequence",
                        element: {
                            type: {
                                name: "Composite",
                                className: "Facet"
                            }
                        }
                    }
                }
            }
        }
    };
    var Column = {
        serializedName: "Column",
        type: {
            name: "Composite",
            className: "Column",
            modelProperties: {
                name: {
                    required: true,
                    serializedName: "name",
                    type: {
                        name: "String"
                    }
                },
                type: {
                    required: true,
                    serializedName: "type",
                    type: {
                        name: "Enum",
                        allowedValues: ["string", "integer", "number", "boolean", "object"]
                    }
                }
            }
        }
    };
    var Table = {
        serializedName: "Table",
        type: {
            name: "Composite",
            className: "Table",
            modelProperties: {
                columns: {
                    required: true,
                    serializedName: "columns",
                    type: {
                        name: "Sequence",
                        element: {
                            type: {
                                name: "Composite",
                                className: "Column"
                            }
                        }
                    }
                },
                rows: {
                    required: true,
                    serializedName: "rows",
                    type: {
                        name: "Sequence",
                        element: {
                            type: {
                                name: "Sequence",
                                element: {
                                    type: {
                                        name: "Object"
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    };
    var FacetResult = {
        serializedName: "FacetResult",
        type: {
            name: "Composite",
            polymorphicDiscriminator: Facet.type.polymorphicDiscriminator,
            uberParent: "Facet",
            className: "FacetResult",
            modelProperties: __assign(__assign({}, Facet.type.modelProperties), { totalRecords: {
                    required: true,
                    serializedName: "totalRecords",
                    type: {
                        name: "Number"
                    }
                }, count: {
                    required: true,
                    serializedName: "count",
                    type: {
                        name: "Number"
                    }
                }, data: {
                    required: true,
                    serializedName: "data",
                    type: {
                        name: "Object"
                    }
                } })
        }
    };
    var FacetError = {
        serializedName: "FacetError",
        type: {
            name: "Composite",
            polymorphicDiscriminator: Facet.type.polymorphicDiscriminator,
            uberParent: "Facet",
            className: "FacetError",
            modelProperties: __assign(__assign({}, Facet.type.modelProperties), { errors: {
                    required: true,
                    serializedName: "errors",
                    type: {
                        name: "Sequence",
                        element: {
                            type: {
                                name: "Composite",
                                className: "ErrorDetails",
                                additionalProperties: {
                                    type: {
                                        name: "Object"
                                    }
                                }
                            }
                        }
                    }
                } })
        }
    };
    var OperationDisplay = {
        serializedName: "Operation_display",
        type: {
            name: "Composite",
            className: "OperationDisplay",
            modelProperties: {
                provider: {
                    serializedName: "provider",
                    type: {
                        name: "String"
                    }
                },
                resource: {
                    serializedName: "resource",
                    type: {
                        name: "String"
                    }
                },
                operation: {
                    serializedName: "operation",
                    type: {
                        name: "String"
                    }
                },
                description: {
                    serializedName: "description",
                    type: {
                        name: "String"
                    }
                }
            }
        }
    };
    var Operation = {
        serializedName: "Operation",
        type: {
            name: "Composite",
            className: "Operation",
            modelProperties: {
                name: {
                    serializedName: "name",
                    type: {
                        name: "String"
                    }
                },
                display: {
                    serializedName: "display",
                    type: {
                        name: "Composite",
                        className: "OperationDisplay"
                    }
                },
                origin: {
                    serializedName: "origin",
                    type: {
                        name: "String"
                    }
                }
            }
        }
    };
    var ResourcesHistoryRequestOptions = {
        serializedName: "ResourcesHistoryRequestOptions",
        type: {
            name: "Composite",
            className: "ResourcesHistoryRequestOptions",
            modelProperties: {
                interval: {
                    serializedName: "interval",
                    type: {
                        name: "Composite",
                        className: "DateTimeInterval"
                    }
                },
                top: {
                    serializedName: "$top",
                    type: {
                        name: "Number"
                    }
                },
                skip: {
                    serializedName: "$skip",
                    type: {
                        name: "Number"
                    }
                },
                skipToken: {
                    serializedName: "$skipToken",
                    type: {
                        name: "String"
                    }
                },
                resultFormat: {
                    serializedName: "resultFormat",
                    type: {
                        name: "String"
                    }
                }
            }
        }
    };
    var ResourcesHistoryRequest = {
        serializedName: "ResourcesHistoryRequest",
        type: {
            name: "Composite",
            className: "ResourcesHistoryRequest",
            modelProperties: {
                subscriptions: {
                    serializedName: "subscriptions",
                    type: {
                        name: "Sequence",
                        element: {
                            type: {
                                name: "String"
                            }
                        }
                    }
                },
                query: {
                    serializedName: "query",
                    type: {
                        name: "String"
                    }
                },
                options: {
                    serializedName: "options",
                    type: {
                        name: "Composite",
                        className: "ResourcesHistoryRequestOptions"
                    }
                },
                managementGroupId: {
                    serializedName: "managementGroupId",
                    type: {
                        name: "String"
                    }
                }
            }
        }
    };
    var OperationListResult = {
        serializedName: "OperationListResult",
        type: {
            name: "Composite",
            className: "OperationListResult",
            modelProperties: {
                value: {
                    serializedName: "",
                    type: {
                        name: "Sequence",
                        element: {
                            type: {
                                name: "Composite",
                                className: "Operation"
                            }
                        }
                    }
                }
            }
        }
    };
    var discriminators = {
        Facet: Facet,
        "Facet.FacetResult": FacetResult,
        "Facet.FacetError": FacetError
    };

    var Mappers = /*#__PURE__*/Object.freeze({
        __proto__: null,
        CloudError: CloudError,
        BaseResource: BaseResource,
        DateTimeInterval: DateTimeInterval,
        ResourceChangesRequestParametersInterval: ResourceChangesRequestParametersInterval,
        ResourceChangesRequestParameters: ResourceChangesRequestParameters,
        ResourceSnapshotData: ResourceSnapshotData,
        ResourceChangeDataBeforeSnapshot: ResourceChangeDataBeforeSnapshot,
        ResourceChangeDataAfterSnapshot: ResourceChangeDataAfterSnapshot,
        ResourcePropertyChange: ResourcePropertyChange,
        ResourceChangeData: ResourceChangeData,
        ResourceChangeList: ResourceChangeList,
        ResourceChangeDetailsRequestParameters: ResourceChangeDetailsRequestParameters,
        ErrorDetails: ErrorDetails,
        ErrorModel: ErrorModel,
        ErrorResponse: ErrorResponse,
        QueryRequestOptions: QueryRequestOptions,
        FacetRequestOptions: FacetRequestOptions,
        FacetRequest: FacetRequest,
        QueryRequest: QueryRequest,
        Facet: Facet,
        QueryResponse: QueryResponse,
        Column: Column,
        Table: Table,
        FacetResult: FacetResult,
        FacetError: FacetError,
        OperationDisplay: OperationDisplay,
        Operation: Operation,
        ResourcesHistoryRequestOptions: ResourcesHistoryRequestOptions,
        ResourcesHistoryRequest: ResourcesHistoryRequest,
        OperationListResult: OperationListResult,
        discriminators: discriminators
    });

    /*
     * Copyright (c) Microsoft Corporation.
     * Licensed under the MIT License.
     *
     * Code generated by Microsoft (R) AutoRest Code Generator.
     * Changes may cause incorrect behavior and will be lost if the code is
     * regenerated.
     */
    var acceptLanguage = {
        parameterPath: "acceptLanguage",
        mapper: {
            serializedName: "accept-language",
            defaultValue: "en-US",
            type: {
                name: "String"
            }
        }
    };
    var apiVersion0 = {
        parameterPath: "apiVersion",
        mapper: {
            required: true,
            isConstant: true,
            serializedName: "api-version",
            defaultValue: "2020-09-01-preview",
            type: {
                name: "String"
            }
        }
    };
    var apiVersion1 = {
        parameterPath: "apiVersion",
        mapper: {
            required: true,
            isConstant: true,
            serializedName: "api-version",
            defaultValue: "2021-03-01",
            type: {
                name: "String"
            }
        }
    };
    var apiVersion2 = {
        parameterPath: "apiVersion",
        mapper: {
            required: true,
            isConstant: true,
            serializedName: "api-version",
            defaultValue: "2020-04-01-preview",
            type: {
                name: "String"
            }
        }
    };

    /*
     * Copyright (c) Microsoft Corporation.
     * Licensed under the MIT License.
     *
     * Code generated by Microsoft (R) AutoRest Code Generator.
     * Changes may cause incorrect behavior and will be lost if the code is regenerated.
     */

    var Mappers$1 = /*#__PURE__*/Object.freeze({
        __proto__: null,
        discriminators: discriminators,
        ErrorDetails: ErrorDetails,
        ErrorModel: ErrorModel,
        ErrorResponse: ErrorResponse,
        Operation: Operation,
        OperationDisplay: OperationDisplay,
        OperationListResult: OperationListResult
    });

    /*
     * Copyright (c) Microsoft Corporation.
     * Licensed under the MIT License.
     *
     * Code generated by Microsoft (R) AutoRest Code Generator.
     * Changes may cause incorrect behavior and will be lost if the code is
     * regenerated.
     */
    /** Class representing a Operations. */
    var Operations = /** @class */ (function () {
        /**
         * Create a Operations.
         * @param {ResourceGraphClientContext} client Reference to the service client.
         */
        function Operations(client) {
            this.client = client;
        }
        Operations.prototype.list = function (options, callback) {
            return this.client.sendOperationRequest({
                options: options
            }, listOperationSpec, callback);
        };
        return Operations;
    }());
    // Operation Specifications
    var serializer = new msRest.Serializer(Mappers$1);
    var listOperationSpec = {
        httpMethod: "GET",
        path: "providers/Microsoft.ResourceGraph/operations",
        queryParameters: [apiVersion1],
        headerParameters: [acceptLanguage],
        responses: {
            200: {
                bodyMapper: OperationListResult
            },
            default: {
                bodyMapper: ErrorResponse
            }
        },
        serializer: serializer
    };

    /*
     * Copyright (c) Microsoft Corporation.
     * Licensed under the MIT License.
     *
     * Code generated by Microsoft (R) AutoRest Code Generator.
     * Changes may cause incorrect behavior and will be lost if the code is
     * regenerated.
     */
    var packageName = "@azure/arm-resourcegraph";
    var packageVersion = "4.2.1";
    var ResourceGraphClientContext = /** @class */ (function (_super) {
        __extends(ResourceGraphClientContext, _super);
        /**
         * Initializes a new instance of the ResourceGraphClient class.
         * @param credentials Credentials needed for the client to connect to Azure. Credentials
         * implementing the TokenCredential interface from the @azure/identity package are recommended. For
         * more information about these credentials, see
         * {@link https://www.npmjs.com/package/@azure/identity}. Credentials implementing the
         * ServiceClientCredentials interface from the older packages @azure/ms-rest-nodeauth and
         * @azure/ms-rest-browserauth are also supported.
         * @param [options] The parameter options
         */
        function ResourceGraphClientContext(credentials, options) {
            var _this = this;
            if (credentials == undefined) {
                throw new Error("'credentials' cannot be null.");
            }
            if (!options) {
                options = {};
            }
            if (!options.userAgent) {
                var defaultUserAgent = msRestAzure.getDefaultUserAgentValue();
                options.userAgent = packageName + "/" + packageVersion + " " + defaultUserAgent;
            }
            _this = _super.call(this, credentials, options) || this;
            _this.acceptLanguage = "en-US";
            _this.longRunningOperationRetryTimeout = 30;
            _this.baseUri = options.baseUri || _this.baseUri || "https://management.azure.com";
            _this.requestContentType = "application/json; charset=utf-8";
            _this.credentials = credentials;
            if (options.acceptLanguage !== null && options.acceptLanguage !== undefined) {
                _this.acceptLanguage = options.acceptLanguage;
            }
            if (options.longRunningOperationRetryTimeout !== null &&
                options.longRunningOperationRetryTimeout !== undefined) {
                _this.longRunningOperationRetryTimeout = options.longRunningOperationRetryTimeout;
            }
            return _this;
        }
        return ResourceGraphClientContext;
    }(msRestAzure.AzureServiceClient));

    /*
     * Copyright (c) Microsoft Corporation.
     * Licensed under the MIT License.
     *
     * Code generated by Microsoft (R) AutoRest Code Generator.
     * Changes may cause incorrect behavior and will be lost if the code is
     * regenerated.
     */
    var ResourceGraphClient = /** @class */ (function (_super) {
        __extends(ResourceGraphClient, _super);
        /**
         * Initializes a new instance of the ResourceGraphClient class.
         * @param credentials Credentials needed for the client to connect to Azure. Credentials
         * implementing the TokenCredential interface from the @azure/identity package are recommended. For
         * more information about these credentials, see
         * {@link https://www.npmjs.com/package/@azure/identity}. Credentials implementing the
         * ServiceClientCredentials interface from the older packages @azure/ms-rest-nodeauth and
         * @azure/ms-rest-browserauth are also supported.
         * @param [options] The parameter options
         */
        function ResourceGraphClient(credentials, options) {
            var _this = _super.call(this, credentials, options) || this;
            _this.operations = new Operations(_this);
            return _this;
        }
        ResourceGraphClient.prototype.resourceChanges = function (parameters, options, callback) {
            return this.sendOperationRequest({
                parameters: parameters,
                options: options
            }, resourceChangesOperationSpec, callback);
        };
        ResourceGraphClient.prototype.resourceChangeDetails = function (parameters, options, callback) {
            return this.sendOperationRequest({
                parameters: parameters,
                options: options
            }, resourceChangeDetailsOperationSpec, callback);
        };
        ResourceGraphClient.prototype.resources = function (query, options, callback) {
            return this.sendOperationRequest({
                query: query,
                options: options
            }, resourcesOperationSpec, callback);
        };
        ResourceGraphClient.prototype.resourcesHistory = function (request, options, callback) {
            return this.sendOperationRequest({
                request: request,
                options: options
            }, resourcesHistoryOperationSpec, callback);
        };
        return ResourceGraphClient;
    }(ResourceGraphClientContext));
    // Operation Specifications
    var serializer$1 = new msRest.Serializer(Mappers);
    var resourceChangesOperationSpec = {
        httpMethod: "POST",
        path: "providers/Microsoft.ResourceGraph/resourceChanges",
        queryParameters: [apiVersion0],
        headerParameters: [acceptLanguage],
        requestBody: {
            parameterPath: "parameters",
            mapper: __assign(__assign({}, ResourceChangesRequestParameters), { required: true })
        },
        responses: {
            200: {
                bodyMapper: ResourceChangeList
            },
            default: {
                bodyMapper: ErrorResponse
            }
        },
        serializer: serializer$1
    };
    var resourceChangeDetailsOperationSpec = {
        httpMethod: "POST",
        path: "providers/Microsoft.ResourceGraph/resourceChangeDetails",
        queryParameters: [apiVersion0],
        headerParameters: [acceptLanguage],
        requestBody: {
            parameterPath: "parameters",
            mapper: __assign(__assign({}, ResourceChangeDetailsRequestParameters), { required: true })
        },
        responses: {
            200: {
                bodyMapper: {
                    serializedName: "parsedResponse",
                    type: {
                        name: "Sequence",
                        element: {
                            type: {
                                name: "Composite",
                                className: "ResourceChangeData"
                            }
                        }
                    }
                }
            },
            default: {
                bodyMapper: ErrorResponse
            }
        },
        serializer: serializer$1
    };
    var resourcesOperationSpec = {
        httpMethod: "POST",
        path: "providers/Microsoft.ResourceGraph/resources",
        queryParameters: [apiVersion1],
        headerParameters: [acceptLanguage],
        requestBody: {
            parameterPath: "query",
            mapper: __assign(__assign({}, QueryRequest), { required: true })
        },
        responses: {
            200: {
                bodyMapper: QueryResponse
            },
            default: {
                bodyMapper: ErrorResponse
            }
        },
        serializer: serializer$1
    };
    var resourcesHistoryOperationSpec = {
        httpMethod: "POST",
        path: "providers/Microsoft.ResourceGraph/resourcesHistory",
        queryParameters: [apiVersion2],
        headerParameters: [acceptLanguage],
        requestBody: {
            parameterPath: "request",
            mapper: __assign(__assign({}, ResourcesHistoryRequest), { required: true })
        },
        responses: {
            200: {
                bodyMapper: {
                    serializedName: "parsedResponse",
                    type: {
                        name: "Object"
                    }
                }
            },
            default: {
                bodyMapper: ErrorResponse
            }
        },
        serializer: serializer$1
    };

    exports.Operations = Operations;
    exports.ResourceGraphClient = ResourceGraphClient;
    exports.ResourceGraphClientContext = ResourceGraphClientContext;
    exports.ResourceGraphMappers = Mappers;
    exports.ResourceGraphModels = index;

    Object.defineProperty(exports, '__esModule', { value: true });

})));
//# sourceMappingURL=arm-resourcegraph.js.map
